/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.v2.transport.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.NonNull;
import org.nd4j.common.primitives.Atomic;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.parameterserver.distributed.conf.VoidConfiguration;
import org.nd4j.parameterserver.distributed.v2.messages.RequestMessage;
import org.nd4j.parameterserver.distributed.v2.messages.VoidMessage;
import org.nd4j.parameterserver.distributed.v2.transport.MessageCallable;
import org.nd4j.parameterserver.distributed.v2.transport.Transport;
import org.nd4j.parameterserver.distributed.v2.transport.impl.BaseTransport;
import org.nd4j.parameterserver.distributed.v2.util.MeshOrganizer;
import org.nd4j.parameterserver.distributed.v2.util.MessageSplitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyTransport
extends BaseTransport {
    private static final Logger log = LoggerFactory.getLogger(DummyTransport.class);
    protected Map<String, MessageCallable> interceptors = new HashMap<String, MessageCallable>();
    protected Map<String, MessageCallable> precursors = new HashMap<String, MessageCallable>();
    protected final Connector connector;

    public DummyTransport(String id, Connector connector) {
        this.id = id;
        this.connector = connector;
        this.splitter = new MessageSplitter();
    }

    public DummyTransport(String id, Connector connector, @NonNull String rootId) {
        super(rootId);
        if (rootId == null) {
            throw new NullPointerException("rootId is marked non-null but is null");
        }
        this.id = id;
        this.connector = connector;
        this.splitter = new MessageSplitter();
    }

    public DummyTransport(String id, Connector connector, @NonNull String rootId, @NonNull VoidConfiguration configuration) {
        super(rootId, configuration);
        if (rootId == null) {
            throw new NullPointerException("rootId is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.id = id;
        this.connector = connector;
        this.splitter = new MessageSplitter();
    }

    @Override
    public void launch() {
        super.launch();
    }

    @Override
    public void sendMessage(@NonNull VoidMessage message, @NonNull String id) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (message.getOriginatorId() == null) {
            message.setOriginatorId(this.id());
        }
        if (message instanceof RequestMessage && ((RequestMessage)message).getRequestId() == null) {
            ((RequestMessage)message).setRequestId(UUID.randomUUID().toString());
        }
        this.connector.transferMessage(message, this.id(), id);
    }

    @Override
    public String id() {
        return this.id;
    }

    public <T extends VoidMessage> void addInterceptor(@NonNull Class<T> cls, @NonNull MessageCallable<T> callable) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        if (callable == null) {
            throw new NullPointerException("callable is marked non-null but is null");
        }
        this.interceptors.put(cls.getCanonicalName(), callable);
    }

    public <T extends VoidMessage> void addPrecursor(@NonNull Class<T> cls, @NonNull MessageCallable<T> callable) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        if (callable == null) {
            throw new NullPointerException("callable is marked non-null but is null");
        }
        this.precursors.put(cls.getCanonicalName(), callable);
    }

    @Override
    public void processMessage(@NonNull VoidMessage message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        String name = message.getClass().getCanonicalName();
        MessageCallable callable = this.interceptors.get(name);
        if (callable != null) {
            callable.apply(message);
        } else {
            MessageCallable precursor = this.precursors.get(name);
            if (precursor != null) {
                precursor.apply(message);
            }
            super.internalProcessMessage(message);
        }
    }

    @Override
    protected void internalProcessMessage(VoidMessage message) {
        this.processMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeshOrganizer getMesh() {
        Atomic atomic = this.mesh;
        synchronized (atomic) {
            return (MeshOrganizer)this.mesh.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMesh(MeshOrganizer mesh) {
        Atomic atomic = this.mesh;
        synchronized (atomic) {
            this.mesh.set((Serializable)mesh);
        }
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    public static class Connector {
        private Map<String, Transport> transports = new ConcurrentHashMap<String, Transport>();
        private ThreadPoolExecutor executorService = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){

            @Override
            public Thread newThread(@NonNull Runnable r) {
                if (r == null) {
                    throw new NullPointerException("r is marked non-null but is null");
                }
                Thread t = Executors.defaultThreadFactory().newThread(r);
                return t;
            }
        });

        public void register(Transport ... transports) {
            for (Transport transport : transports) {
                this.transports.putIfAbsent(transport.id(), transport);
            }
        }

        public void blockUntilFinished() throws InterruptedException {
            long timeStart = System.currentTimeMillis();
            while (this.executorService.getActiveCount() > 0 && this.executorService.getQueue().size() > 0) {
                Thread.sleep(500L);
            }
            long timeStop = System.currentTimeMillis();
            if (timeStop - timeStart < 700L) {
                Thread.sleep(700L);
            }
        }

        public void transferMessage(@NonNull VoidMessage message, @NonNull String senderId, @NonNull String targetId) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            if (senderId == null) {
                throw new NullPointerException("senderId is marked non-null but is null");
            }
            if (targetId == null) {
                throw new NullPointerException("targetId is marked non-null but is null");
            }
            Transport target = this.transports.get(targetId);
            if (target == null) {
                throw new ND4JIllegalStateException("Unknown target specified");
            }
            target.processMessage(message);
        }

        public ExecutorService executorService() {
            return this.executorService;
        }

        public void dropConnection(String ... ids) {
            if (ids == null) {
                throw new NullPointerException("ids is marked non-null but is null");
            }
            Arrays.stream(ids).filter(Objects::nonNull).forEach(this.transports::remove);
        }
    }
}

