/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.protobuf.common.graph;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import org.nd4j.shade.protobuf.common.annotations.Beta;
import org.nd4j.shade.protobuf.common.base.Function;
import org.nd4j.shade.protobuf.common.base.Functions;
import org.nd4j.shade.protobuf.common.base.Preconditions;
import org.nd4j.shade.protobuf.common.collect.ImmutableMap;
import org.nd4j.shade.protobuf.common.collect.Maps;
import org.nd4j.shade.protobuf.common.graph.BaseGraph;
import org.nd4j.shade.protobuf.common.graph.ConfigurableValueGraph;
import org.nd4j.shade.protobuf.common.graph.DirectedGraphConnections;
import org.nd4j.shade.protobuf.common.graph.EndpointPair;
import org.nd4j.shade.protobuf.common.graph.ForwardingGraph;
import org.nd4j.shade.protobuf.common.graph.Graph;
import org.nd4j.shade.protobuf.common.graph.GraphBuilder;
import org.nd4j.shade.protobuf.common.graph.GraphConnections;
import org.nd4j.shade.protobuf.common.graph.GraphConstants;
import org.nd4j.shade.protobuf.common.graph.MutableGraph;
import org.nd4j.shade.protobuf.common.graph.UndirectedGraphConnections;

@Immutable(containerOf={"N"})
@Beta
public class ImmutableGraph<N>
extends ForwardingGraph<N> {
    private final BaseGraph<N> backingGraph;

    ImmutableGraph(BaseGraph<N> backingGraph) {
        this.backingGraph = backingGraph;
    }

    public static <N> ImmutableGraph<N> copyOf(Graph<N> graph) {
        return graph instanceof ImmutableGraph ? (ImmutableGraph<N>)graph : new ImmutableGraph<N>(new ConfigurableValueGraph<N, GraphConstants.Presence>(GraphBuilder.from(graph), ImmutableGraph.getNodeConnections(graph), graph.edges().size()));
    }

    @Deprecated
    public static <N> ImmutableGraph<N> copyOf(ImmutableGraph<N> graph) {
        return Preconditions.checkNotNull(graph);
    }

    private static <N> ImmutableMap<N, GraphConnections<N, GraphConstants.Presence>> getNodeConnections(Graph<N> graph) {
        ImmutableMap.Builder<N, GraphConnections<N, GraphConstants.Presence>> nodeConnections = ImmutableMap.builder();
        for (N node : graph.nodes()) {
            nodeConnections.put(node, ImmutableGraph.connectionsOf(graph, node));
        }
        return nodeConnections.build();
    }

    private static <N> GraphConnections<N, GraphConstants.Presence> connectionsOf(Graph<N> graph, N node) {
        Function<Object, GraphConstants.Presence> edgeValueFn = Functions.constant(GraphConstants.Presence.EDGE_EXISTS);
        return graph.isDirected() ? DirectedGraphConnections.ofImmutable(graph.predecessors(node), Maps.asMap(graph.successors(node), edgeValueFn)) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph.adjacentNodes(node), edgeValueFn));
    }

    @Override
    protected BaseGraph<N> delegate() {
        return this.backingGraph;
    }

    public static class Builder<N> {
        private final MutableGraph<N> mutableGraph;

        Builder(GraphBuilder<N> graphBuilder) {
            this.mutableGraph = graphBuilder.build();
        }

        @CanIgnoreReturnValue
        public Builder<N> addNode(N node) {
            this.mutableGraph.addNode(node);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N> putEdge(N nodeU, N nodeV) {
            this.mutableGraph.putEdge(nodeU, nodeV);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N> putEdge(EndpointPair<N> endpoints) {
            this.mutableGraph.putEdge(endpoints);
            return this;
        }

        public ImmutableGraph<N> build() {
            return ImmutableGraph.copyOf(this.mutableGraph);
        }
    }
}

