/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.protobuf.common.graph;

import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;
import org.nd4j.shade.protobuf.common.annotations.Beta;
import org.nd4j.shade.protobuf.common.base.Function;
import org.nd4j.shade.protobuf.common.collect.Maps;
import org.nd4j.shade.protobuf.common.graph.AbstractBaseGraph;
import org.nd4j.shade.protobuf.common.graph.AbstractGraph;
import org.nd4j.shade.protobuf.common.graph.ElementOrder;
import org.nd4j.shade.protobuf.common.graph.EndpointPair;
import org.nd4j.shade.protobuf.common.graph.Graph;
import org.nd4j.shade.protobuf.common.graph.ValueGraph;

@Beta
public abstract class AbstractValueGraph<N, V>
extends AbstractBaseGraph<N>
implements ValueGraph<N, V> {
    @Override
    public Graph<N> asGraph() {
        return new AbstractGraph<N>(){

            @Override
            public Set<N> nodes() {
                return AbstractValueGraph.this.nodes();
            }

            @Override
            public Set<EndpointPair<N>> edges() {
                return AbstractValueGraph.this.edges();
            }

            @Override
            public boolean isDirected() {
                return AbstractValueGraph.this.isDirected();
            }

            @Override
            public boolean allowsSelfLoops() {
                return AbstractValueGraph.this.allowsSelfLoops();
            }

            @Override
            public ElementOrder<N> nodeOrder() {
                return AbstractValueGraph.this.nodeOrder();
            }

            @Override
            public Set<N> adjacentNodes(N node) {
                return AbstractValueGraph.this.adjacentNodes(node);
            }

            @Override
            public Set<N> predecessors(N node) {
                return AbstractValueGraph.this.predecessors(node);
            }

            @Override
            public Set<N> successors(N node) {
                return AbstractValueGraph.this.successors(node);
            }

            @Override
            public int degree(N node) {
                return AbstractValueGraph.this.degree(node);
            }

            @Override
            public int inDegree(N node) {
                return AbstractValueGraph.this.inDegree(node);
            }

            @Override
            public int outDegree(N node) {
                return AbstractValueGraph.this.outDegree(node);
            }
        };
    }

    @Override
    public final boolean equals(@NullableDecl Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ValueGraph)) {
            return false;
        }
        ValueGraph other = (ValueGraph)obj;
        return this.isDirected() == other.isDirected() && this.nodes().equals(other.nodes()) && AbstractValueGraph.edgeValueMap(this).equals(AbstractValueGraph.edgeValueMap(other));
    }

    @Override
    public final int hashCode() {
        return AbstractValueGraph.edgeValueMap(this).hashCode();
    }

    public String toString() {
        return "isDirected: " + this.isDirected() + ", allowsSelfLoops: " + this.allowsSelfLoops() + ", nodes: " + this.nodes() + ", edges: " + AbstractValueGraph.edgeValueMap(this);
    }

    private static <N, V> Map<EndpointPair<N>, V> edgeValueMap(final ValueGraph<N, V> graph) {
        Function edgeToValueFn = new Function<EndpointPair<N>, V>(){

            @Override
            public V apply(EndpointPair<N> edge) {
                return graph.edgeValueOrDefault(edge.nodeU(), edge.nodeV(), null);
            }
        };
        return Maps.asMap(graph.edges(), edgeToValueFn);
    }
}

