/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis;

import com.alibaba.fastjson.parser.ParserConfig;
import com.vesoft.nebula.client.graph.net.Session;
import org.nebula.contrib.ngbatis.ArgNameFormatter;
import org.nebula.contrib.ngbatis.ArgsResolver;
import org.nebula.contrib.ngbatis.PkGenerator;
import org.nebula.contrib.ngbatis.ResultResolver;
import org.nebula.contrib.ngbatis.TextResolver;
import org.nebula.contrib.ngbatis.config.ParseCfgProps;
import org.nebula.contrib.ngbatis.models.MapperContext;
import org.nebula.contrib.ngbatis.proxy.MapperProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class Env {
    public static ClassLoader classLoader;
    private Logger log = LoggerFactory.getLogger(Env.class);
    private TextResolver textResolver;
    private ResultResolver resultResolver;
    private ArgsResolver argsResolver;
    private ArgNameFormatter argNameFormatter;
    private ParseCfgProps cfgProps;
    private ApplicationContext context;
    private String username;
    private String password;
    private boolean reconnect = false;
    private String space;
    private PkGenerator pkGenerator;
    private MapperContext mapperContext;
    static final ThreadLocal<Session> SESSION_CACHE;

    public Env() {
    }

    public Env(TextResolver textResolver, ResultResolver resultResolver, ArgsResolver argsResolver, ArgNameFormatter argNameFormatter, ParseCfgProps cfgProps, ApplicationContext applicationContext, String username, String password, boolean reconnect, String space, PkGenerator pkGenerator) {
        this.textResolver = textResolver;
        this.resultResolver = resultResolver;
        this.argsResolver = argsResolver;
        this.argNameFormatter = argNameFormatter;
        this.cfgProps = cfgProps;
        this.context = applicationContext;
        this.username = username;
        this.password = password;
        this.reconnect = reconnect;
        this.space = space;
        this.pkGenerator = pkGenerator;
        this.mapperContext = MapperContext.newInstance();
        MapperProxy.ENV = this;
        this.log.debug(" Env constructor ");
    }

    public Session openSession() {
        try {
            return this.mapperContext.getNebulaPool().getSession(this.username, this.password, this.reconnect);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public TextResolver getTextResolver() {
        return this.textResolver;
    }

    public void setTextResolver(TextResolver textResolver) {
        this.textResolver = textResolver;
    }

    public ResultResolver getResultResolver() {
        return this.resultResolver;
    }

    public void setResultResolver(ResultResolver resultResolver) {
        this.resultResolver = resultResolver;
    }

    public ArgsResolver getArgsResolver() {
        return this.argsResolver;
    }

    public void setArgsResolver(ArgsResolver argsResolver) {
        this.argsResolver = argsResolver;
    }

    public ArgNameFormatter getArgNameFormatter() {
        return this.argNameFormatter;
    }

    public void setArgNameFormatter(ArgNameFormatter argNameFormatter) {
        this.argNameFormatter = argNameFormatter;
    }

    public ParseCfgProps getCfgProps() {
        return this.cfgProps;
    }

    public void setCfgProps(ParseCfgProps cfgProps) {
        this.cfgProps = cfgProps;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
    }

    public String getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public MapperContext getMapperContext() {
        return this.mapperContext;
    }

    public void setMapperContext(MapperContext mapperContext) {
        this.mapperContext = mapperContext;
    }

    public PkGenerator getPkGenerator() {
        return this.pkGenerator;
    }

    public void setPkGenerator(PkGenerator pkGenerator) {
        this.pkGenerator = pkGenerator;
    }

    static {
        ParserConfig.getGlobalInstance().setSafeMode(true);
        SESSION_CACHE = new ThreadLocal();
    }
}

