/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis;

import com.vesoft.nebula.client.graph.NebulaPoolConfig;
import java.util.Objects;
import org.nebula.contrib.ngbatis.Env;
import org.nebula.contrib.ngbatis.NgbatisBeanFactoryPostProcessor;
import org.nebula.contrib.ngbatis.config.NebulaJdbcProperties;
import org.nebula.contrib.ngbatis.config.ParseCfgProps;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class NgbatisContextInitializer
implements ApplicationContextInitializer {
    public void initialize(ConfigurableApplicationContext context) {
        Env.classLoader = context.getClassLoader();
        ConfigurableEnvironment environment = context.getEnvironment();
        NebulaPoolConfig nebulaPool = this.getNebulaPoolConfig(environment);
        NebulaJdbcProperties nebulaJdbcProperties = this.getNebulaJdbcProperties(environment).setPoolConfig(nebulaPool);
        ParseCfgProps parseCfgProps = this.readParseCfgProps(environment);
        context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new NgbatisBeanFactoryPostProcessor(nebulaJdbcProperties, parseCfgProps, context));
    }

    private ParseCfgProps readParseCfgProps(ConfigurableEnvironment environment) {
        return new ParseCfgProps().setId(environment.getProperty("cql.parser.id")).setLogShow(environment.getProperty("cql.parser.log-show")).setMapper(environment.getProperty("cql.parser.mapper")).setNamespace(environment.getProperty("cql.parser.namespace")).setMapperLocations(environment.getProperty("cql.parser.mapper-locations")).setMapperTplLocation(environment.getProperty("cql.parser.mapper-tpl-location")).setResultType(environment.getProperty("cql.parser.result-type")).setParameterType(environment.getProperty("cql.parser.parameter-type")).setStatementEnd(environment.getProperty("cql.parser.statement-end")).setStatementStart(environment.getProperty("cql.parser.statement-start")).setResourceRefresh((Boolean)environment.getProperty("cql.parser.statement-start", Boolean.class));
    }

    private NebulaJdbcProperties getNebulaJdbcProperties(ConfigurableEnvironment environment) {
        NebulaJdbcProperties nebulaJdbcProperties = new NebulaJdbcProperties();
        return nebulaJdbcProperties.setHosts(Objects.requireNonNull(environment.getProperty("nebula.hosts"))).setUsername(environment.getProperty("nebula.username")).setPassword(environment.getProperty("nebula.password")).setSpace(environment.getProperty("nebula.space"));
    }

    private NebulaPoolConfig getNebulaPoolConfig(ConfigurableEnvironment environment) {
        NebulaPoolConfig nebulaPoolConfig = new NebulaPoolConfig().setMinConnSize(((Integer)environment.getProperty("nebula.pool-config.min-conn-size", Integer.class, (Object)0)).intValue()).setMaxConnSize(((Integer)environment.getProperty("nebula.pool-config.max-conn-size", Integer.class, (Object)10)).intValue()).setTimeout(((Integer)environment.getProperty("nebula.pool-config.timeout", Integer.class, (Object)0)).intValue()).setIdleTime(((Integer)environment.getProperty("nebula.pool-config.idle-time", Integer.class, (Object)0)).intValue()).setIntervalIdle(((Integer)environment.getProperty("nebula.pool-config.interval-idle", Integer.class, (Object)-1)).intValue()).setWaitTime(((Integer)environment.getProperty("nebula.pool-config.wait-time", Integer.class, (Object)0)).intValue());
        return nebulaPoolConfig;
    }
}

