/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.aop;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.nebula.contrib.ngbatis.annotations.TimeLog;
import org.nebula.contrib.ngbatis.config.ParseCfgProps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAdvice {
    private Logger logger = LoggerFactory.getLogger(LogAdvice.class);
    @Autowired
    private ParseCfgProps props;

    @Pointcut(value="@annotation(org.nebula.contrib.ngbatis.annotations.TimeLog)")
    public void timeLog() {
    }

    @Around(value="timeLog()")
    public Object msCount(ProceedingJoinPoint pjp) throws Throwable {
        TimeLog annotation = ((MethodSignature)pjp.getSignature()).getMethod().getAnnotation(TimeLog.class);
        long start = System.currentTimeMillis();
        Object result = pjp.proceed();
        long end = System.currentTimeMillis();
        String name = annotation.name();
        if (this.props.getLogShowTypes().contains(name)) {
            this.logger.info(annotation.explain(), (Object)(end - start));
        }
        return result;
    }
}

