/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.util.Strings;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="cql.parser")
public class ParseCfgProps {
    private String mapperTplLocation = "NebulaDaoBasic.xml";
    private String mapperLocations = "mapper/**/*.xml";
    private String id = "id";
    private String namespace = "namespace";
    private String resultType = "resultType";
    private String parameterType = "parameterType";
    private String mapper = "mapper";
    private String statementStart = "@";
    private String statementEnd = null;
    private String logShow = "xml-load,env-init,query";
    private Set<String> logShowTypes = null;
    private boolean resourceRefresh = false;

    public ParseCfgProps setLogShow(String logShow) {
        if (Strings.isBlank((String)logShow)) {
            return this;
        }
        this.logShow = logShow;
        this.logShowTypes = new HashSet<String>(Arrays.asList(logShow.split(",")));
        return this;
    }

    public String getMapperTplLocation() {
        return this.mapperTplLocation;
    }

    public ParseCfgProps setMapperTplLocation(String mapperTplLocation) {
        if (Strings.isBlank((String)mapperTplLocation)) {
            return this;
        }
        this.mapperTplLocation = mapperTplLocation;
        return this;
    }

    public String getMapperLocations() {
        return this.mapperLocations;
    }

    public ParseCfgProps setMapperLocations(String mapperLocations) {
        if (Strings.isBlank((String)mapperLocations)) {
            return this;
        }
        this.mapperLocations = mapperLocations;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public ParseCfgProps setId(String id) {
        if (Strings.isBlank((String)id)) {
            return this;
        }
        this.id = id;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ParseCfgProps setNamespace(String namespace) {
        if (Strings.isBlank((String)namespace)) {
            return this;
        }
        this.namespace = namespace;
        return this;
    }

    public String getResultType() {
        return this.resultType;
    }

    public ParseCfgProps setResultType(String resultType) {
        if (Strings.isBlank((String)resultType)) {
            return this;
        }
        this.resultType = resultType;
        return this;
    }

    public String getParameterType() {
        return this.parameterType;
    }

    public ParseCfgProps setParameterType(String parameterType) {
        if (Strings.isBlank((String)parameterType)) {
            return this;
        }
        this.parameterType = parameterType;
        return this;
    }

    public String getMapper() {
        return this.mapper;
    }

    public ParseCfgProps setMapper(String mapper) {
        if (Strings.isBlank((String)mapper)) {
            return this;
        }
        this.mapper = mapper;
        return this;
    }

    public String getStatementStart() {
        return this.statementStart;
    }

    public ParseCfgProps setStatementStart(String statementStart) {
        if (Strings.isBlank((String)statementStart)) {
            return this;
        }
        this.statementStart = statementStart;
        return this;
    }

    public String getStatementEnd() {
        return this.statementEnd;
    }

    public ParseCfgProps setStatementEnd(String statementEnd) {
        if (Strings.isBlank((String)statementEnd)) {
            return this;
        }
        this.statementEnd = statementEnd;
        return this;
    }

    public String getLogShow() {
        return this.logShow;
    }

    public Set<String> getLogShowTypes() {
        return this.logShowTypes;
    }

    public ParseCfgProps setLogShowTypes(Set<String> logShowTypes) {
        if (ObjectUtils.isEmpty(logShowTypes)) {
            return this;
        }
        this.logShowTypes = logShowTypes;
        return this;
    }

    public boolean isResourceRefresh() {
        return this.resourceRefresh;
    }

    public ParseCfgProps setResourceRefresh(Boolean resourceRefresh) {
        if (resourceRefresh == null) {
            return this;
        }
        this.resourceRefresh = resourceRefresh;
        return this;
    }
}

