/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.io;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.nebula.contrib.ngbatis.annotations.TimeLog;
import org.nebula.contrib.ngbatis.config.ParseCfgProps;
import org.nebula.contrib.ngbatis.exception.ParseException;
import org.nebula.contrib.ngbatis.exception.ResourceLoadException;
import org.nebula.contrib.ngbatis.models.ClassModel;
import org.nebula.contrib.ngbatis.models.MethodModel;
import org.nebula.contrib.ngbatis.utils.Page;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;

public class MapperResourceLoader
extends PathMatchingResourcePatternResolver {
    private static Logger log = LoggerFactory.getLogger(MapperResourceLoader.class);
    protected ParseCfgProps parseConfig;

    private MapperResourceLoader() {
    }

    public MapperResourceLoader(ParseCfgProps parseConfig) {
        this.parseConfig = parseConfig;
    }

    @TimeLog(name="xml-load", explain="mappers xml load completed : {} ms")
    public Map<String, ClassModel> load() {
        HashMap<String, ClassModel> resultClassModel = new HashMap<String, ClassModel>();
        try {
            Resource[] resources;
            for (Resource resource : resources = this.getResources(this.parseConfig.getMapperLocations())) {
                resultClassModel.putAll(this.parseClassModel(resource));
            }
        }
        catch (IOException e) {
            throw new ResourceLoadException(e);
        }
        return resultClassModel;
    }

    public Map<String, ClassModel> parseClassModel(Resource resource) throws IOException {
        HashMap<String, ClassModel> result = new HashMap<String, ClassModel>();
        Document doc = Jsoup.parse((InputStream)resource.getInputStream(), (String)"UTF-8", (String)"http://example.com/");
        Elements elementsByTag = doc.getElementsByTag(this.parseConfig.getMapper());
        for (Element element : elementsByTag) {
            ClassModel cm = new ClassModel();
            cm.setResource(resource);
            this.match(cm, (Node)element, "namespace", this.parseConfig.getNamespace());
            List nodes = element.childNodes();
            Map<String, MethodModel> methods = this.parseMethodModel(cm.getNamespace(), nodes);
            cm.setMethods(methods);
            result.put(cm.getNamespace().getName() + "$Proxy", cm);
        }
        return result;
    }

    private Map<String, MethodModel> parseMethodModel(Class namespace, List<Node> nodes) {
        HashMap<String, MethodModel> methods = new HashMap<String, MethodModel>();
        List<String> methodNames = this.getMethodNames(nodes);
        for (Node methodNode : nodes) {
            if (!(methodNode instanceof Element)) continue;
            MethodModel methodModel = this.parseMethodModel(methodNode);
            Method method = ReflectUtil.getNameUniqueMethod(namespace, methodModel.getId());
            methodModel.setMethod(method);
            Assert.notNull((Object)method, (String)("\u63a5\u53e3 " + namespace.getName() + " \u4e2d\uff0c\u672a\u58f0\u660e xml \u4e2d\u7684\u51fa\u73b0\u7684\u65b9\u6cd5\uff1a" + methodModel.getId()));
            this.checkReturnType(method, namespace);
            this.pageSupport(method, methodModel, methodNames, methods);
            methods.put(methodModel.getId(), methodModel);
        }
        return methods;
    }

    private void pageSupport(Method method, MethodModel methodModel, List<String> methodNames, Map<String, MethodModel> methods) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        List<Class<?>> parameterTypeList = Arrays.asList(parameterTypes);
        if (parameterTypeList.contains(Page.class)) {
            int pageParamIndex = parameterTypeList.indexOf(Page.class);
            MethodModel pageMethod = this.createPageMethod(methodModel, methodNames, parameterTypes, pageParamIndex);
            methods.put(pageMethod.getId(), pageMethod);
            MethodModel countMethod = this.createCountMethod(methodModel, methodNames, parameterTypes);
            methods.put(countMethod.getId(), countMethod);
        }
    }

    private MethodModel createCountMethod(MethodModel methodModel, List<String> methodNames, Class<?>[] parameterTypes) {
        String methodName = methodModel.getId();
        String countMethodName = String.format("%s$Count", methodName);
        Assert.isTrue((!methodNames.contains(countMethodName) ? 1 : 0) != 0, (String)("There is a method name conflicts with " + countMethodName));
        MethodModel countMethodModel = new MethodModel();
        countMethodModel.setParameterTypes(parameterTypes);
        countMethodModel.setId(countMethodName);
        String cql = methodModel.getText();
        String with = cql.replaceAll("(RETURN)|(return)", "WITH");
        cql = String.format("%s\t\tRETURN count(*);", with);
        countMethodModel.setText(cql);
        countMethodModel.setReturnType(Long.class);
        return countMethodModel;
    }

    private MethodModel createPageMethod(MethodModel methodModel, List<String> methodNames, Class<?>[] parameterTypes, int pageParamIndex) {
        String methodName = methodModel.getId();
        String pageMethodName = String.format("%s$Page", methodName);
        Assert.isTrue((!methodNames.contains(pageMethodName) ? 1 : 0) != 0, (String)("There is a method name conflicts with " + pageMethodName));
        MethodModel pageMethodModel = new MethodModel();
        pageMethodModel.setParameterTypes(parameterTypes);
        pageMethodModel.setId(pageMethodName);
        String cql = methodModel.getText();
        if (parameterTypes.length > 1) {
            String format = "%s\t\tSKIP $p%d.startRow LIMIT $p%d.pageSize";
            cql = String.format(format, cql, pageParamIndex, pageParamIndex);
        } else {
            String format = "%s\t\tSKIP $startRow LIMIT $pageSize";
            cql = String.format(format, cql);
        }
        pageMethodModel.setText(cql);
        pageMethodModel.setResultType(methodModel.getResultType());
        pageMethodModel.setReturnType(methodModel.getMethod().getReturnType());
        return pageMethodModel;
    }

    private List<String> getMethodNames(List<Node> nodes) {
        return nodes.stream().map(node -> {
            if (node instanceof Element) {
                return ((Element)node).id();
            }
            return null;
        }).collect(Collectors.toList());
    }

    private void checkReturnType(Method method, Class namespace) {
        Class<?> returnType = method.getReturnType();
        if (ReflectUtil.NEED_SEALING_TYPES.contains(returnType)) {
            throw new ResourceLoadException("\u76ee\u524d\u4e0d\u652f\u6301\u8fd4\u56de\u57fa\u672c\u7c7b\u578b\uff0c\u8bf7\u4f7f\u7528\u5bf9\u5e94\u7684\u5305\u88c5\u7c7b\uff0c\u63a5\u53e3\uff1a" + namespace.getName() + "." + method.getName());
        }
    }

    protected MethodModel parseMethodModel(Node node) {
        MethodModel model = new MethodModel();
        this.match(model, node, "id", this.parseConfig.getId());
        this.match(model, node, "parameterType", this.parseConfig.getParameterType());
        this.match(model, node, "resultType", this.parseConfig.getResultType());
        List nodes = node.childNodes();
        model.setText(this.nodesToString(nodes));
        return model;
    }

    protected String nodesToString(List<? extends Node> nodes) {
        StringBuilder builder = new StringBuilder();
        for (Node node : nodes) {
            if (!(node instanceof TextNode)) continue;
            builder.append(((TextNode)node).getWholeText());
            builder.append("\n");
        }
        String mapperText = builder.toString();
        String string = Entities.unescape((String)mapperText);
        return string;
    }

    private void match(Object model, Node node, String javaAttr, String attr) {
        String attrTemp = null;
        try {
            String attrText = node.attr(attr);
            if (Strings.isBlank((String)attrText)) {
                return;
            }
            attrTemp = attrText;
            Field field = model.getClass().getDeclaredField(javaAttr);
            Class<?> type = field.getType();
            field.setAccessible(true);
            if (type == Class.class) {
                field.set(model, Class.forName(attrText));
            } else {
                field.set(model, attrText);
            }
            field.setAccessible(false);
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("\u7c7b\u578b " + attrTemp + " \u672a\u627e\u5230");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

