/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.proxy;

import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.Session;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nebula.contrib.ngbatis.ArgNameFormatter;
import org.nebula.contrib.ngbatis.Env;
import org.nebula.contrib.ngbatis.ResultResolver;
import org.nebula.contrib.ngbatis.annotations.UseKeyArgReplace;
import org.nebula.contrib.ngbatis.config.ParseCfgProps;
import org.nebula.contrib.ngbatis.exception.QueryException;
import org.nebula.contrib.ngbatis.models.ClassModel;
import org.nebula.contrib.ngbatis.models.MapperContext;
import org.nebula.contrib.ngbatis.models.MethodModel;
import org.nebula.contrib.ngbatis.utils.Page;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MapperProxy {
    private static Logger log = LoggerFactory.getLogger(MapperProxy.class);
    @Autowired
    private ParseCfgProps props;
    public static Env ENV;
    private ClassModel classModel;
    private Map<String, MethodModel> methodCache = new HashMap<String, MethodModel>();

    public MapperProxy(ClassModel classModel) {
        this.classModel = classModel;
        this.methods(classModel);
    }

    private void methods(ClassModel classModel) {
        this.methodCache.clear();
        Map<String, MethodModel> methods = classModel.getMethods();
        this.methodCache.putAll(methods);
    }

    public static Object invoke(String className, String methodName, Object ... args) {
        MapperContext mapperContext = ENV.getMapperContext();
        String proxyClassName = className + "$Proxy";
        ClassModel classModel = mapperContext.getInterfaces().get(proxyClassName);
        Method method = null;
        if (mapperContext.isResourceRefresh()) {
            try {
                Map<String, ClassModel> classModelMap = classModel.getResourceLoader().parseClassModel(classModel.getResource());
                classModel = classModelMap.get(proxyClassName);
                method = classModel.getMethod(methodName).getMethod();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            method = classModel.getMethod(methodName).getMethod();
        }
        return MapperProxy.pageSupport(classModel, method, args);
    }

    private static Object pageSupport(ClassModel classModel, Method method, Object[] args) {
        int pageParamIndex = ReflectUtil.containsType(method, Page.class);
        MapperProxy mapperProxy = new MapperProxy(classModel);
        if (pageParamIndex < 0) {
            return mapperProxy.invoke(method, args);
        }
        String countMethodName = method.getName() + "$Count";
        String pageMethodName = method.getName() + "$Page";
        Long count = (Long)MapperProxy.invoke(classModel.getMethods().get(countMethodName), args);
        List rows = (List)MapperProxy.invoke(classModel.getMethods().get(pageMethodName), args);
        Page page = (Page)args[pageParamIndex];
        page.setTotal(count);
        page.setRows(rows);
        return rows;
    }

    public static Object invoke(MethodModel methodModel, Object ... args) {
        Method method = methodModel.getMethod();
        ResultSet query = null;
        long step0 = System.currentTimeMillis();
        Map<String, Object> argMap = ENV.getArgsResolver().resolve(methodModel, args);
        String textTpl = methodModel.getText();
        String nGQL = ENV.getTextResolver().resolve(textTpl, argMap);
        Map<String, Object> params = null;
        if (method != null && method.isAnnotationPresent(UseKeyArgReplace.class)) {
            ArgNameFormatter.CqlAndArgs format = ENV.getArgNameFormatter().format(nGQL, argMap);
            nGQL = format.getCql();
            params = format.getArgs();
        } else {
            params = argMap;
        }
        long step1 = System.currentTimeMillis();
        query = MapperProxy.executeWithParameter(nGQL, params);
        long step2 = System.currentTimeMillis();
        if (!query.isSucceeded()) {
            throw new QueryException("\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff1a" + query.getErrorMessage());
        }
        if (methodModel.getResultType() == ResultSet.class) {
            return query;
        }
        ResultResolver resultResolver = ENV.getResultResolver();
        Object resolve = resultResolver.resolve(methodModel, query);
        long step3 = System.currentTimeMillis();
        log.debug("nGql make up costs {}ms, query costs {}ms, result handle costs {}ms ", new Object[]{step1 - step0, step2 - step1, step3 - step2});
        return resolve;
    }

    public Object invoke(Method method, Object ... args) {
        MethodModel methodModel = this.methodCache.get(method.getName());
        methodModel.setMethod(method);
        return MapperProxy.invoke(methodModel, args);
    }

    public static ResultSet executeWithParameter(String nGQL, Map<String, Object> params) {
        String proxyMethod;
        String proxyClass;
        ResultSet result;
        Session session;
        block8: {
            StackTraceElement stackTraceElement;
            session = null;
            result = null;
            proxyClass = null;
            proxyMethod = null;
            if (log.isDebugEnabled()) {
                stackTraceElement = Thread.currentThread().getStackTrace()[6];
                proxyClass = stackTraceElement.getClassName();
                proxyMethod = stackTraceElement.getMethodName();
            }
            nGQL = "USE " + ENV.getSpace() + ";\n\t\t" + nGQL.trim();
            session = ENV.openSession();
            result = session.executeWithParameter(nGQL, params);
            if (!result.isSucceeded()) break block8;
            stackTraceElement = result;
            log.debug("\n\t- proxyMethod: {}#{} \n\t- nGql\uff1a{} \n\t - params: {}\n\t - result\uff1a{}", new Object[]{proxyClass, proxyMethod, nGQL, params, result});
            if (session != null) {
                session.release();
            }
            return stackTraceElement;
        }
        try {
            try {
                throw new QueryException(" \u6570\u636e\u67e5\u8be2\u5931\u8d25" + result.getErrorMessage());
            }
            catch (IOErrorException e) {
                throw new QueryException("\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            log.debug("\n\t- proxyMethod: {}#{} \n\t- nGql\uff1a{} \n\t - params: {}\n\t - result\uff1a{}", new Object[]{proxyClass, proxyMethod, nGQL, params, result});
            if (session != null) {
                session.release();
            }
            throw throwable;
        }
    }

    public static Logger getLog() {
        return log;
    }

    public static void setLog(Logger log) {
        MapperProxy.log = log;
    }

    public ParseCfgProps getProps() {
        return this.props;
    }

    public void setProps(ParseCfgProps props) {
        this.props = props;
    }

    public ClassModel getClassModel() {
        return this.classModel;
    }

    public void setClassModel(ClassModel classModel) {
        this.classModel = classModel;
    }

    public Map<String, MethodModel> getMethodCache() {
        return this.methodCache;
    }

    public void setMethodCache(Map<String, MethodModel> methodCache) {
        this.methodCache = methodCache;
    }
}

