/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.proxy;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.util.Map;
import org.nebula.contrib.ngbatis.models.ClassModel;
import org.nebula.contrib.ngbatis.models.MethodModel;
import org.nebula.contrib.ngbatis.proxy.MapperProxy;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class MapperProxyClassGenerator
implements Opcodes {
    private String getFullNameType(ClassModel cm) {
        return this.getFullNameType(cm.getNamespace().getName() + "$Proxy");
    }

    private String getFullNameType(String className) {
        return className.replace(".", "/");
    }

    public byte[] setClassCode(ClassModel cm) {
        String fullNameType = this.getFullNameType(cm);
        ClassWriter cw = new ClassWriter(0);
        cw.visit(52, 1, fullNameType, null, "java/lang/Object", new String[]{this.getFullNameType(cm.getNamespace().getName())});
        this.constructor(cw);
        this.methods(cw, cm);
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        cm.setClassByte(code);
        this.writeFile(cm);
        return code;
    }

    private void methods(ClassWriter cw, ClassModel cm) {
        Map<String, MethodModel> methods = cm.getMethods();
        for (Map.Entry<String, MethodModel> entry : methods.entrySet()) {
            this.method(cw, cm, entry);
        }
    }

    private void method(ClassWriter cw, ClassModel cm, Map.Entry<String, MethodModel> mmEntry) {
        String methodName = mmEntry.getKey();
        MethodModel mm = mmEntry.getValue();
        Method method = mm.getMethod();
        String methodSignature = ReflectUtil.getMethodSignature(mm);
        MethodVisitor mapper = cw.visitMethod(1, methodName, methodSignature, null, null);
        mapper.visitCode();
        String className = cm.getNamespace().getName();
        mapper.visitLdcInsn((Object)className);
        mapper.visitLdcInsn((Object)mm.getId());
        int parameterCount = this.addParams(mapper, mm.getParameterCount());
        mapper.visitMethodInsn(184, this.getFullNameType(MapperProxy.class.getName()), "invoke", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", false);
        mapper.visitMaxs(Integer.MAX_VALUE, Integer.MAX_VALUE);
        Class returnType = mm.getReturnType();
        mapper.visitTypeInsn(192, this.getFullNameType(returnType.getTypeName()));
        int returnTypeInsn = this.getReturnTypeInsn(returnType);
        mapper.visitInsn(returnTypeInsn);
        mapper.visitEnd();
    }

    private void sealingReturnType(MethodVisitor mapper, Class<?> returnType) {
        Class<?> basicReturnType = ReflectUtil.sealingBasicType(returnType);
        if (ReflectUtil.NEED_SEALING_TYPES.contains(returnType)) {
            String typeName = this.getFullNameType(basicReturnType.getName());
            String methodName = returnType.getName() + "Value";
            mapper.visitMethodInsn(182, typeName, methodName, "()I", false);
        }
    }

    private int getReturnTypeInsn(Class returnType) {
        return returnType == Long.TYPE ? 173 : (returnType == Integer.TYPE ? 172 : (returnType == Double.TYPE ? 175 : (returnType == Float.TYPE ? 174 : (returnType == Void.TYPE ? 177 : 176))));
    }

    private int addParams(MethodVisitor mv, int parameterCount) {
        int varLocation = parameterCount + 1;
        mv.visitLdcInsn((Object)parameterCount);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitVarInsn(58, varLocation);
        mv.visitVarInsn(25, varLocation);
        for (int i = 0; i < parameterCount; ++i) {
            mv.visitVarInsn(25, varLocation);
            mv.visitLdcInsn((Object)i);
            mv.visitVarInsn(25, i + 1);
            mv.visitInsn(83);
        }
        return parameterCount;
    }

    private void constructor(ClassWriter cw) {
        MethodVisitor constructor = cw.visitMethod(1, "<init>", "()V", null, null);
        constructor.visitCode();
        constructor.visitVarInsn(25, 0);
        constructor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        constructor.visitInsn(177);
        constructor.visitMaxs(1, 1);
        constructor.visitEnd();
    }

    private void writeFile(ClassModel cm) {
        try {
            File file = new File("asm-debug\\" + this.getFullNameType(cm) + ".class");
            File dir = new File(file.getParent());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(cm.getClassByte());
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

