/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.proxy;

import com.vesoft.nebula.client.graph.data.ResultSet;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nebula.contrib.ngbatis.TextResolver;
import org.nebula.contrib.ngbatis.exception.QueryException;
import org.nebula.contrib.ngbatis.proxy.MapperProxy;
import org.nebula.contrib.ngbatis.proxy.NebulaDaoBasicExt;
import org.nebula.contrib.ngbatis.utils.Page;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;

public interface NebulaDaoBasic<T, ID extends Serializable> {
    default public int deleteLogicById(final ID id) {
        String cqlTpl = NebulaDaoBasicExt.getCqlTpl();
        Class<?>[] classes = NebulaDaoBasicExt.entityTypeAndIdType(this.getClass());
        TextResolver textResolver = MapperProxy.ENV.getTextResolver();
        final Field pkField = NebulaDaoBasicExt.getPkField(classes[0].getDeclaredFields(), classes[0]);
        final String pstm = NebulaDaoBasicExt.keyFormat(id, pkField.getName(), true);
        HashMap<String, Object> tplParam = new HashMap<String, Object>(){
            {
                this.put("id", pstm);
            }
        };
        HashMap<String, Object> queryParam = new HashMap<String, Object>(){
            {
                this.put(pkField.getName(), id);
            }
        };
        String cql = textResolver.resolve(cqlTpl, (Map<String, Object>)tplParam);
        ResultSet resultSet = (ResultSet)NebulaDaoBasicExt.proxy(this.getClass(), ResultSet.class, cql, new Class[]{Serializable.class}, queryParam);
        return resultSet.isSucceeded() ? 1 : 0;
    }

    default public int deleteById(ID id) {
        throw new QueryException("No implements");
    }

    default public int insert(T record) {
        TextResolver textResolver = MapperProxy.ENV.getTextResolver();
        final NebulaDaoBasicExt.KV kv = NebulaDaoBasicExt.allFields(record);
        String cqlTpl = NebulaDaoBasicExt.getCqlTpl();
        Class<?> vertexType = NebulaDaoBasicExt.entityType(this.getClass());
        final String vertexName = NebulaDaoBasicExt.vertexName(vertexType);
        Field[] fields = vertexType.getDeclaredFields();
        Field pkField = NebulaDaoBasicExt.getPkField(fields, vertexType);
        Object id = NebulaDaoBasicExt.setId(record, pkField, vertexName);
        final String vId = NebulaDaoBasicExt.keyFormat(id, pkField.getName(), true);
        String nGQL = textResolver.resolve(cqlTpl, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("columns", kv.columns);
                this.put("valueColumns", kv.valueNames);
                this.put("table", vertexName);
                this.put("vId", vId);
            }
        });
        ResultSet resultSet = (ResultSet)NebulaDaoBasicExt.proxy(this.getClass(), ResultSet.class, nGQL, new Class[]{Object.class}, record);
        return resultSet.isSucceeded() ? 1 : 0;
    }

    default public Integer insertSelective(T record) {
        TextResolver textResolver = MapperProxy.ENV.getTextResolver();
        final NebulaDaoBasicExt.KV kv = NebulaDaoBasicExt.notNullFields(record);
        String cqlTpl = NebulaDaoBasicExt.getCqlTpl();
        Class<?> vertexType = record.getClass();
        final String vertexName = NebulaDaoBasicExt.vertexName(vertexType);
        Field[] fields = vertexType.getDeclaredFields();
        Field pkField = NebulaDaoBasicExt.getPkField(fields, vertexType);
        Object id = NebulaDaoBasicExt.setId(record, pkField, vertexName);
        final String vId = NebulaDaoBasicExt.keyFormat(id, pkField.getName(), true);
        String nGQL = textResolver.resolve(cqlTpl, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("columns", kv.columns);
                this.put("valueColumns", kv.valueNames);
                this.put("table", vertexName);
                this.put("vId", vId);
            }
        });
        ResultSet resultSet = (ResultSet)NebulaDaoBasicExt.proxy(this.getClass(), ResultSet.class, nGQL, new Class[]{Object.class}, record);
        return resultSet.isSucceeded() ? 1 : 0;
    }

    default public T selectById(ID id) {
        Class<?>[] classes = NebulaDaoBasicExt.entityTypeAndIdType(this.getClass());
        Class<?> entityType = classes[0];
        String vertexName = NebulaDaoBasicExt.vertexName(entityType);
        String nGQL = "MATCH ( n: " + vertexName + " ) WHERE id(n) == $p0 RETURN n LIMIT 2 ";
        return (T)NebulaDaoBasicExt.proxy(this.getClass(), entityType, nGQL, new Class[]{Serializable.class}, id);
    }

    default public List<T> selectByIds(Collection<ID> ids) {
        throw new QueryException("No implements");
    }

    default public List<T> selectBySelective(T record) {
        final NebulaDaoBasicExt.KV kv = NebulaDaoBasicExt.notNullFields(record);
        TextResolver textResolver = MapperProxy.ENV.getTextResolver();
        String cqlTpl = NebulaDaoBasicExt.getCqlTpl();
        Class<?> entityType = record.getClass();
        final String vertexName = NebulaDaoBasicExt.vertexName(entityType);
        String nGQL = textResolver.resolve(cqlTpl, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("columns", kv.columns);
                this.put("valueColumns", kv.valueNames);
                this.put("tag", vertexName);
            }
        });
        return (List)NebulaDaoBasicExt.proxy(this.getClass(), entityType, nGQL, new Class[]{Object.class}, record);
    }

    default public List<T> selectBySelectivePrecise(T record) {
        throw new QueryException("No implements");
    }

    default public List<T> selectByMap(Map<String, Object> param) {
        throw new QueryException("No implements");
    }

    default public Long countByMap(Map<String, Object> param) {
        throw new QueryException("No implements");
    }

    default public List<ID> selectIdBySelective(T record) {
        throw new QueryException("No implements");
    }

    default public int updateByIdSelective(T record) {
        throw new QueryException("No implements");
    }

    default public int updateByIdWithBLOBs(T record) {
        throw new QueryException("No implements");
    }

    default public int updateById(T record) {
        throw new QueryException("No implements");
    }

    default public int insertBatch(List<T> ts) {
        throw new QueryException("No implements");
    }

    default public Long countGridByMap(Map<String, Object> param) {
        throw new QueryException("No implements");
    }

    default public List<Map> selectGridByMap(Map<String, Object> param) {
        throw new QueryException("No implements");
    }

    default public int updateSelective(T t) {
        throw new QueryException("No implements");
    }

    default public Long countPage(final Page<T> page) {
        TextResolver textResolver = MapperProxy.ENV.getTextResolver();
        String countTpl = NebulaDaoBasicExt.getCqlTpl();
        Class<?> daoClass = this.getClass();
        Class<?>[] classes = NebulaDaoBasicExt.entityTypeAndIdType(daoClass);
        Class<?> entityType = classes[0];
        final String vertexName = NebulaDaoBasicExt.vertexName(entityType);
        final NebulaDaoBasicExt.KV kv = NebulaDaoBasicExt.notNullFields(page.entity, "entity");
        HashMap<String, Object> param = new HashMap<String, Object>(){
            {
                this.put("columns", kv.columns);
                this.put("valueColumns", kv.valueNames);
                this.put("tag", vertexName);
                this.put("pageSize", page.pageSize);
                this.put("startRow", page.startRow);
            }
        };
        String countNGql = textResolver.resolve(countTpl, (Map<String, Object>)param);
        return (Long)NebulaDaoBasicExt.proxy(daoClass, Long.class, countNGql, new Class[]{Page.class}, page);
    }

    default public List<T> selectPage(final Page<T> page) {
        Long total = this.countPage(page);
        page.setTotal(total);
        if (total == 0L) {
            return Collections.EMPTY_LIST;
        }
        TextResolver textResolver = MapperProxy.ENV.getTextResolver();
        Class<?> daoClass = this.getClass();
        Class<?>[] classes = NebulaDaoBasicExt.entityTypeAndIdType(daoClass);
        Class<?> entityType = classes[0];
        final String vertexName = NebulaDaoBasicExt.vertexName(entityType);
        final NebulaDaoBasicExt.KV kv = NebulaDaoBasicExt.notNullFields(page.entity, "entity");
        HashMap<String, Object> param = new HashMap<String, Object>(){
            {
                this.put("columns", kv.columns);
                this.put("valueColumns", kv.valueNames);
                this.put("tag", vertexName);
                this.put("pageSize", page.pageSize);
                this.put("startRow", page.startRow);
            }
        };
        String cqlTpl = NebulaDaoBasicExt.getCqlTpl();
        String nGql = textResolver.resolve(cqlTpl, (Map<String, Object>)param);
        List proxy = (List)NebulaDaoBasicExt.proxy(daoClass, entityType, nGql, new Class[]{Page.class}, page);
        page.setRows(proxy);
        return proxy;
    }

    default public int updateBatch(List<T> ts) {
        throw new QueryException("No implements");
    }

    default public void insertEdge(Object v1, Object e, Object v2) {
        if (v2 == null || v1 == null || e == null) {
            return;
        }
        TextResolver textResolver = MapperProxy.ENV.getTextResolver();
        final NebulaDaoBasicExt.KV kv = NebulaDaoBasicExt.notNullFields(e, "p1");
        String cqlTpl = NebulaDaoBasicExt.getCqlTpl();
        Class<?> edgeType = e.getClass();
        final String edgeName = NebulaDaoBasicExt.edgeName(edgeType);
        Field v1PkField = NebulaDaoBasicExt.getPkField(v1.getClass());
        Field v2PkField = NebulaDaoBasicExt.getPkField(v2.getClass());
        final String eId1 = NebulaDaoBasicExt.keyFormat(ReflectUtil.getValue(v1, v1PkField), v1PkField.getName(), true, "p0");
        final String eId2 = NebulaDaoBasicExt.keyFormat(ReflectUtil.getValue(v2, v2PkField), v2PkField.getName(), true, "p2");
        HashMap<String, Object> tplArgs = new HashMap<String, Object>(){
            {
                this.put("columns", kv.columns);
                this.put("valueColumns", kv.valueNames);
                this.put("e", edgeName);
                this.put("eId1", eId1);
                this.put("eId2", eId2);
            }
        };
        Field rankField = NebulaDaoBasicExt.getRankField(e.getClass());
        if (rankField != null) {
            NebulaDaoBasicExt.setId(e, rankField, edgeName);
            String rank = NebulaDaoBasicExt.keyFormat(ReflectUtil.getValue(e, rankField), rankField.getName(), true, "p1");
            tplArgs.put("rank", rank);
        }
        String nGQL = textResolver.resolve(cqlTpl, (Map<String, Object>)tplArgs);
        NebulaDaoBasicExt.proxy(this.getClass(), edgeType, nGQL, new Class[]{Object.class, Object.class, Object.class}, v1, e, v2);
    }

    default public Boolean existsEdge(ID startId, Class<?> edgeType, ID endId) {
        String cqlTpl = NebulaDaoBasicExt.getCqlTpl();
        String edgeName = NebulaDaoBasicExt.edgeName(edgeType);
        return (Boolean)NebulaDaoBasicExt.proxy(this.getClass(), Boolean.class, cqlTpl, new Class[]{Serializable.class, Class.class, Serializable.class}, startId, edgeName, endId);
    }

    default public List<T> listStartNodes(Class<?> edgeType, ID endId) {
        Class<?> startType = NebulaDaoBasicExt.entityType(this.getClass());
        return this.listStartNodes(startType, edgeType, endId);
    }

    default public List<?> listStartNodes(Class<?> startType, Class<?> edgeType, ID endId) {
        String cqlTpl = NebulaDaoBasicExt.getCqlTpl();
        String startVertexName = NebulaDaoBasicExt.vertexName(startType);
        String edgeName = NebulaDaoBasicExt.edgeName(edgeType);
        Class<?> daoType = this.getClass();
        Class<?> returnType = NebulaDaoBasicExt.entityType(daoType);
        return (List)NebulaDaoBasicExt.proxy(daoType, returnType, cqlTpl, new Class[]{Class.class, Class.class, Serializable.class}, startVertexName, edgeName, endId);
    }

    default public T startNode(Class<?> edgeType, ID endId) {
        Class<?> startType = NebulaDaoBasicExt.entityType(this.getClass());
        return (T)this.startNode(startType, edgeType, endId);
    }

    default public <E> E startNode(Class<E> startType, Class<?> edgeType, ID endId) {
        String cqlTpl = NebulaDaoBasicExt.getCqlTpl();
        String startVertexName = NebulaDaoBasicExt.vertexName(startType);
        String edgeName = NebulaDaoBasicExt.edgeName(edgeType);
        Class<?> daoType = this.getClass();
        Class<?> returnType = NebulaDaoBasicExt.entityType(daoType);
        return (E)NebulaDaoBasicExt.proxy(daoType, returnType, cqlTpl, new Class[]{Class.class, Class.class, Serializable.class}, startVertexName, edgeName, endId);
    }
}

