/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.proxy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.nebula.contrib.ngbatis.PkGenerator;
import org.nebula.contrib.ngbatis.exception.ParseException;
import org.nebula.contrib.ngbatis.models.MethodModel;
import org.nebula.contrib.ngbatis.proxy.MapperProxy;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;
import org.nebula.contrib.ngbatis.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class NebulaDaoBasicExt {
    private static Logger log = LoggerFactory.getLogger(NebulaDaoBasicExt.class);
    static Map<Class<?>, String> valueFormat = new HashMap<Class<?>, String>(){
        {
            this.put(String.class, "'%s'");
        }
    };

    public static String vertexName(Class<?> entityType) {
        Table tableAnno = entityType.getAnnotation(Table.class);
        return tableAnno != null ? tableAnno.name() : StringUtil.xX2x_x(entityType.getSimpleName());
    }

    public static String edgeName(Class<?> edgeType) {
        return NebulaDaoBasicExt.vertexName(edgeType);
    }

    public static Object setId(Object record, Field pkField, String tagName) {
        try {
            PkGenerator pkGenerator = MapperProxy.ENV.getPkGenerator();
            Object id = ReflectUtil.getValue(record, pkField);
            if (id == null && pkGenerator != null) {
                id = pkGenerator.generate(tagName, pkField.getType());
                ReflectUtil.setValue(record, pkField, id);
            }
            return id;
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    static Object valueFormat(Object value, Object name) {
        Class<?> fieldType = value.getClass();
        return valueFormat.containsKey(fieldType) ? String.format(valueFormat.get(fieldType), name) : name;
    }

    static String keyFormat(Object value, String name, boolean asStmt) {
        String format = asStmt ? "${ nvl( %s, 'null' ) }" : "$%s";
        return NebulaDaoBasicExt.valueFormat(value, String.format(format, name)).toString();
    }

    static String keyFormat(Object value, String name, boolean asStmt, String prefix) {
        if (value == null) {
            return "null";
        }
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            String format = asStmt ? "${ nvl( %s.%s, 'null' ) }" : "$%s.%s";
            return NebulaDaoBasicExt.valueFormat(value, String.format(format, prefix, name)).toString();
        }
        return NebulaDaoBasicExt.keyFormat(value, name, asStmt);
    }

    public static Class<?>[] entityTypeAndIdType(Class<?> currentType) {
        Type[] genericInterfaces;
        Class<?>[] result = null;
        for (Type genericInterface : genericInterfaces = currentType.getGenericInterfaces()) {
            if (genericInterface.getClass() == ParameterizedTypeImpl.class) {
                Type[] actualTypeArguments = ((ParameterizedTypeImpl)genericInterface).getActualTypeArguments();
                result = new Class[]{(Class)actualTypeArguments[0], (Class)actualTypeArguments[1]};
                continue;
            }
            if (!(genericInterface instanceof Class)) continue;
            result = NebulaDaoBasicExt.entityTypeAndIdType((Class)genericInterface);
        }
        return result;
    }

    public static Class<?> entityType(Class<?> currentType) {
        Class<?>[] entityTypeAndIdType = NebulaDaoBasicExt.entityTypeAndIdType(currentType);
        if (entityTypeAndIdType != null && entityTypeAndIdType.length > 0) {
            return entityTypeAndIdType[0];
        }
        return null;
    }

    public static Object proxy(Class<?> currentType, Class<?> returnType, String nGQL, Class<?>[] argTypes, Object ... args) {
        Method method = null;
        try {
            String methodName = NebulaDaoBasicExt.getMethodName();
            method = currentType.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException methodName) {
            // empty catch block
        }
        MethodModel methodModel = new MethodModel();
        methodModel.setMethod(method);
        methodModel.setResultType(returnType);
        methodModel.setText(nGQL);
        return MapperProxy.invoke(methodModel, args);
    }

    public static KV notNullFields(Object record) {
        return NebulaDaoBasicExt.notNullFields(record, null);
    }

    public static KV notNullFields(Object record, String prefix) {
        if (record == null) {
            return new KV();
        }
        Field[] fields = ReflectUtil.getAllColumnFields(record.getClass());
        return NebulaDaoBasicExt.recordToKV(record, fields, true, prefix);
    }

    public static KV allFields(Object record) {
        return NebulaDaoBasicExt.allFields(record, null);
    }

    public static KV allFields(Object record, String prefix) {
        Field[] fields = record.getClass().getDeclaredFields();
        return NebulaDaoBasicExt.recordToKV(record, fields, false, prefix);
    }

    public static Field getPkField(Class<?> type) {
        Field[] declaredFields = type.getDeclaredFields();
        return NebulaDaoBasicExt.getPkField(declaredFields, type);
    }

    public static Field getRankField(Class<?> type) {
        Field[] declaredFields = type.getDeclaredFields();
        return NebulaDaoBasicExt.getPkField(declaredFields, type, false);
    }

    public static Field getPkField(Field[] fields, Class<?> type) {
        return NebulaDaoBasicExt.getPkField(fields, type, true);
    }

    public static Field getPkField(Field[] fields, Class<?> type, boolean canNotNull) {
        Field pkField = null;
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Id.class)) continue;
            pkField = field;
        }
        if (canNotNull && pkField == null) {
            throw new ParseException(String.format("%s \u5fc5\u987b\u6709\u4e00\u4e2a\u5c5e\u6027\u7528 @Id \u6ce8\u89e3\u3002\uff08javax.persistence.Id\uff09", type));
        }
        return pkField;
    }

    public static String getCqlTpl() {
        Map<String, String> daoBasicTpl = MapperProxy.ENV.getMapperContext().getDaoBasicTpl();
        return daoBasicTpl.get(NebulaDaoBasicExt.getMethodName());
    }

    public static KV recordToKV(Object record, Field[] fields, boolean selective, String prefix) {
        KV kv = new KV();
        for (Field field : fields) {
            String name = null;
            if (selective) {
                Object value = ReflectUtil.getValue(record, field);
                if (value != null) {
                    name = field.getName();
                }
            } else {
                name = field.getName();
            }
            if (name == null) continue;
            kv.columns.add(name);
            String o = NebulaDaoBasicExt.keyFormat(ReflectUtil.getValue(record, field), name, true, prefix);
            kv.valueNames.add(String.valueOf(o));
        }
        return kv;
    }

    public static void main(String[] args) {
        String format = String.format("%s", null);
        List<String> strings = Arrays.asList("dd", format, "ees");
        System.out.println(String.join((CharSequence)",", strings));
    }

    public static String getMethodName() {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[3];
        return stackTraceElement.getMethodName();
    }

    public static class KV {
        public final List<String> columns = new ArrayList<String>();
        public final List<String> valueNames = new ArrayList<String>();
    }
}

