/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.utils;

import java.util.List;
import java.util.Map;

public class Page<T> {
    public int pageNo = 1;
    public int pageSize = 100;
    public int startRow = 0;
    public int endRow = 15;
    public long total;
    public int pages;
    public List<T> rows;
    public T entity;
    public Map<String, Object> q;
    public Long sysUser;

    public Page() {
    }

    public Page(int pageNo, int pageSize) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.startRow = pageNo > 0 ? (pageNo - 1) * pageSize : 0;
        this.endRow = pageNo * pageSize;
    }

    public Long getSysUser() {
        return this.sysUser;
    }

    public void setSysUser(Long sysUser) {
        this.sysUser = sysUser;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public int getPages() {
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public void setPages() {
        this.pages = (int)(this.total / (long)this.pageSize + (long)(this.total % (long)this.pageSize == 0L ? 0 : 1));
    }

    public int getEndRow() {
        return this.endRow;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
        this.startRow = pageNo > 0 ? (pageNo - 1) * this.pageSize : 0;
        this.endRow = pageNo * this.pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.startRow = this.pageNo > 0 ? (this.pageNo - 1) * pageSize : 0;
        this.endRow = this.pageNo * pageSize;
        this.setPages();
    }

    public int getStartRow() {
        return this.startRow;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
        this.setPages();
    }

    public Map<String, Object> getQ() {
        return this.q;
    }

    public void setQ(Map<String, Object> q) {
        this.q = q;
    }

    public String toString() {
        return "Page{pageNo=" + this.pageNo + ", pageSize=" + this.pageSize + ", startRow=" + this.startRow + ", endRow=" + this.endRow + ", total=" + this.total + ", pages=" + this.pages + '}';
    }
}

