/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import org.nebula.contrib.ngbatis.exception.ParseException;
import org.nebula.contrib.ngbatis.models.MethodModel;
import org.springframework.util.ObjectUtils;

public class ReflectUtil {
    public static List<Class<?>> NUMBER_TYPES = Arrays.asList(Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class);
    public static final Set<Class<?>> NEED_SEALING_TYPES = new HashSet<Class<?>>(){
        {
            this.add(Short.TYPE);
            this.add(Integer.TYPE);
            this.add(Long.TYPE);
            this.add(Double.TYPE);
            this.add(Float.TYPE);
            this.add(Byte.TYPE);
            this.add(Character.TYPE);
            this.add(Boolean.TYPE);
        }
    };
    public static final List<Class> CLASSES = Arrays.asList(String.class, Character.class, Character.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Boolean.class, Boolean.TYPE);

    public static void setValue(Object o, String prop, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field declaredField = o.getClass().getDeclaredField(prop);
        ReflectUtil.setValue(o, declaredField, value);
    }

    public static void setValue(Object o, Field field, Object value) throws IllegalAccessException {
        boolean accessible;
        if (NUMBER_TYPES.contains(field.getType())) {
            value = ReflectUtil.castNumber((Number)value, field.getType());
        }
        if (accessible = field.isAccessible()) {
            field.set(o, value);
        } else {
            field.setAccessible(true);
            field.set(o, value);
            field.setAccessible(false);
        }
    }

    public static Number castNumber(Number n, Class resultType) {
        if (n == null) {
            return null;
        }
        return resultType == Integer.class || resultType == Integer.TYPE ? (Number)n.intValue() : (Number)(resultType == Long.class || resultType == Long.TYPE ? (Number)n.longValue() : (Number)(resultType == Float.class || resultType == Float.TYPE ? (Number)Float.valueOf(n.floatValue()) : (Number)(resultType == Double.class || resultType == Double.TYPE ? (Number)n.doubleValue() : (Number)(resultType == Byte.class || resultType == Byte.TYPE ? (Number)n.byteValue() : (Number)(resultType == Short.class || resultType == Short.TYPE ? (Number)n.shortValue() : (Number)n)))));
    }

    public static Object getValue(Object o, Field field) {
        try {
            boolean accessible = field.isAccessible();
            if (accessible) {
                return field.get(o);
            }
            field.setAccessible(true);
            Object value = field.get(o);
            field.setAccessible(false);
            return value;
        }
        catch (IllegalAccessException e) {
            throw new ParseException(e.getMessage());
        }
    }

    public static String getMethodSignature(MethodModel methodModel) {
        Class<?>[] parameterTypes;
        Class<?> returnType;
        StringBuilder builder = new StringBuilder("(");
        Method method = methodModel.getMethod();
        if (method == null) {
            returnType = methodModel.getReturnType();
            parameterTypes = methodModel.getParameterTypes();
        } else {
            returnType = method.getReturnType();
            parameterTypes = method.getParameterTypes();
        }
        for (Class<?> parameterType : parameterTypes) {
            builder.append(ReflectUtil.insnType(parameterType));
        }
        String canonicalName = returnType.getCanonicalName();
        builder.append(")");
        if (returnType == Void.TYPE) {
            builder.append("V");
        } else if (returnType == Integer.TYPE) {
            builder.append("I");
        } else {
            builder.append("L");
            builder.append(canonicalName.replace(".", "/"));
            builder.append(";");
        }
        String string = builder.toString();
        return string;
    }

    public static int containsType(Method method, Class<?> parameterType) {
        List<Class<?>> classes = Arrays.asList(method.getParameterTypes());
        return classes.indexOf(parameterType);
    }

    public static Class<?> sealingBasicType(Class<?> returnType) {
        return returnType == Short.TYPE ? Short.class : (returnType == Integer.TYPE ? Integer.class : (returnType == Long.TYPE ? Long.class : (returnType == Double.TYPE ? Double.class : (returnType == Float.TYPE ? Float.class : (returnType == Byte.TYPE ? Byte.class : (returnType == Character.TYPE ? Character.class : (returnType == Boolean.TYPE ? Boolean.class : returnType)))))));
    }

    public static String insnType(Class<?> type) {
        StringBuilder builder = new StringBuilder();
        if (type == Integer.TYPE) {
            builder.append("I");
        } else if (type == Long.TYPE) {
            builder.append("J");
        } else if (type == Void.TYPE) {
            builder.append("V");
        } else {
            builder.append("L");
            String canonicalName = type.getCanonicalName().replace(".", "/");
            builder.append(canonicalName);
            builder.append(";");
        }
        return builder.toString();
    }

    public static Method getNameUniqueMethod(Class clazz, String methodName) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
            if (!ObjectUtils.nullSafeEquals((Object)method.getName(), (Object)methodName)) continue;
            return method;
        }
        return null;
    }

    public static boolean isBasicType(Class clazz) {
        return CLASSES.contains(clazz);
    }

    public static Class<?> fieldType(Object o, String fieldName) {
        try {
            Field field = o.getClass().getDeclaredField(fieldName);
            return field.getType();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isCurrentTypeOrParentType(Class<?> paramType, Class<?> pType) {
        if (paramType == pType) {
            return true;
        }
        Set<Class<?>> parentTypes = ReflectUtil.getParentTypes(paramType);
        return parentTypes.contains(pType);
    }

    public static Set<Class<?>> getParentTypes(Class<?> paramType) {
        if (paramType == null) {
            return Collections.EMPTY_SET;
        }
        List<Class<?>> interfaces = Arrays.asList(paramType.getInterfaces());
        HashSet parents = new HashSet(interfaces);
        for (Class<?> anInterface : interfaces) {
            parents.addAll(ReflectUtil.getParentTypes(anInterface));
        }
        Class<?> superclass = paramType.getSuperclass();
        parents.add(superclass);
        parents.addAll(ReflectUtil.getParentTypes(superclass));
        return parents;
    }

    public static Field[] getAllColumnFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        boolean leaf = true;
        do {
            Field[] declaredFields = clazz.getDeclaredFields();
            if (leaf) {
                fields.addAll(Arrays.asList(declaredFields));
            } else {
                for (Field declaredField : declaredFields) {
                    if (!declaredField.isAnnotationPresent(Column.class)) continue;
                    fields.add(declaredField);
                }
            }
            clazz = clazz.getSuperclass();
            leaf = false;
        } while (clazz != null);
        return fields.toArray(new Field[0]);
    }
}

