/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.utils;

import com.vesoft.nebula.client.graph.data.DateTimeWrapper;
import com.vesoft.nebula.client.graph.data.DateWrapper;
import com.vesoft.nebula.client.graph.data.Node;
import com.vesoft.nebula.client.graph.data.Relationship;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nebula.contrib.ngbatis.exception.ResultHandleException;
import org.nebula.contrib.ngbatis.models.MapperContext;
import org.nebula.contrib.ngbatis.proxy.MapperProxy;
import org.nebula.contrib.ngbatis.proxy.NebulaDaoBasicExt;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetUtil {
    private static Logger log = LoggerFactory.getLogger(ResultSetUtil.class);

    public static <T> T getValue(ValueWrapper value) {
        try {
            Long o = value.isLong() ? Long.valueOf(value.asLong()) : (value.isBoolean() ? Boolean.valueOf(value.asBoolean()) : (value.isDouble() ? Double.valueOf(value.asDouble()) : (value.isString() ? value.asString() : (value.isTime() ? value.asTime() : (value.isDate() ? ResultSetUtil.transformDate(value.asDate()) : (value.isDateTime() ? ResultSetUtil.transformDateTime(value.asDateTime()) : (value.isVertex() ? ResultSetUtil.transformNode(value.asNode()) : (value.isEdge() ? value.asRelationship() : (value.isPath() ? value.asPath() : (value.isList() ? ResultSetUtil.transformList(value.asList()) : (value.isSet() ? ResultSetUtil.transformList(value.asList()) : (value.isMap() ? ResultSetUtil.transformMap(value.asMap()) : null))))))))))));
            return (T)o;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object transformDateTime(DateTimeWrapper dateTime) {
        return new GregorianCalendar(dateTime.getYear(), dateTime.getMonth() - 1, dateTime.getDay(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond()).getTime();
    }

    private static Object transformDate(DateWrapper date) {
        return new GregorianCalendar(date.getYear() + 1900, date.getMonth() - 1, date.getDay()).getTime();
    }

    private static Object transformNode(Node node) {
        List tagNames = node.tagNames();
        if (tagNames.size() != 1) {
            log.warn("Sorry there is no parse implements for multi tags node: {}", (Object)node);
            return node;
        }
        String tagName = (String)tagNames.get(0);
        MapperContext mapperContext = MapperProxy.ENV.getMapperContext();
        Map<String, Class<?>> tagTypeMapping = mapperContext.getTagTypeMapping();
        Class<?> nodeType = tagTypeMapping.get(tagName);
        if (nodeType != null) {
            return ResultSetUtil.nodeToResultType(node, nodeType);
        }
        return node;
    }

    private static Object transformMap(HashMap<String, ValueWrapper> map) {
        HashMap javaResult = new HashMap();
        for (Map.Entry<String, ValueWrapper> entry : map.entrySet()) {
            String k = entry.getKey();
            ValueWrapper v = entry.getValue();
            javaResult.put(k, ResultSetUtil.getValue(v));
        }
        return javaResult;
    }

    private static Object transformList(ArrayList<ValueWrapper> list) {
        return list.stream().map(ResultSetUtil::getValue).collect(Collectors.toList());
    }

    public static <T> T getValue(ValueWrapper valueWrapper, Class<T> resultType) {
        Object value = ResultSetUtil.getValue(valueWrapper);
        if (value instanceof Number) {
            value = ReflectUtil.castNumber((Number)value, resultType);
        }
        return value;
    }

    public static <T> T nodeToResultType(Node v, Class<T> resultType) {
        T t = null;
        try {
            List values = v.values((String)v.tagNames().get(0));
            List keys = v.keys((String)v.tagNames().get(0));
            t = resultType.newInstance();
            for (int i = 0; i < keys.size(); ++i) {
                String prop = (String)keys.get(i);
                ReflectUtil.setValue(t, prop, ResultSetUtil.getValue((ValueWrapper)values.get(i)));
            }
            ResultSetUtil.setId(t, resultType, v);
        }
        catch (UnsupportedEncodingException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            throw new ResultHandleException(String.format("%s : %s", e.getClass().toString(), e.getMessage()));
        }
        return t;
    }

    public static void nodeToResultType(Object o, String fieldName, Node node) {
        Class<?> fieldType = ReflectUtil.fieldType(o, fieldName);
        if (fieldType != null) {
            Object fieldValue = ResultSetUtil.nodeToResultType(node, fieldType);
            try {
                ReflectUtil.setValue(o, fieldName, fieldValue);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> T relationshipToResultType(Relationship r, Class<T> resultType) {
        T t = null;
        try {
            t = resultType.newInstance();
            HashMap properties = r.properties();
            for (Map.Entry entry : properties.entrySet()) {
                ReflectUtil.setValue(t, (String)entry.getKey(), ResultSetUtil.getValue((ValueWrapper)entry.getValue()));
            }
        }
        catch (UnsupportedEncodingException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return t;
    }

    public static void relationshipToResultType(Object o, String fieldName, Relationship relationship) {
        Class<?> fieldType = ReflectUtil.fieldType(o, fieldName);
        if (fieldType != null) {
            Object fieldValue = ResultSetUtil.relationshipToResultType(relationship, fieldType);
            try {
                ReflectUtil.setValue(o, fieldName, fieldValue);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setId(Object obj, Class<?> resultType, Node v) throws IllegalAccessException {
        Field pkField = NebulaDaoBasicExt.getPkField(resultType);
        ValueWrapper idWrapper = v.getId();
        Object id = ResultSetUtil.getValue(idWrapper);
        ReflectUtil.setValue(obj, pkField, id);
    }
}

