/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.binding;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vesoft.nebula.DataSet;
import com.vesoft.nebula.DateTime;
import com.vesoft.nebula.Duration;
import com.vesoft.nebula.Edge;
import com.vesoft.nebula.Geography;
import com.vesoft.nebula.NList;
import com.vesoft.nebula.NMap;
import com.vesoft.nebula.NSet;
import com.vesoft.nebula.Path;
import com.vesoft.nebula.Time;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.Vertex;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.nebula.contrib.ngbatis.ArgsResolver;
import org.nebula.contrib.ngbatis.binding.DateDeserializer;
import org.nebula.contrib.ngbatis.binding.Setter;
import org.nebula.contrib.ngbatis.models.MethodModel;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Component;

@Component
public class DefaultArgsResolver
implements ArgsResolver {
    public static Map<Class<?>, Setter<?>> LEAF_TYPE_AND_SETTER = new HashMap<Class<?>, Setter<?>>(){
        {
            this.put(Boolean.TYPE, Value::bVal);
            this.put(Boolean.class, Value::bVal);
            this.put(Integer.TYPE, Value::iVal);
            this.put(Integer.class, Value::iVal);
            this.put(Short.TYPE, Value::iVal);
            this.put(Short.class, Value::iVal);
            this.put(Byte.TYPE, Value::iVal);
            this.put(Byte.class, Value::iVal);
            this.put(Long.TYPE, Value::iVal);
            this.put(Long.class, Value::iVal);
            this.put(Float.TYPE, Value::fVal);
            this.put(Float.class, Value::fVal);
            this.put(Double.TYPE, Value::fVal);
            this.put(Double.class, Value::fVal);
            this.put(byte[].class, Value::sVal);
            this.put(String.class, param -> Value.sVal((byte[])param.getBytes()));
            this.put(com.vesoft.nebula.Date.class, Value::dVal);
            this.put(Time.class, Value::tVal);
            this.put(DateTime.class, Value::dtVal);
            this.put(Vertex.class, Value::vVal);
            this.put(Edge.class, Value::eVal);
            this.put(Path.class, Value::pVal);
            this.put(NList.class, Value::lVal);
            this.put(NMap.class, Value::mVal);
            this.put(NSet.class, Value::uVal);
            this.put(DataSet.class, Value::gVal);
            this.put(Geography.class, Value::ggVal);
            this.put(Duration.class, Value::duVal);
        }
    };
    public static Map<Class<?>, Setter> COMPLEX_TYPE_AND_SETTER = new LinkedHashMap<Class<?>, Setter>(){
        {
            this.put(Set.class, set -> {
                HashSet values = new HashSet();
                set.forEach((? super T el) -> values.add(DefaultArgsResolver.toNebulaValueType(el)));
                return values;
            });
            this.put(Collection.class, collection -> {
                ArrayList list = new ArrayList();
                collection.forEach((? super T el) -> list.add(DefaultArgsResolver.toNebulaValueType(el)));
                return list;
            });
            this.put(Map.class, map -> {
                HashMap valueMap = new HashMap();
                map.forEach((k, v) -> valueMap.put(k, DefaultArgsResolver.toNebulaValueType(v)));
                return valueMap;
            });
            this.put(java.util.Date.class, date -> {
                Calendar calendar = new Calendar.Builder().setInstant((java.util.Date)date).build();
                return Value.dtVal((DateTime)new DateTime(Short.parseShort(String.valueOf(calendar.get(1))), Byte.parseByte(String.valueOf(calendar.get(2))), Byte.parseByte(String.valueOf(calendar.get(5))), Byte.parseByte(String.valueOf(calendar.get(10))), Byte.parseByte(String.valueOf(calendar.get(12))), Byte.parseByte(String.valueOf(calendar.get(13))), (int)Short.parseShort(String.valueOf(calendar.get(14)))));
            });
            this.put(Object.class, obj -> {
                Field[] declaredFields;
                HashMap pojoFields = new HashMap();
                Class<?> paramType = obj.getClass();
                for (Field declaredField : declaredFields = paramType.getDeclaredFields()) {
                    pojoFields.put(declaredField.getName(), DefaultArgsResolver.toNebulaValueType(ReflectUtil.getValue(obj, declaredField)));
                }
                return pojoFields;
            });
        }
    };

    public static <T> T toNebulaValueType(Object param) {
        if (param == null) {
            return null;
        }
        Class<?> paramType = param.getClass();
        Setter<?> setter = LEAF_TYPE_AND_SETTER.get(paramType);
        if (setter != null) {
            return (T)setter.set(param);
        }
        for (Class<?> parentType : COMPLEX_TYPE_AND_SETTER.keySet()) {
            if (!ReflectUtil.isCurrentTypeOrParentType(paramType, parentType)) continue;
            return (T)COMPLEX_TYPE_AND_SETTER.get(parentType).set(param);
        }
        return (T)param;
    }

    @Override
    public Map<String, Object> resolveForTemplate(MethodModel methodModel, Object ... args) {
        return this.resolve(true, methodModel, args);
    }

    @Override
    public Map<String, Object> resolve(MethodModel methodModel, Object ... args) {
        return this.resolve(false, methodModel, args);
    }

    private Map<String, Object> resolve(boolean forTemplate, MethodModel methodModel, Object ... args) {
        if (args.length == 0) {
            return Collections.emptyMap();
        }
        int len = methodModel.getParameterCount();
        Map<String, Object> result = new LinkedHashMap<String, Object>();
        Annotation[][] parameterAnnotations = methodModel.getParameterAnnotations();
        for (int i = 0; i < len; ++i) {
            Annotation[] annotationArgIndex = parameterAnnotations[i];
            int annoLen = annotationArgIndex == null ? 0 : annotationArgIndex.length;
            boolean notFoundParamAnno = true;
            for (int j = 0; j < annoLen; ++j) {
                if (!(annotationArgIndex[j] instanceof Param)) continue;
                Param annotationArgIndex1 = (Param)annotationArgIndex[j];
                String key = annotationArgIndex1.value();
                result.put(key, this.serialize(forTemplate, args[i]));
                notFoundParamAnno = false;
            }
            if (!notFoundParamAnno) continue;
            Class<?> paramClass = args[i].getClass();
            if (this.isBaseType(paramClass)) {
                result.put("p" + i, this.serialize(forTemplate, args[i]));
                continue;
            }
            if (args[i] instanceof Collection) {
                result.put("p" + i, this.serialize(forTemplate, args[i]));
                continue;
            }
            if (len == 1) {
                result = (Map)this.serialize(forTemplate, args[0]);
                continue;
            }
            result.put("p" + i, this.serialize(forTemplate, args[i]));
        }
        return result;
    }

    private Object serialize(boolean forTemplate, Object o) {
        return forTemplate ? JSON.toJSON((Object)o) : DefaultArgsResolver.toNebulaValueType(o);
    }

    @Deprecated
    public Object customToJson(Object o) {
        try {
            SerializeConfig parserConfig = new SerializeConfig();
            parserConfig.put(java.util.Date.class, (ObjectSerializer)new DateDeserializer());
            parserConfig.put(Date.class, (ObjectSerializer)new DateDeserializer());
            parserConfig.put(java.sql.Time.class, (ObjectSerializer)new DateDeserializer());
            parserConfig.put(Timestamp.class, (ObjectSerializer)new DateDeserializer());
            String text = JSON.toJSONString((Object)o, (SerializeConfig)parserConfig, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            text = text.replaceAll("\\\\n", "\\\\\\\\n");
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.readValue(text, Map.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isBaseType(Class<?> clazz) {
        return clazz == Character.class || clazz == Character.TYPE || clazz == Byte.class || clazz == Byte.TYPE || clazz == Short.class || clazz == Short.TYPE || clazz == Integer.class || clazz == Integer.TYPE || clazz == Long.class || clazz == Long.TYPE || clazz == Float.class || clazz == Float.TYPE || clazz == Double.class || clazz == Double.TYPE || clazz == Boolean.class || clazz == Boolean.TYPE || clazz == String.class;
    }
}

