/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.handler;

import com.vesoft.nebula.client.graph.data.ResultSet;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.nebula.contrib.ngbatis.ResultHandler;
import org.nebula.contrib.ngbatis.exception.QueryException;
import org.nebula.contrib.ngbatis.exception.ResultHandleException;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResultHandler<T, Z>
implements ResultHandler<T, Z> {
    private Logger log = LoggerFactory.getLogger(AbstractResultHandler.class);

    public AbstractResultHandler() {
        Type[] typeParameters = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        if (typeParameters != null && typeParameters.length == 2) {
            try {
                this.addHandler(Class.forName(typeParameters[0].getTypeName()), Class.forName(typeParameters[1].getTypeName()));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isReturnTypeInterface(Class returnType) {
        return returnType.isInterface();
    }

    @Override
    public T handle(Class returnType, ResultSet result, Class resultType) {
        if (returnType == ResultSet.class) {
            return (T)result;
        }
        if (!result.isSucceeded()) {
            throw new QueryException(result.getErrorMessage());
        }
        boolean basicType = ReflectUtil.isBasicType(returnType);
        Object newResult = null;
        if (!basicType) {
            newResult = this.newInstance(returnType, resultType);
        }
        if (!(newResult instanceof Collection) && result.rowsSize() == 0) {
            return null;
        }
        if (!(newResult instanceof Collection) && result.rowsSize() > 1) {
            throw new ResultHandleException("\u8fd4\u56de\u503c\u8981\u6c42\u53ea\u6709\u4e00\u4e2a\u503c\uff0c\u4f46\u5374\u51fa\u73b0\u4e86\u4e00\u884c\u4ee5\u4e0a\u8bb0\u5f55\u3002");
        }
        List columnNames = result.getColumnNames();
        if (basicType && columnNames.size() > 1) {
            throw new ResultHandleException("\u63a5\u53e3\u8fd4\u56de\u7c7b\u578b\u4e3a\u57fa\u672c\u7c7b\u578b\uff0c\u7ed3\u679c\u96c6\u5374\u5b58\u5728\u591a\u4e2a\u5217\u3002" + columnNames);
        }
        try {
            return this.handle(newResult, result, resultType);
        }
        catch (Exception e) {
            throw new ResultHandleException(e);
        }
    }

    protected T newInstance(Class<T> returnType, Class resultType) {
        if (this.isReturnTypeInterface(returnType)) {
            return this.defaultInstance(returnType);
        }
        try {
            Object t = resultType.newInstance();
            return t;
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.log.error("resultType: {}\uff0c\u4e0d\u652f\u6301\u5b9e\u4f8b\u5316\uff0c\u8bf7\u63d0\u4f9b\u65e0\u53c2\u6784\u9020\u5668\u3002", (Object)resultType.getName());
            return null;
        }
    }

    protected T defaultInstance(Class<?> returnType) {
        ArrayList o = returnType == List.class ? new ArrayList() : (returnType == Set.class ? new HashSet() : (returnType == Queue.class ? new ConcurrentLinkedQueue() : (returnType == Map.class ? new HashMap() : null)));
        return (T)o;
    }

    void addHandler(Class returnType, Class resultType) {
        AbstractResultHandler bean = this;
        DIFF_TYPE_RESULT_HANDLER.put((Object)returnType, (Object)resultType, (Object)bean);
        HANDLERS.putIfAbsent(returnType, bean);
    }

    protected String getLastName(String name) {
        String[] split = name.split("\\.");
        if (split.length == 1) {
            return split[0];
        }
        return split[split.length - 1];
    }

    protected String getLastLabel(String[] labels) {
        int length;
        if (labels != null && (length = labels.length) > 0) {
            return labels[length - 1];
        }
        return null;
    }
}

