/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.persistence.Table;
import org.nebula.contrib.ngbatis.models.ClassModel;
import org.nebula.contrib.ngbatis.models.MapperContext;
import org.nebula.contrib.ngbatis.models.MethodModel;
import org.nebula.contrib.ngbatis.proxy.MapperProxy;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;
import org.nebula.contrib.ngbatis.utils.StringUtil;
import org.springframework.util.Assert;

public class NebulaDaoBasicExt {
    public static String vertexName(Class<?> entityType) {
        Table tableAnno = entityType.getAnnotation(Table.class);
        return tableAnno != null ? tableAnno.name() : StringUtil.camelToUnderline(entityType.getSimpleName());
    }

    public static String edgeName(Class<?> edgeType) {
        return NebulaDaoBasicExt.vertexName(edgeType);
    }

    public static Class<?>[] entityTypeAndIdType(Class<?> currentType) {
        Type[] genericInterfaces;
        Class<?>[] result = null;
        for (Type genericInterface : genericInterfaces = currentType.getGenericInterfaces()) {
            if (ReflectUtil.isCurrentTypeOrParentType(genericInterface.getClass(), ParameterizedType.class)) {
                Type[] actualTypeArguments = ((ParameterizedType)genericInterface).getActualTypeArguments();
                result = new Class[]{(Class)actualTypeArguments[0], (Class)actualTypeArguments[1]};
                continue;
            }
            if (!(genericInterface instanceof Class)) continue;
            result = NebulaDaoBasicExt.entityTypeAndIdType((Class)genericInterface);
        }
        return result;
    }

    public static Class<?> entityType(Class<?> currentType) {
        Class<?>[] entityTypeAndIdType = NebulaDaoBasicExt.entityTypeAndIdType(currentType);
        if (entityTypeAndIdType != null && entityTypeAndIdType.length > 0) {
            return entityTypeAndIdType[0];
        }
        return null;
    }

    public static Class<?> entityType() {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
        Class<?> currentType = NebulaDaoBasicExt.getClassFromStack(stackTraceElement);
        return NebulaDaoBasicExt.entityType(currentType);
    }

    public static Class<?> pkType(Class<?> currentType) {
        Class<?>[] entityTypeAndIdType = NebulaDaoBasicExt.entityTypeAndIdType(currentType);
        if (entityTypeAndIdType != null && entityTypeAndIdType.length > 1) {
            return entityTypeAndIdType[1];
        }
        return null;
    }

    public static Object proxy(Class<?> currentType, Class<?> returnType, String gql, Class<?>[] argTypes, Object ... args) {
        Method method = null;
        try {
            String methodName = NebulaDaoBasicExt.getMethodName();
            method = currentType.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException methodName) {
            // empty catch block
        }
        MethodModel methodModel = new MethodModel();
        methodModel.setMethod(method);
        methodModel.setResultType(returnType);
        methodModel.setText(gql);
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(currentType);
        return MapperProxy.invoke(classModel, methodModel, args);
    }

    public static String getCqlTpl() {
        Map<String, String> daoBasicTpl = MapperProxy.ENV.getMapperContext().getDaoBasicTpl();
        return daoBasicTpl.get(NebulaDaoBasicExt.getMethodName());
    }

    public static Class<?> getClassFromStack(StackTraceElement stackTraceElement) {
        String className = stackTraceElement.getClassName();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public static ClassModel getClassModel(Class<?> dao) {
        Map<String, ClassModel> interfaces = MapperContext.newInstance().getInterfaces();
        return interfaces.get(dao.getName());
    }

    public static MethodModel getMethodModel() {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
        String methodName = stackTraceElement.getMethodName();
        Class<?> dao = NebulaDaoBasicExt.getClassFromStack(stackTraceElement);
        Assert.notNull(dao, (String)"Please check the invoke stack.");
        Method[] methods = dao.getMethods();
        Method method = null;
        for (Method m : methods) {
            if (!methodName.equals(m.getName())) continue;
            method = m;
            break;
        }
        Assert.notNull(method, (String)"Please check the invoke stack.");
        MethodModel methodModel = new MethodModel();
        methodModel.setMethod(method);
        methodModel.setId(methodName);
        methodModel.setReturnType(method.getReturnType());
        Map<String, String> daoBasicTpl = MapperProxy.ENV.getMapperContext().getDaoBasicTpl();
        methodModel.setText(daoBasicTpl.get(methodName));
        return methodModel;
    }

    public static String getMethodName() {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[3];
        return stackTraceElement.getMethodName();
    }
}

