/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.session;

import com.vesoft.nebula.client.graph.NebulaPoolConfig;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.nebula.contrib.ngbatis.SessionDispatcher;
import org.nebula.contrib.ngbatis.config.EnvConfig;
import org.nebula.contrib.ngbatis.proxy.MapperProxy;
import org.nebula.contrib.ngbatis.session.LocalSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntervalCheckSessionDispatcher
implements Runnable,
SessionDispatcher {
    public static long SESSION_LIFE_LENGTH = 18000000L;
    public static long CHECK_FIXED_RATE = 18000000L;
    private static Logger log = LoggerFactory.getLogger(IntervalCheckSessionDispatcher.class);
    private final NebulaPoolConfig nebulaPoolConfig;
    private final ArrayBlockingQueue<LocalSession> sessionQueue;
    private final ScheduledExecutorService threadPool;

    public IntervalCheckSessionDispatcher(NebulaPoolConfig nebulaPoolConfig) {
        this.nebulaPoolConfig = nebulaPoolConfig;
        this.sessionQueue = new ArrayBlockingQueue(nebulaPoolConfig.getMaxConnSize());
        this.threadPool = EnvConfig.reconnect ? Executors.newScheduledThreadPool(1) : null;
        this.wakeUp();
    }

    @Override
    public void run() {
        for (LocalSession session : this.sessionQueue) {
            log.info("LocalSession in queue which created at {}, useCount: {}", (Object)session.getBirth(), (Object)session.useCount);
            boolean finished = this.timeToRelease(session);
            if (!finished && session.getSession().ping()) continue;
            log.info("Release a session which created at {}", (Object)session.getBirth());
            this.release(session);
        }
        while (this.sessionQueue.size() < this.nebulaPoolConfig.getMinConnSize()) {
            this.offer();
        }
    }

    @Override
    public void offer(LocalSession session) {
        boolean offer = this.sessionQueue.offer(session);
        if (!offer) {
            this.releaseInnerSession(session);
        }
    }

    private void offer() {
        LocalSession localSession = this.newLocalSession();
        this.offer(localSession);
    }

    @Override
    public synchronized LocalSession poll() {
        LocalSession localSession = null;
        if (!EnvConfig.reconnect) {
            localSession = this.newLocalSession();
            ++localSession.useCount;
            return localSession;
        }
        try {
            localSession = this.sessionQueue.poll(this.nebulaPoolConfig.getWaitTime(), TimeUnit.MILLISECONDS);
            localSession = localSession == null ? this.newLocalSession() : localSession;
            ++localSession.useCount;
            return localSession;
        }
        catch (InterruptedException e) {
            return this.newLocalSession();
        }
    }

    private void wakeUp() {
        if (this.threadPool != null) {
            this.threadPool.scheduleAtFixedRate(this, 3L, CHECK_FIXED_RATE, TimeUnit.MILLISECONDS);
        }
    }

    private LocalSession newLocalSession() {
        return new LocalSession(System.currentTimeMillis(), MapperProxy.ENV.openSession());
    }

    private void releaseInnerSession(LocalSession session) {
        session.getSession().release();
    }

    private void release(LocalSession session) {
        session.getSession().release();
        this.sessionQueue.remove(session);
    }

    private boolean timeToRelease(LocalSession session) {
        long birth = session.getBirth();
        return System.currentTimeMillis() - birth > SESSION_LIFE_LENGTH;
    }
}

