/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.handler;

import com.vesoft.nebula.client.graph.data.Relationship;
import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import java.io.UnsupportedEncodingException;
import org.nebula.contrib.ngbatis.exception.ResultHandleException;
import org.nebula.contrib.ngbatis.handler.AbstractResultHandler;
import org.nebula.contrib.ngbatis.models.data.NgEdge;
import org.nebula.contrib.ngbatis.utils.ResultSetUtil;
import org.springframework.stereotype.Component;

@Component
public class NgEdgeResultHandler
extends AbstractResultHandler<NgEdge<?>, NgEdge<?>> {
    @Override
    public NgEdge<?> handle(NgEdge<?> newResult, ResultSet result, Class resultType) throws NoSuchFieldException, IllegalAccessException, InstantiationException {
        ResultSet.Record row = result.rowValues(0);
        return this.handle(newResult, row);
    }

    public NgEdge<?> handle(NgEdge<?> newResult, ResultSet.Record row) {
        ValueWrapper relationship = row.get(0);
        return this.handle(newResult, relationship);
    }

    public NgEdge<?> handle(NgEdge<?> newResult, ValueWrapper relationshipValueWrapper) {
        try {
            Relationship relationship = relationshipValueWrapper.asRelationship();
            newResult.setEdgeName(relationship.edgeName());
            long ranking = relationship.ranking();
            newResult.setRank(ranking);
            newResult.setSrcID(ResultSetUtil.getValue(relationship.srcId()));
            newResult.setDstID(ResultSetUtil.getValue(relationship.dstId()));
            newResult.setProperties(ResultSetUtil.edgePropsToMap(relationship));
            return newResult;
        }
        catch (UnsupportedEncodingException e) {
            throw new ResultHandleException(String.format("%s : %s", e.getClass().toString(), e.getMessage()));
        }
    }
}

