/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.handler;

import com.vesoft.nebula.client.graph.data.PathWrapper;
import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import org.nebula.contrib.ngbatis.handler.AbstractResultHandler;
import org.nebula.contrib.ngbatis.models.data.NgPath;
import org.nebula.contrib.ngbatis.utils.ResultSetUtil;
import org.springframework.stereotype.Component;

@Component
public class NgPathResultHandler
extends AbstractResultHandler<NgPath<?>, NgPath<?>> {
    @Override
    public NgPath<?> handle(NgPath<?> newResult, ResultSet result, Class resultType) throws NoSuchFieldException, IllegalAccessException, InstantiationException {
        ResultSet.Record record = result.rowValues(0);
        return this.handle(newResult, record);
    }

    public NgPath<?> handle(NgPath<?> newResult, ResultSet.Record record) {
        PathWrapper pathWrapper = (PathWrapper)ResultSetUtil.getValue((ValueWrapper)record.values().get(0));
        pathWrapper.getRelationships().forEach(relationship -> {
            NgPath.Relationship ngRelationship = new NgPath.Relationship();
            long ranking = relationship.ranking();
            Object srcId = ResultSetUtil.getValue(relationship.srcId());
            Object dstId = ResultSetUtil.getValue(relationship.dstId());
            String edgeName = relationship.edgeName();
            ngRelationship.setRank(ranking);
            ngRelationship.setSrcID(srcId);
            ngRelationship.setDstID(dstId);
            ngRelationship.setEdgeName(edgeName);
            newResult.getRelationships().add(ngRelationship);
        });
        return newResult;
    }
}

