/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.binding.beetl.functions;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nebula.contrib.ngbatis.binding.beetl.functions.AbstractFunction;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;

public class KvFn
extends AbstractFunction<Object, String, Boolean, Boolean, Boolean, Void> {
    @Override
    public Object call(Object entity, String prefix, Boolean excludePk, Boolean selective, Boolean idRequired) {
        excludePk = excludePk == null || excludePk != false;
        selective = selective != null && selective != false;
        idRequired = idRequired == null || idRequired != false;
        if (entity == null) {
            return new KV();
        }
        if (entity instanceof Map) {
            return this.mapToKv((Map)entity, prefix, selective);
        }
        Class<?> entityType = entity.getClass();
        Field[] fields = ReflectUtil.getAllColumnFields(entityType);
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Field pkField = null;
        if (excludePk.booleanValue()) {
            pkField = (Field)this.fnCall(this.pkFieldFn, entityType, idRequired);
        }
        for (Field field : fields) {
            if (pkField != null && pkField.equals(field)) continue;
            fieldList.add(field);
        }
        return this.recordToKV(entity, fieldList, selective, prefix);
    }

    private Object mapToKv(Map<String, Object> map, String prefix, Boolean selective) {
        KV kv = new KV();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            String name = null;
            Object value = map.get(key);
            if (!selective.booleanValue() || value != null) {
                name = key;
            }
            if (name == null) continue;
            kv.columns.add(name);
            Object[] paras = new Object[]{value};
            kv.values.add(this.fnCall(this.valueFmtFn, paras));
            Class<?> type = value == null ? null : value.getClass();
            kv.types.add(type);
            String valueName = StringUtils.isEmpty((CharSequence)prefix) ? name : String.format("%s.%s", prefix, name);
            kv.valueNames.add(valueName);
        }
        return kv;
    }

    public KV recordToKV(Object record, Iterable<Field> fields, boolean selective, String prefix) {
        KV kv = new KV();
        this.initFieldGroups(record, kv);
        for (Field field : fields) {
            String name = null;
            Object value = ReflectUtil.getValue(record, field);
            if (!selective || value != null) {
                name = ReflectUtil.getNameByColumn(field);
            }
            if (name == null) continue;
            Class<?> entityType = field.getDeclaringClass();
            String tagName = ReflectUtil.schemaByEntityType(entityType);
            List currentTagColumns = kv.multiTagColumns.computeIfAbsent(tagName, k -> new ArrayList());
            currentTagColumns.add(name);
            kv.columns.add(name);
            Object[] paras = new Object[]{value};
            kv.values.add(this.fnCall(this.valueFmtFn, paras));
            kv.types.add(field.getType());
            String valueName = StringUtils.isEmpty((CharSequence)prefix) ? name : String.format("%s.%s", prefix, name);
            kv.valueNames.add(valueName);
        }
        return kv;
    }

    private void initFieldGroups(Object record, KV kv) {
        Set<String> tagNames = ReflectUtil.getAllTagName(record.getClass(), true);
        tagNames.forEach(tagName -> {
            List cfr_ignored_0 = kv.multiTagColumns.putIfAbsent((String)tagName, new ArrayList());
        });
    }

    public static class KV {
        public final Map<String, List<String>> multiTagColumns = new LinkedHashMap<String, List<String>>();
        public final List<String> columns = new ArrayList<String>();
        public final List<String> valueNames = new ArrayList<String>();
        public final List<Object> values = new ArrayList<Object>();
        public final List<Class<?>> types = new ArrayList();
    }
}

