/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.binding.beetl.functions;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import org.apache.commons.text.StringEscapeUtils;
import org.nebula.contrib.ngbatis.binding.beetl.functions.AbstractFunction;

public class ValueFmtFn
extends AbstractFunction<Object, Boolean, Boolean, Void, Void, Void> {
    private static final String DATE_FMT = "yyyy-MM-dd";
    private static final String TIME_FMT = "HH:mm:ss.SSS";
    private static final String DATETIME_FMT = String.format("%s'T'%s", "yyyy-MM-dd", "HH:mm:ss.SSS");
    private static boolean escape = true;
    private static String parameterQuote = "\"";

    public static void setEscape(boolean escape) {
        ValueFmtFn.escape = escape;
    }

    public static void setParameterQuote(String parameterQuote) {
        ValueFmtFn.parameterQuote = parameterQuote;
    }

    @Override
    public Object call(Object value, Boolean ifStringLike, Boolean escape) {
        ifStringLike = ifStringLike != null && ifStringLike != false;
        escape = escape != null ? escape : ValueFmtFn.escape;
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            value = escape != false ? StringEscapeUtils.escapeJava((String)((String)value)) : value;
            return ifStringLike != false ? String.format("%s.*%s.*%s", parameterQuote, value, parameterQuote) : String.format("%s%s%s", parameterQuote, value, parameterQuote);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        if (value instanceof Duration) {
            return String.format("duration({seconds: %d})", ((Duration)value).getSeconds());
        }
        if (value instanceof Date) {
            Class<?> objClass = value.getClass();
            if (objClass == Timestamp.class) {
                return String.format("%s(%d)", "timestamp", ((Timestamp)value).getTime() / 1000L);
            }
            String timePattern = objClass == Date.class ? DATETIME_FMT : (objClass == java.sql.Date.class ? DATE_FMT : (objClass == Time.class ? TIME_FMT : DATETIME_FMT));
            SimpleDateFormat sdf = new SimpleDateFormat(timePattern);
            String fn = "datetime";
            fn = objClass == Date.class ? "datetime" : (objClass == java.sql.Date.class ? "date" : (objClass == Time.class ? "time" : fn));
            return String.format("%s('%s')", fn, sdf.format(value));
        }
        return value;
    }
}

