/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.config;

import com.vesoft.nebula.client.graph.NebulaPoolConfig;
import com.vesoft.nebula.client.graph.data.HostAddress;
import java.util.ArrayList;
import java.util.List;
import org.nebula.contrib.ngbatis.config.NgbatisConfig;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="nebula")
public class NebulaJdbcProperties {
    private List<HostAddress> hostAddresses;
    private String hosts;
    private NebulaPoolConfig poolConfig;
    private NgbatisConfig ngbatis;
    private String username;
    private String password;
    private String space;

    public List<HostAddress> getHostAddresses() {
        return this.hostAddresses;
    }

    public String getHosts() {
        return this.hosts;
    }

    public NebulaJdbcProperties setHosts(String hosts) {
        String[] hostArr = hosts.split(",");
        this.hostAddresses = new ArrayList<HostAddress>();
        for (int i = 0; i < hostArr.length; ++i) {
            String ipAndPort = hostArr[i];
            String[] iandp = ipAndPort.split(":");
            this.hostAddresses.add(new HostAddress(iandp[0].trim(), Integer.parseInt(iandp[1].trim())));
        }
        this.hosts = hosts;
        return this;
    }

    public NebulaPoolConfig getPoolConfig() {
        return this.poolConfig;
    }

    public NebulaJdbcProperties setPoolConfig(NebulaPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public NebulaJdbcProperties setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public NebulaJdbcProperties setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getSpace() {
        return this.space;
    }

    public NebulaJdbcProperties setSpace(String space) {
        this.space = space;
        return this;
    }

    public NgbatisConfig getNgbatis() {
        return this.ngbatis;
    }

    public NebulaJdbcProperties setNgbatis(NgbatisConfig ngbatis) {
        this.ngbatis = ngbatis;
        return this;
    }
}

