/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.proxy;

import com.vesoft.nebula.client.graph.SessionPool;
import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.exception.BindSpaceFailedException;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.Session;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.nebula.contrib.ngbatis.ArgsResolver;
import org.nebula.contrib.ngbatis.Env;
import org.nebula.contrib.ngbatis.ResultResolver;
import org.nebula.contrib.ngbatis.SessionDispatcher;
import org.nebula.contrib.ngbatis.config.NgbatisConfig;
import org.nebula.contrib.ngbatis.config.ParseCfgProps;
import org.nebula.contrib.ngbatis.exception.QueryException;
import org.nebula.contrib.ngbatis.models.ClassModel;
import org.nebula.contrib.ngbatis.models.MapperContext;
import org.nebula.contrib.ngbatis.models.MethodModel;
import org.nebula.contrib.ngbatis.session.LocalSession;
import org.nebula.contrib.ngbatis.utils.Page;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;
import org.nebula.contrib.ngbatis.utils.ResultSetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MapperProxy {
    public static Env ENV;
    private static Logger log;
    @Autowired
    private ParseCfgProps props;
    private ClassModel classModel;
    private Map<String, MethodModel> methodCache = new HashMap<String, MethodModel>();

    public MapperProxy(ClassModel classModel) {
        this.classModel = classModel;
        this.methods(classModel);
    }

    public static Object invoke(String className, String methodName, Object ... args) {
        MapperContext mapperContext = ENV.getMapperContext();
        String proxyClassName = className + "$Proxy";
        ClassModel classModel = mapperContext.getInterfaces().get(proxyClassName);
        Method method = null;
        if (mapperContext.isResourceRefresh()) {
            try {
                Map<String, ClassModel> classModelMap = classModel.getResourceLoader().parseClassModel(classModel.getResource());
                classModel = classModelMap.get(proxyClassName);
                method = classModel.getMethod(methodName).getMethod();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            method = classModel.getMethod(methodName).getMethod();
        }
        return MapperProxy.pageSupport(classModel, method, args);
    }

    public static Object invoke(MethodModel methodModel, Object ... args) {
        return MapperProxy.invoke(null, methodModel, args);
    }

    public static Object invoke(final ClassModel classModel, final MethodModel methodModel, final Object ... args) {
        Method method = methodModel.getMethod();
        ResultSet query = null;
        long step0 = System.currentTimeMillis();
        ArgsResolver argsResolver = ENV.getArgsResolver();
        Map<String, Object> argMap = argsResolver.resolveForTemplate(methodModel, args);
        LinkedHashMap<String, Object> paramWithSchema = new LinkedHashMap<String, Object>(argMap){
            {
                super(x0);
                this.put("ng_cm", classModel);
                this.put("ng_mm", methodModel);
                this.put("ng_args", args);
            }
        };
        String textTpl = methodModel.getText();
        String gql = ENV.getTextResolver().resolve(textTpl, (Map<String, Object>)paramWithSchema);
        Map<String, Object> parasForDb = argsResolver.resolve(methodModel, args);
        long step1 = System.currentTimeMillis();
        NgbatisConfig ngbatisConfig = MapperContext.newInstance().getNgbatisConfig();
        query = ngbatisConfig == null || ngbatisConfig.getUseSessionPool() == false ? MapperProxy.executeWithParameter(classModel, methodModel, gql, parasForDb, argMap) : MapperProxy.executeBySessionPool(classModel, methodModel, gql, parasForDb, argMap);
        long step2 = System.currentTimeMillis();
        if (!query.isSucceeded()) {
            throw new QueryException("\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff1a" + query.getErrorMessage());
        }
        if (methodModel.getResultType() == ResultSet.class) {
            return query;
        }
        ResultResolver resultResolver = ENV.getResultResolver();
        Object resolve = resultResolver.resolve(methodModel, query);
        long step3 = System.currentTimeMillis();
        log.debug("nGql make up costs {}ms, query costs {}ms, result handle costs {}ms ", new Object[]{step1 - step0, step2 - step1, step3 - step2});
        return resolve;
    }

    public Object invoke(Method method, Object ... args) {
        return this.invoke(null, method, args);
    }

    public Object invoke(ClassModel classModel, Method method, Object ... args) {
        MethodModel methodModel = this.methodCache.get(method.getName());
        methodModel.setMethod(method);
        return MapperProxy.invoke(classModel, methodModel, args);
    }

    private static Object pageSupport(ClassModel classModel, Method method, Object[] args) {
        int pageParamIndex = ReflectUtil.containsType(method, Page.class);
        MapperProxy mapperProxy = new MapperProxy(classModel);
        if (pageParamIndex < 0) {
            return mapperProxy.invoke(classModel, method, args);
        }
        String countMethodName = method.getName() + "$Count";
        String pageMethodName = method.getName() + "$Page";
        Long count = (Long)MapperProxy.invoke(classModel, classModel.getMethods().get(countMethodName), args);
        List rows = (List)MapperProxy.invoke(classModel, classModel.getMethods().get(pageMethodName), args);
        Page page = (Page)args[pageParamIndex];
        page.setTotal(count);
        page.setRows(rows);
        return rows;
    }

    public static ResultSet executeWithParameter(ClassModel cm, MethodModel mm, String gql, Map<String, Object> params, Map<String, Object> paramsForTemplate) {
        SessionDispatcher dispatcher;
        String autoSwitch;
        String localSessionSpace;
        String proxyMethod;
        String proxyClass;
        ResultSet result;
        LocalSession localSession;
        block8: {
            localSession = null;
            Session session = null;
            result = null;
            proxyClass = null;
            proxyMethod = null;
            localSessionSpace = null;
            autoSwitch = null;
            dispatcher = ENV.getDispatcher();
            localSession = dispatcher.poll();
            if (log.isDebugEnabled()) {
                StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[6];
                proxyClass = stackTraceElement.getClassName();
                proxyMethod = stackTraceElement.getMethodName();
                localSessionSpace = localSession.getCurrentSpace();
            }
            String currentSpace = MapperProxy.getSpace(cm, mm, paramsForTemplate);
            String[] qlAndSpace = MapperProxy.qlWithSpace(localSession, gql, currentSpace);
            gql = qlAndSpace[1];
            autoSwitch = qlAndSpace[0] == null ? "" : qlAndSpace[0];
            session = localSession.getSession();
            result = session.executeWithParameter(gql, params);
            localSession.setCurrentSpace(MapperProxy.getSpace(result));
            if (!result.isSucceeded()) break block8;
            ResultSet resultSet = result;
            if (log.isDebugEnabled()) {
                log.debug("\n\t- proxyMethod: {}#{}\n\t- session space: {}" + (ObjectUtils.isEmpty((Object)autoSwitch) ? "\n\t- {}" : "\n\t- auto switch to: {}") + "\n\t- nGql\uff1a{}\n\t- params: {}\n\t- result\uff1a{}", new Object[]{proxyClass, proxyMethod, localSessionSpace, autoSwitch, gql, paramsForTemplate, result});
            }
            MapperProxy.handleSession(dispatcher, localSession, result);
            return resultSet;
        }
        try {
            try {
                throw new QueryException(" \u6570\u636e\u67e5\u8be2\u5931\u8d25" + result.getErrorMessage());
            }
            catch (Exception e) {
                throw new QueryException("\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            if (log.isDebugEnabled()) {
                log.debug("\n\t- proxyMethod: {}#{}\n\t- session space: {}" + (ObjectUtils.isEmpty(autoSwitch) ? "\n\t- {}" : "\n\t- auto switch to: {}") + "\n\t- nGql\uff1a{}\n\t- params: {}\n\t- result\uff1a{}", new Object[]{proxyClass, proxyMethod, localSessionSpace, autoSwitch, gql, paramsForTemplate, result});
            }
            MapperProxy.handleSession(dispatcher, localSession, result);
            throw throwable;
        }
    }

    public static ResultSet executeBySessionPool(ClassModel cm, MethodModel mm, String gql, Map<String, Object> params, Map<String, Object> paramsForTemplate) {
        String currentSpace;
        String proxyMethod;
        String proxyClass;
        ResultSet result;
        block9: {
            SessionPool sessionPool;
            result = null;
            proxyClass = null;
            proxyMethod = null;
            currentSpace = null;
            if (log.isDebugEnabled()) {
                StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[6];
                proxyClass = stackTraceElement.getClassName();
                proxyMethod = stackTraceElement.getMethodName();
            }
            if ((sessionPool = ENV.getSessionPool(currentSpace = MapperProxy.getSpace(cm, mm, paramsForTemplate))) == null) {
                throw new QueryException(currentSpace + " sessionPool is null");
            }
            result = sessionPool.execute(gql, params);
            if (!result.isSucceeded()) break block9;
            ResultSet resultSet = result;
            if (log.isDebugEnabled()) {
                log.debug("\n\t- proxyMethod: {}#{}\n\t- session space: {}\n\t- nGql\uff1a{}\n\t- params: {}\n\t- result\uff1a{}", new Object[]{proxyClass, proxyMethod, currentSpace, gql, paramsForTemplate, result});
            }
            return resultSet;
        }
        try {
            try {
                throw new QueryException(" ResultSet error: " + result.getErrorMessage());
            }
            catch (Exception e) {
                throw new QueryException("execute failed: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            if (log.isDebugEnabled()) {
                log.debug("\n\t- proxyMethod: {}#{}\n\t- session space: {}\n\t- nGql\uff1a{}\n\t- params: {}\n\t- result\uff1a{}", new Object[]{proxyClass, proxyMethod, currentSpace, gql, paramsForTemplate, result});
            }
            throw throwable;
        }
    }

    private static void handleSession(SessionDispatcher dispatcher, LocalSession localSession, ResultSet result) {
        if (localSession != null) {
            boolean sessionError = ResultSetUtil.isSessionError(result);
            if (sessionError || dispatcher.timeToRelease(localSession)) {
                dispatcher.release(localSession);
            } else {
                dispatcher.offer(localSession);
            }
        }
    }

    private static String[] qlWithSpace(LocalSession localSession, String gql, String currentSpace) throws IOErrorException, BindSpaceFailedException {
        String[] qlAndSpace = new String[2];
        gql = gql.trim();
        String sessionSpace = localSession.getCurrentSpace();
        boolean sameSpace = Objects.equals(sessionSpace, currentSpace);
        if (!sameSpace && currentSpace != null) {
            qlAndSpace[0] = currentSpace;
            Session session = localSession.getSession();
            ResultSet execute = session.execute(String.format("USE `%s`", currentSpace));
            if (!execute.isSucceeded()) {
                throw new BindSpaceFailedException(String.format(" %s \"%s\"", execute.getErrorMessage(), currentSpace));
            }
        }
        qlAndSpace[1] = String.format("\n\t\t%s", gql);
        return qlAndSpace;
    }

    public static String getSpace(ClassModel cm, MethodModel mm) {
        String methodSpace;
        return mm != null && (methodSpace = mm.getSpace()) != null ? ("null".equals(methodSpace.trim()) ? null : methodSpace) : (cm != null && cm.getSpace() != null ? cm.getSpace() : ENV.getSpace());
    }

    public static String getSpace(ClassModel cm, MethodModel mm, Map<String, Object> paramsForTemplate) {
        boolean spaceFromParam = mm.isSpaceFromParam();
        String space = MapperProxy.getSpace(cm, mm);
        if (spaceFromParam && space != null) {
            return ENV.getTextResolver().resolve(space, paramsForTemplate);
        }
        return space;
    }

    private static String getSpace(ResultSet result) {
        String spaceName = result.getSpaceName();
        return StringUtils.isBlank((CharSequence)spaceName) ? null : spaceName;
    }

    public static Logger getLog() {
        return log;
    }

    public static void setLog(Logger log) {
        MapperProxy.log = log;
    }

    private void methods(ClassModel classModel) {
        this.methodCache.clear();
        Map<String, MethodModel> methods = classModel.getMethods();
        this.methodCache.putAll(methods);
    }

    public ParseCfgProps getProps() {
        return this.props;
    }

    public void setProps(ParseCfgProps props) {
        this.props = props;
    }

    public ClassModel getClassModel() {
        return this.classModel;
    }

    public void setClassModel(ClassModel classModel) {
        this.classModel = classModel;
    }

    public Map<String, MethodModel> getMethodCache() {
        return this.methodCache;
    }

    public void setMethodCache(Map<String, MethodModel> methodCache) {
        this.methodCache = methodCache;
    }

    static {
        log = LoggerFactory.getLogger(MapperProxy.class);
    }
}

