/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.proxy;

import com.sun.istack.NotNull;
import com.vesoft.nebula.client.graph.data.ResultSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nebula.contrib.ngbatis.exception.QueryException;
import org.nebula.contrib.ngbatis.models.ClassModel;
import org.nebula.contrib.ngbatis.models.MethodModel;
import org.nebula.contrib.ngbatis.models.data.NgPath;
import org.nebula.contrib.ngbatis.proxy.MapperProxy;
import org.nebula.contrib.ngbatis.proxy.NebulaDaoBasicExt;
import org.nebula.contrib.ngbatis.utils.Page;
import org.springframework.data.repository.query.Param;

public interface NebulaDaoBasic<T, I extends Serializable> {
    default public T selectById(@Param(value="id") I id) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        return (T)MapperProxy.invoke(classModel, methodModel, id);
    }

    default public List<T> selectByIds(@Param(value="ids") Collection<I> ids) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        Class<?> currentType = this.getClass();
        Class<?> entityType = NebulaDaoBasicExt.entityType(currentType);
        methodModel.setResultType(entityType);
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        return (List)MapperProxy.invoke(classModel, methodModel, ids);
    }

    default public List<T> selectBySelective(T record) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        methodModel.setReturnType(List.class);
        Class<?> daoType = this.getClass();
        methodModel.setResultType(NebulaDaoBasicExt.entityType(daoType));
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(daoType);
        return (List)MapperProxy.invoke(classModel, methodModel, record);
    }

    default public List<T> selectBySelectiveStringLike(T record) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        methodModel.setReturnType(List.class);
        Class<?> daoType = this.getClass();
        methodModel.setResultType(NebulaDaoBasicExt.entityType(daoType));
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(daoType);
        return (List)MapperProxy.invoke(classModel, methodModel, record);
    }

    default public List<I> selectIdBySelective(T record) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        Class<?> daoType = this.getClass();
        methodModel.setResultType(NebulaDaoBasicExt.pkType(daoType));
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(daoType);
        return (List)MapperProxy.invoke(classModel, methodModel, record);
    }

    default public List<I> selectIdBySelectiveStringLike(T record) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        Class<?> daoType = this.getClass();
        methodModel.setResultType(NebulaDaoBasicExt.pkType(daoType));
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(daoType);
        return (List)MapperProxy.invoke(classModel, methodModel, record);
    }

    default public List<T> selectByMap(Map<String, Object> param) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        methodModel.setReturnType(List.class);
        Class<?> daoType = this.getClass();
        methodModel.setResultType(NebulaDaoBasicExt.entityType(daoType));
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(daoType);
        return (List)MapperProxy.invoke(classModel, methodModel, param);
    }

    default public Long countByMap(Map<String, Object> param) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        return (Long)MapperProxy.invoke(classModel, methodModel, param);
    }

    default public List<T> selectPage(Page<T> page) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        Long total = this.countPage(page);
        page.setTotal(total);
        if (total == 0L) {
            return Collections.EMPTY_LIST;
        }
        methodModel.setReturnType(List.class);
        Class<?> daoType = this.getClass();
        methodModel.setResultType(NebulaDaoBasicExt.entityType(daoType));
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(daoType);
        List proxy = (List)MapperProxy.invoke(classModel, methodModel, page);
        page.setRows(proxy);
        return proxy;
    }

    default public Long countPage(Page<T> page) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        return (Long)MapperProxy.invoke(classModel, methodModel, page);
    }

    default public Integer insert(T record) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        methodModel.setReturnType(ResultSet.class);
        methodModel.setResultType(ResultSet.class);
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        ResultSet resultSet = (ResultSet)MapperProxy.invoke(classModel, methodModel, record);
        return resultSet.isSucceeded() ? 1 : 0;
    }

    default public Integer insertSelective(T record) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        methodModel.setReturnType(ResultSet.class);
        methodModel.setResultType(ResultSet.class);
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        ResultSet resultSet = (ResultSet)MapperProxy.invoke(classModel, methodModel, record);
        return resultSet.isSucceeded() ? 1 : 0;
    }

    default public void insertBatch(List<T> ts) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        MapperProxy.invoke(classModel, methodModel, ts);
    }

    default public T updateById(T record) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        Class<?> entityType = record.getClass();
        methodModel.setReturnType(entityType);
        methodModel.setResultType(entityType);
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        MapperProxy.invoke(classModel, methodModel, record);
        return record;
    }

    default public T updateByIdSelective(T record) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        Class<?> entityType = record.getClass();
        methodModel.setReturnType(entityType);
        methodModel.setResultType(entityType);
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        MapperProxy.invoke(classModel, methodModel, record);
        return record;
    }

    default public void updateByIdBatchSelective(List<T> ts) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        MapperProxy.invoke(classModel, methodModel, ts);
    }

    default public void upsertByIdSelective(T record) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        Class<?> entityType = record.getClass();
        methodModel.setReturnType(entityType);
        methodModel.setResultType(entityType);
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        MapperProxy.invoke(classModel, methodModel, record);
    }

    default public int deleteLogicById(I id) {
        throw new QueryException("No implements");
    }

    default public Integer deleteWithEdgeById(I id) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        methodModel.setReturnType(ResultSet.class);
        methodModel.setResultType(ResultSet.class);
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        ResultSet resultSet = (ResultSet)MapperProxy.invoke(classModel, methodModel, id);
        return resultSet.isSucceeded() ? 1 : 0;
    }

    default public Integer deleteById(I id) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        methodModel.setReturnType(ResultSet.class);
        methodModel.setResultType(ResultSet.class);
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        ResultSet resultSet = (ResultSet)MapperProxy.invoke(classModel, methodModel, id);
        return resultSet.isSucceeded() ? 1 : 0;
    }

    default public Integer deleteByIdBatch(Collection<I> ids) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        methodModel.setReturnType(ResultSet.class);
        methodModel.setResultType(ResultSet.class);
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        ResultSet resultSet = (ResultSet)MapperProxy.invoke(classModel, methodModel, ids);
        return resultSet.isSucceeded() ? 1 : 0;
    }

    default public void insertEdge(@NotNull Object v1, @NotNull Object e, @NotNull Object v2) {
        if (v2 == null || v1 == null || e == null) {
            return;
        }
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        MapperProxy.invoke(classModel, methodModel, v1, e, v2);
    }

    default public void insertEdgeBatch(List triplets) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        MapperProxy.invoke(classModel, methodModel, triplets);
    }

    default public void insertEdgeSelective(@NotNull Object src, @NotNull Object edge, @NotNull Object dst) {
        if (dst == null || src == null || edge == null) {
            return;
        }
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        MapperProxy.invoke(classModel, methodModel, src, edge, dst);
    }

    default public void upsertEdgeSelective(@NotNull Object src, @NotNull Object edge, @NotNull Object dst) {
        if (dst == null || src == null || edge == null) {
            return;
        }
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        MapperProxy.invoke(classModel, methodModel, src, edge, dst);
    }

    default public Boolean existsEdge(I startId, Class<?> edgeType, I endId) {
        String cqlTpl = NebulaDaoBasicExt.getCqlTpl();
        String edgeName = NebulaDaoBasicExt.edgeName(edgeType);
        return (Boolean)NebulaDaoBasicExt.proxy(this.getClass(), Boolean.class, cqlTpl, new Class[]{Serializable.class, Class.class, Serializable.class}, startId, edgeName, endId);
    }

    default public List<T> listStartNodes(Class<?> edgeType, I endId) {
        Class<?> startType = NebulaDaoBasicExt.entityType(this.getClass());
        return this.listStartNodes(startType, edgeType, endId);
    }

    default public List<?> listStartNodes(Class<?> startType, Class<?> edgeType, I endId) {
        String cqlTpl = NebulaDaoBasicExt.getCqlTpl();
        String startVertexName = NebulaDaoBasicExt.vertexName(startType);
        String edgeName = NebulaDaoBasicExt.edgeName(edgeType);
        Class<?> daoType = this.getClass();
        Class<?> returnType = NebulaDaoBasicExt.entityType(daoType);
        return (List)NebulaDaoBasicExt.proxy(daoType, returnType, cqlTpl, new Class[]{Class.class, Class.class, Serializable.class}, startVertexName, edgeName, endId);
    }

    default public List<T> listEndNodes(I startId, Class<?> edgeType) {
        Class<?> endType = NebulaDaoBasicExt.entityType(this.getClass());
        return this.listEndNodes(startId, edgeType, endType);
    }

    default public List<?> listEndNodes(I startId, Class<?> edgeType, Class<?> endType) {
        String cqlTpl = NebulaDaoBasicExt.getCqlTpl();
        String endVertexName = NebulaDaoBasicExt.vertexName(endType);
        String edgeName = NebulaDaoBasicExt.edgeName(edgeType);
        Class<?> daoType = this.getClass();
        Class<?> returnType = NebulaDaoBasicExt.entityType(daoType);
        return (List)NebulaDaoBasicExt.proxy(daoType, returnType, cqlTpl, new Class[]{Serializable.class, Class.class, Class.class}, startId, edgeName, endVertexName);
    }

    default public T startNode(Class<?> edgeType, I endId) {
        Class<?> startType = NebulaDaoBasicExt.entityType(this.getClass());
        return (T)this.startNode(startType, edgeType, endId);
    }

    default public <E> E startNode(Class<E> startType, Class<?> edgeType, I endId) {
        String cqlTpl = NebulaDaoBasicExt.getCqlTpl();
        String startVertexName = NebulaDaoBasicExt.vertexName(startType);
        String edgeName = NebulaDaoBasicExt.edgeName(edgeType);
        Class<?> daoType = this.getClass();
        Class<?> returnType = NebulaDaoBasicExt.entityType(daoType);
        return (E)NebulaDaoBasicExt.proxy(daoType, returnType, cqlTpl, new Class[]{Class.class, Class.class, Serializable.class}, startVertexName, edgeName, endId);
    }

    default public List<NgPath<I>> shortestPath(@Param(value="srcId") I srcId, @Param(value="dstId") I dstId) {
        MethodModel methodModel = NebulaDaoBasicExt.getMethodModel();
        methodModel.setReturnType(Collection.class);
        methodModel.setResultType(NgPath.class);
        ClassModel classModel = NebulaDaoBasicExt.getClassModel(this.getClass());
        return (List)MapperProxy.invoke(classModel, methodModel, srcId, dstId);
    }
}

