/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.proxy;

import java.util.Map;
import org.nebula.contrib.ngbatis.Env;
import org.nebula.contrib.ngbatis.models.ClassModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamClassLoader
extends ClassLoader {
    private final Object lock = new Object();
    private Logger log = LoggerFactory.getLogger(RamClassLoader.class);
    private Map<String, ClassModel> classModelMap;

    public RamClassLoader(Map<String, ClassModel> classModelMap) {
        super(Env.classLoader);
        this.classModelMap = classModelMap;
        for (Map.Entry<String, ClassModel> classModelEntry : classModelMap.entrySet()) {
            this.loadClassCode(classModelEntry);
        }
    }

    private void loadClassCode(Map.Entry<String, ClassModel> entry) {
        String className = entry.getKey();
        byte[] classByte = entry.getValue().getClassByte();
        this.log.info("Proxy class had been load (\u4ee3\u7406\u7c7b\u88ab\u52a0\u8f7d): {}", (Object)className);
        this.defineClass(className, classByte, 0, classByte.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        Object object = this.lock;
        synchronized (object) {
            if (c == null) {
                if (!this.classModelMap.containsKey(name)) {
                    c = Env.classLoader.loadClass(name);
                    this.log.info("Class had been loaded: {}", (Object)name);
                } else {
                    throw new ClassNotFoundException("\u627e\u4e0d\u5230\u8be5class");
                }
            }
            return c;
        }
    }
}

