/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis;

import com.vesoft.nebula.client.graph.SessionPool;
import com.vesoft.nebula.client.graph.net.NebulaPool;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.nebula.contrib.ngbatis.PasswordDecoder;
import org.nebula.contrib.ngbatis.config.NebulaJdbcProperties;
import org.nebula.contrib.ngbatis.config.ParseCfgProps;
import org.nebula.contrib.ngbatis.io.DaoResourceLoader;
import org.nebula.contrib.ngbatis.models.ClassModel;
import org.nebula.contrib.ngbatis.models.MapperContext;
import org.nebula.contrib.ngbatis.proxy.MapperProxy;
import org.nebula.contrib.ngbatis.proxy.MapperProxyClassGenerator;
import org.nebula.contrib.ngbatis.proxy.NebulaDaoBasicExt;
import org.nebula.contrib.ngbatis.proxy.RamClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

class NgbatisBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    private Logger log = LoggerFactory.getLogger(NgbatisBeanFactoryPostProcessor.class);
    private NebulaJdbcProperties nebulaJdbcProperties;
    private ParseCfgProps parseCfgProps;
    private ConfigurableApplicationContext context;
    private MapperProxyClassGenerator beanFactory = new MapperProxyClassGenerator();

    public NgbatisBeanFactoryPostProcessor(NebulaJdbcProperties nebulaJdbcProperties, ParseCfgProps parseCfgProps, ConfigurableApplicationContext context) {
        this.nebulaJdbcProperties = nebulaJdbcProperties;
        this.parseCfgProps = parseCfgProps;
        this.context = context;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        this.setBeans(configurableListableBeanFactory);
        NebulaPool nebulaPool = this.nebulaPool();
        this.mapperContext(nebulaPool);
    }

    private void setBeans(ConfigurableListableBeanFactory beanFactory) {
        ObjectProvider passwordDecoders = beanFactory.getBeanProvider(PasswordDecoder.class);
        PasswordDecoder passwordDecoder = (PasswordDecoder)passwordDecoders.getIfAvailable();
        this.nebulaJdbcProperties.setPasswordDecoder(passwordDecoder);
    }

    public MapperContext mapperContext(NebulaPool nebulaPool) {
        DaoResourceLoader daoBasicResourceLoader = new DaoResourceLoader(this.parseCfgProps, (ApplicationContext)this.context);
        MapperContext context = MapperContext.newInstance();
        context.setResourceRefresh(this.parseCfgProps.isResourceRefresh());
        context.setNgbatisConfig(this.nebulaJdbcProperties.getNgbatis());
        Map<String, ClassModel> interfaces = daoBasicResourceLoader.load();
        Map<String, String> daoBasicTpl = daoBasicResourceLoader.loadTpl();
        context.setDaoBasicTpl(daoBasicTpl);
        context.setNebulaPool(nebulaPool);
        context.setInterfaces(interfaces);
        context.setNebulaPoolConfig(this.nebulaJdbcProperties.getPoolConfig());
        this.figureTagTypeMapping(interfaces.values(), context.getTagTypeMapping());
        this.registerBean(context);
        return context;
    }

    private void figureTagTypeMapping(Collection<ClassModel> classModels, Map<String, Class<?>> tagTypeMapping) {
        for (ClassModel classModel : classModels) {
            Class<?>[] entityTypeAndIdType = NebulaDaoBasicExt.entityTypeAndIdType(classModel.getNamespace());
            if (entityTypeAndIdType == null) continue;
            Class<?> entityType = entityTypeAndIdType[0];
            String vertexName = NebulaDaoBasicExt.vertexName(entityType);
            tagTypeMapping.putIfAbsent(vertexName, entityType);
        }
    }

    private void registerBean(MapperContext context) {
        Map<String, ClassModel> interfaces = context.getInterfaces();
        for (ClassModel cm : interfaces.values()) {
            this.beanFactory.setClassCode(cm);
        }
        RamClassLoader ramClassLoader = new RamClassLoader(context.getInterfaces());
        for (ClassModel cm : interfaces.values()) {
            try {
                String className = cm.getNamespace().getName() + "$Proxy";
                this.registerBean(cm, ramClassLoader.loadClass(className));
                this.log.info("Bean had been registed  (\u4ee3\u7406\u7c7b\u6ce8\u518c\u6210bean): {}", (Object)className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void registerBean(ClassModel cm, Class proxy) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((Class)proxy);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        this.registerBean(this.getBeanName(cm), (BeanDefinition)beanDefinition);
    }

    private void registerBean(String className, BeanDefinition beanDefinition) {
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)this.context.getAutowireCapableBeanFactory();
        beanFactory.registerBeanDefinition(className, beanDefinition);
    }

    private String getBeanName(ClassModel cm) {
        boolean namedByResource;
        Class namespace = cm.getNamespace();
        Component cpnAnno = namespace.getAnnotation(Component.class);
        Resource resAnno = namespace.getAnnotation(Resource.class);
        boolean namedByComponent = cpnAnno != null && StringUtils.isNotBlank((CharSequence)cpnAnno.value());
        boolean bl = namedByResource = resAnno != null && StringUtils.isNotBlank((CharSequence)resAnno.name());
        return namedByResource ? resAnno.name() : (namedByComponent ? cpnAnno.value() + "$Proxy" : namespace.getSimpleName() + "$Proxy");
    }

    public NebulaPool nebulaPool() {
        NebulaPool pool = new NebulaPool();
        try {
            pool.init(this.nebulaJdbcProperties.getHostAddresses(), this.nebulaJdbcProperties.getPoolConfig());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Can not connect to Nebula Graph");
        }
        return pool;
    }

    @Deprecated
    public void setNebulaSessionPool(MapperContext context) {
        MapperProxy.ENV.getDispatcher().setNebulaSessionPool(context);
    }

    @Deprecated
    public SessionPool initSessionPool(String spaceName) {
        return MapperProxy.ENV.getDispatcher().initSessionPool(spaceName);
    }

    public int getOrder() {
        return 100;
    }
}

