/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.base;

import com.vesoft.nebula.client.graph.data.ResultSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nebula.contrib.ngbatis.annotations.DstId;
import org.nebula.contrib.ngbatis.annotations.SrcId;
import org.nebula.contrib.ngbatis.annotations.base.EdgeType;
import org.nebula.contrib.ngbatis.base.GraphBase;
import org.nebula.contrib.ngbatis.base.GraphBaseExt;
import org.nebula.contrib.ngbatis.base.GraphBaseVertex;
import org.nebula.contrib.ngbatis.base.TextTplBuilder;
import org.nebula.contrib.ngbatis.enums.Direction;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;

public abstract class GraphBaseEdge
extends GraphBase {
    public <T extends GraphBaseEdge> List<T> queryEdgeByType(Direction direction) {
        String textTpl = TextTplBuilder.matchEdgeByType(direction);
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("edgeType", this.getEntityTypeName());
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, new HashMap<String, Object>());
        Class<?> entityClass = this.getClass();
        return (List)GraphBaseExt.handleResult(resultSet, List.class, entityClass);
    }

    public <I extends GraphBaseEdge, T extends GraphBaseVertex> List<I> queryEdgeWithSrcAndDstByProperties(T v1Vertex, Direction direction, T v2Vertex) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("edgeType", this.getEntityTypeName());
        args.put("edgeProperties", this.getEntityProperties());
        Map<String, Object> props = this.getEntityProperties();
        if (v1Vertex != null) {
            args.put("v1Tag", GraphBaseExt.getV2Tag(v1Vertex));
            args.put("v1Properties", GraphBaseExt.getV2Property(v1Vertex));
            GraphBaseExt.getV2Property(v1Vertex).forEach((key, value) -> props.put("v1_" + key, value));
        }
        if (v2Vertex != null) {
            args.put("v2Tag", GraphBaseExt.getV2Tag(v2Vertex));
            args.put("v2Properties", GraphBaseExt.getV2Property(v2Vertex));
            GraphBaseExt.getV2Property(v2Vertex).forEach((key, value) -> props.put("v2_" + key, value));
        }
        String textTpl = TextTplBuilder.matchEdgeWithEdgeProperty(direction);
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, props);
        Class<?> entityClass = this.getClass();
        return (List)GraphBaseExt.handleResult(resultSet, List.class, entityClass);
    }

    public <I extends GraphBaseEdge> I queryEdgePropertiesBySrcAndDstId() {
        String textTpl = TextTplBuilder.fetchEdgeProperty(this.getSrcId().get("type"), this.getDstId().get("type"));
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("edgeType", this.getEntityTypeName());
        args.put("srcId", this.getSrcId().get("value"));
        args.put("dstId", this.getDstId().get("value"));
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, new HashMap<String, Object>());
        Class<?> entityClass = this.getClass();
        return (I)((GraphBaseEdge)GraphBaseExt.handleResult(resultSet, entityClass, null));
    }

    public Integer queryEdgeCountByType() {
        String textTpl = TextTplBuilder.lookupEdgeCount();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("tag", this.getEntityTypeName());
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, new HashMap<String, Object>());
        return (Integer)GraphBaseExt.handleResult(resultSet, Integer.class, null);
    }

    @Override
    protected String getEntityTypeName() {
        Class<?> entityClass = this.getClass();
        if (entityClass.isAnnotationPresent(EdgeType.class)) {
            EdgeType edgeTypeAnnotation = entityClass.getAnnotation(EdgeType.class);
            return edgeTypeAnnotation.name();
        }
        throw new RuntimeException("Entity " + entityClass.getName() + " does not have @EdgeType annotation.");
    }

    @Override
    protected Map<String, Object> getEntityProperties() {
        Field[] declaredFields;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Class<?> entityClass = this.getClass();
        for (Field field : declaredFields = entityClass.getDeclaredFields()) {
            Object value = ReflectUtil.getValue(this, field);
            if (value == null || field.getType().isPrimitive() && GraphBaseExt.isPrimitiveDefaultValue(field.getType(), value)) continue;
            properties.put(ReflectUtil.getNameByColumn(field), value);
        }
        return properties;
    }

    private Map<String, Object> getSrcId() {
        Field[] declaredFields;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Class<?> entityClass = this.getClass();
        for (Field field : declaredFields = entityClass.getDeclaredFields()) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = field.getAnnotations()) {
                if (!(annotation instanceof SrcId)) continue;
                result.put("value", ReflectUtil.getValue(this, field));
                result.put("type", field.getType());
            }
        }
        if (result.get("value") == null || GraphBaseExt.isPrimitiveDefaultValue((Class)result.get("type"), result.get("value"))) {
            throw new RuntimeException(entityClass.getSimpleName() + " does not have srcId.");
        }
        return result;
    }

    private Map<String, Object> getDstId() {
        Field[] declaredFields;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Class<?> entityClass = this.getClass();
        for (Field field : declaredFields = entityClass.getDeclaredFields()) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = field.getAnnotations()) {
                if (!(annotation instanceof DstId)) continue;
                result.put("value", ReflectUtil.getValue(this, field));
                result.put("type", field.getType());
            }
        }
        if (result.get("value") == null || GraphBaseExt.isPrimitiveDefaultValue((Class)result.get("type"), result.get("value"))) {
            throw new RuntimeException(entityClass.getSimpleName() + " does not have dstId.");
        }
        return result;
    }
}

