/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.base;

import com.vesoft.nebula.client.graph.data.ResultSet;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Id;
import org.nebula.contrib.ngbatis.ArgsResolver;
import org.nebula.contrib.ngbatis.Env;
import org.nebula.contrib.ngbatis.ResultResolver;
import org.nebula.contrib.ngbatis.SessionDispatcher;
import org.nebula.contrib.ngbatis.annotations.base.EdgeType;
import org.nebula.contrib.ngbatis.annotations.base.Tag;
import org.nebula.contrib.ngbatis.base.GraphBaseVertex;
import org.nebula.contrib.ngbatis.session.SpaceRouter;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphBaseExt {
    public static Env ENV;
    private static Logger log;

    public static ResultSet executeGql(String textTpl, Map<String, Object> m1, Map<String, Object> m2) {
        ResultSet result = null;
        SessionDispatcher dispatcher = ENV.getDispatcher();
        String currentSpace = SpaceRouter.getSpace(m1);
        ArgsResolver argsResolver = ENV.getArgsResolver();
        String gql = ENV.getTextResolver().resolve(textTpl, m1);
        Map<String, Object> parasForDb = argsResolver.resolve(m2);
        HashMap<String, Object> extraReturn = new HashMap<String, Object>();
        try {
            result = dispatcher.executeWithParameter(gql, parasForDb, currentSpace, extraReturn);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                log.debug("\n\t- space: {}\n\t- nGql\uff1a{}\n\t- params: {}\n\t- result\uff1a{}", new Object[]{currentSpace, gql, m2, result});
                throw throwable;
            }
        }
        log.debug("\n\t- space: {}\n\t- nGql\uff1a{}\n\t- params: {}\n\t- result\uff1a{}", new Object[]{currentSpace, gql, m2, result});
        return result;
    }

    public static Object handleResult(ResultSet resultSet, Class returnType, Class resultType) {
        ResultResolver resultResolver = ENV.getResultResolver();
        Object resolve = resultResolver.resolve(resultSet, returnType, resultType);
        return resolve;
    }

    public static String getEdgeType(Class edgeClass) {
        if (edgeClass.isAnnotationPresent(EdgeType.class)) {
            EdgeType anno = edgeClass.getAnnotation(EdgeType.class);
            return anno.name();
        }
        throw new RuntimeException("Entity " + edgeClass.getName() + " does not have @Tag annotation.");
    }

    public static <T extends GraphBaseVertex> String getV2Tag(T v2) {
        Class<?> v2Class = v2.getClass();
        if (v2Class.isAnnotationPresent(Tag.class)) {
            Tag tagAnnotation = v2Class.getAnnotation(Tag.class);
            return tagAnnotation.name();
        }
        throw new RuntimeException("Entity " + v2Class.getName() + " does not have @Tag annotation.");
    }

    public static <T extends GraphBaseVertex> Map<String, Object> getV2Property(T v2) {
        Field[] fields;
        Class<?> v2Class = v2.getClass();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Field field : fields = v2Class.getDeclaredFields()) {
            Object fieldValue = ReflectUtil.getValue(v2, field);
            if (fieldValue == null || field.getType().isPrimitive() && GraphBaseExt.isPrimitiveDefaultValue(field.getType(), fieldValue)) continue;
            if (field.isAnnotationPresent(Id.class)) {
                result.put("id", fieldValue);
                continue;
            }
            result.put(ReflectUtil.getNameByColumn(field), fieldValue);
        }
        return result;
    }

    public static boolean isPrimitiveDefaultValue(Class<?> type, Object value) {
        if (type == Integer.TYPE && (Integer)value == 0) {
            return true;
        }
        if (type == Long.TYPE && (Long)value == 0L) {
            return true;
        }
        if (type == Float.TYPE && ((Float)value).floatValue() == 0.0f) {
            return true;
        }
        if (type == Double.TYPE && (Double)value == 0.0) {
            return true;
        }
        if (type == Byte.TYPE && (Byte)value == 0) {
            return true;
        }
        if (type == Short.TYPE && (Short)value == 0) {
            return true;
        }
        return type == Character.TYPE && ((Character)value).charValue() == '\u0000';
    }

    public static String getEdgeTypes(String sep, Class<?> ... edgeClass) {
        if (edgeClass == null) {
            return "";
        }
        StringBuilder edgeTypeBuilder = new StringBuilder();
        for (Class<?> edgeType : edgeClass) {
            String type = GraphBaseExt.getEdgeType(edgeType);
            edgeTypeBuilder.append(type).append(sep);
        }
        if (edgeTypeBuilder.length() > 0) {
            edgeTypeBuilder.setLength(edgeTypeBuilder.length() - 1);
        }
        return edgeTypeBuilder.toString();
    }

    static {
        log = LoggerFactory.getLogger(GraphBaseExt.class);
    }
}

