/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.base;

import com.vesoft.nebula.client.graph.data.ResultSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Id;
import org.nebula.contrib.ngbatis.annotations.base.Tag;
import org.nebula.contrib.ngbatis.base.GraphBase;
import org.nebula.contrib.ngbatis.base.GraphBaseExt;
import org.nebula.contrib.ngbatis.base.TextTplBuilder;
import org.nebula.contrib.ngbatis.enums.Direction;
import org.nebula.contrib.ngbatis.enums.IdType;
import org.nebula.contrib.ngbatis.models.data.NgEdge;
import org.nebula.contrib.ngbatis.models.data.NgPath;
import org.nebula.contrib.ngbatis.models.data.NgVertex;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;

public abstract class GraphBaseVertex
extends GraphBase {
    public <T> List<T> queryIdsByProperties() {
        String textTpl = TextTplBuilder.matchVertexId();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("tag", this.getEntityTypeName());
        args.put("properties", this.getEntityProperties());
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, this.getEntityProperties());
        IdType vertexIdType = this.getVertexIdType();
        Object res = null;
        if (vertexIdType == IdType.STRING) {
            res = GraphBaseExt.handleResult(resultSet, List.class, String.class);
        } else if (vertexIdType == IdType.INT64) {
            res = GraphBaseExt.handleResult(resultSet, List.class, Number.class);
        }
        if (res == null) {
            throw new RuntimeException("No matching vertex was found.");
        }
        return (List)res;
    }

    public <T extends GraphBaseVertex> T queryVertexById() {
        String textTpl = TextTplBuilder.fetchVertexById(this.getVertexIdType());
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("tag", this.getEntityTypeName());
        args.put("id", this.getVertexId());
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, new HashMap<String, Object>());
        Class<?> entityClass = this.getClass();
        Object o = GraphBaseExt.handleResult(resultSet, entityClass, null);
        return (T)((GraphBaseVertex)o);
    }

    public <T extends GraphBaseVertex> List<T> queryVertexByTag() {
        String textTpl = TextTplBuilder.matchVertexByTag();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("tag", this.getEntityTypeName());
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, new HashMap<String, Object>());
        Class<?> entityClass = this.getClass();
        Object res = GraphBaseExt.handleResult(resultSet, List.class, entityClass);
        return (List)res;
    }

    public <T extends GraphBaseVertex> List<T> queryVertexByProperties() {
        String textTpl = TextTplBuilder.matchVertexSelective();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("tag", this.getEntityTypeName());
        args.put("properties", this.getEntityProperties());
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, this.getEntityProperties());
        Class<?> entityClass = this.getClass();
        Object res = GraphBaseExt.handleResult(resultSet, List.class, entityClass);
        return (List)res;
    }

    public <I> List<NgVertex<I>> queryAllAdjacentVertex(Class<?> ... edgeClass) {
        String textTpl = TextTplBuilder.matchAllAdjacentVertex(GraphBaseExt.getEdgeTypes("|", edgeClass));
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("tag", this.getEntityTypeName());
        args.put("edgeTypes", GraphBaseExt.getEdgeTypes("|", edgeClass));
        args.put("properties", this.getEntityProperties());
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, this.getEntityProperties());
        return (List)GraphBaseExt.handleResult(resultSet, List.class, NgVertex.class);
    }

    public <I> List<NgVertex<I>> queryIncomingAdjacentVertex(Class<?> ... edgeClass) {
        String textTpl = TextTplBuilder.matchIncomingVertex(GraphBaseExt.getEdgeTypes("|", edgeClass));
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("tag", this.getEntityTypeName());
        args.put("edgeTypes", GraphBaseExt.getEdgeTypes("|", edgeClass));
        args.put("properties", this.getEntityProperties());
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, this.getEntityProperties());
        return (List)GraphBaseExt.handleResult(resultSet, List.class, NgVertex.class);
    }

    public <I> List<NgVertex<I>> queryOutgoingAdjacentVertex(Class<?> ... edgeClass) {
        String textTpl = TextTplBuilder.matchOutgoingVertex(GraphBaseExt.getEdgeTypes("|", edgeClass));
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("tag", this.getEntityTypeName());
        args.put("edgeTypes", GraphBaseExt.getEdgeTypes("|", edgeClass));
        args.put("properties", this.getEntityProperties());
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, this.getEntityProperties());
        return (List)GraphBaseExt.handleResult(resultSet, List.class, NgVertex.class);
    }

    public <T> List<T> queryNeighborIdsWithHopById(Integer m, Integer n, Class<?> ... edgeClass) {
        if (m < 0 || n < 0 || m > n) {
            throw new IllegalArgumentException("\u8df3\u6570\u8303\u56f4\u4e0d\u6b63\u786e");
        }
        String textTpl = TextTplBuilder.goAdjacentVertexWithSteps(GraphBaseExt.getEdgeTypes(",", edgeClass), this.getVertexIdType());
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("m", m);
        args.put("n", n);
        args.put("id", this.getVertexId());
        args.put("edgeTypes", GraphBaseExt.getEdgeTypes(",", edgeClass));
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, new HashMap<String, Object>());
        IdType vertexIdType = this.getVertexIdType();
        Object res = null;
        if (vertexIdType == IdType.STRING) {
            res = GraphBaseExt.handleResult(resultSet, List.class, String.class);
        } else if (vertexIdType == IdType.INT64) {
            res = GraphBaseExt.handleResult(resultSet, List.class, Number.class);
        }
        if (res == null) {
            throw new RuntimeException("No matching vertex was found.");
        }
        return (List)res;
    }

    public <T> List<NgEdge<T>> queryConnectedEdgesById(Direction direction, Class<?> ... edgeClass) {
        String textTpl = TextTplBuilder.goAllEdgesFromVertex(GraphBaseExt.getEdgeTypes(",", edgeClass), this.getVertexIdType());
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("id", this.getVertexId());
        args.put("direction", direction.getSymbol());
        args.put("edgeTypes", GraphBaseExt.getEdgeTypes(",", edgeClass));
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, new HashMap<String, Object>());
        return (List)GraphBaseExt.handleResult(resultSet, List.class, NgEdge.class);
    }

    public <T> List<NgPath<T>> queryPathFromVertex(Direction direction) {
        String textTpl = TextTplBuilder.matchPath(direction);
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("tag", this.getEntityTypeName());
        args.put("properties", this.getEntityProperties());
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, this.getEntityProperties());
        return (List)GraphBaseExt.handleResult(resultSet, List.class, NgPath.class);
    }

    public <I> List<NgPath<I>> queryFixedLengthPathFromVertex(Integer maxHop, Direction direction, Class<?> ... edgeClass) {
        if (maxHop != null && maxHop < 0) {
            throw new RuntimeException("maxHop must be greater than or equal to zero");
        }
        String textTpl = TextTplBuilder.matchFixedLengthPath(maxHop, direction, GraphBaseExt.getEdgeTypes("|", edgeClass));
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("tag", this.getEntityTypeName());
        args.put("properties", this.getEntityProperties());
        args.put("edgeTypes", GraphBaseExt.getEdgeTypes("|", edgeClass));
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, this.getEntityProperties());
        return (List)GraphBaseExt.handleResult(resultSet, List.class, NgPath.class);
    }

    public <I> List<NgPath<I>> queryVariableLengthPathFromVertex(Integer minHop, Integer maxHop, Direction direction, Class<?> edgeClass) {
        if (maxHop != null && maxHop < 0) {
            throw new RuntimeException("maxHop must be greater than or equal to zero");
        }
        if (minHop != null && minHop < 0) {
            throw new RuntimeException("minHop must be greater than or equal to zero");
        }
        String textTpl = TextTplBuilder.matchVariableLengthPath(minHop, maxHop, direction, GraphBaseExt.getEdgeTypes("|", edgeClass));
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("tag", this.getEntityTypeName());
        args.put("properties", this.getEntityProperties());
        args.put("edgeTypes", GraphBaseExt.getEdgeTypes("|", edgeClass));
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, this.getEntityProperties());
        return (List)GraphBaseExt.handleResult(resultSet, List.class, NgPath.class);
    }

    public <T extends GraphBaseVertex, I> NgPath<I> queryShortestPathFromSrcAndDst(Integer maxHop, Direction direction, T v2) {
        if (maxHop != null && maxHop < 0) {
            throw new RuntimeException("maxHop must be greater than or equal to zero");
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("srcTag", this.getEntityTypeName());
        args.put("dstTag", GraphBaseExt.getV2Tag(v2));
        args.put("srcProperties", this.getEntityProperties());
        args.put("dstProperties", GraphBaseExt.getV2Property(v2));
        Map<String, Object> props = this.getEntityProperties();
        GraphBaseExt.getV2Property(v2).forEach((key, value) -> props.put("v2_" + key, value));
        String textTpl = TextTplBuilder.matchShortestPaths(maxHop, direction);
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, props);
        return (NgPath)GraphBaseExt.handleResult(resultSet, NgPath.class, null);
    }

    public <T extends GraphBaseVertex, I> List<NgPath<I>> queryAllShortestPathsFromSrcAndDst(Integer maxHop, Direction direction, T v2) {
        if (maxHop != null && maxHop < 0) {
            throw new RuntimeException("maxHop must be greater than or equal to zero");
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("srcTag", this.getEntityTypeName());
        args.put("dstTag", GraphBaseExt.getV2Tag(v2));
        args.put("srcProperties", this.getEntityProperties());
        args.put("dstProperties", GraphBaseExt.getV2Property(v2));
        Map<String, Object> props = this.getEntityProperties();
        GraphBaseExt.getV2Property(v2).forEach((key, value) -> props.put("v2_" + key, value));
        String textTpl = TextTplBuilder.matchAllShortestPaths(maxHop, direction);
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, props);
        return (List)GraphBaseExt.handleResult(resultSet, List.class, NgPath.class);
    }

    public Integer queryVertexCountByTag() {
        String textTpl = TextTplBuilder.lookupVertexCount();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("tag", this.getEntityTypeName());
        ResultSet resultSet = GraphBaseExt.executeGql(textTpl, args, new HashMap<String, Object>());
        return (Integer)GraphBaseExt.handleResult(resultSet, Integer.class, null);
    }

    @Override
    protected String getEntityTypeName() {
        Class<?> entityClass = this.getClass();
        if (entityClass.isAnnotationPresent(Tag.class)) {
            Tag tagAnnotation = entityClass.getAnnotation(Tag.class);
            return tagAnnotation.name();
        }
        throw new RuntimeException("Entity " + entityClass.getName() + " does not have @Tag annotation.");
    }

    @Override
    protected Map<String, Object> getEntityProperties() {
        Field[] declaredFields;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Class<?> entityClass = this.getClass();
        for (Field field : declaredFields = entityClass.getDeclaredFields()) {
            Object value = ReflectUtil.getValue(this, field);
            if (value == null || field.getType().isPrimitive() && GraphBaseExt.isPrimitiveDefaultValue(field.getType(), value)) continue;
            if (field.isAnnotationPresent(Id.class)) {
                properties.put("id", value);
                continue;
            }
            properties.put(ReflectUtil.getNameByColumn(field), value);
        }
        return properties;
    }

    private Object getVertexId() {
        Field[] declaredFields;
        Object id = null;
        Class<?> specificTypeField = null;
        Class<?> entityClass = this.getClass();
        for (Field field : declaredFields = entityClass.getDeclaredFields()) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = field.getAnnotations()) {
                if (!(annotation instanceof Id)) continue;
                id = ReflectUtil.getValue(this, field);
                specificTypeField = field.getType();
            }
        }
        if (id == null || GraphBaseExt.isPrimitiveDefaultValue(specificTypeField, id)) {
            throw new RuntimeException(entityClass.getSimpleName() + " does not have @Id");
        }
        return id;
    }

    private IdType getVertexIdType() {
        Field[] declaredFields;
        Class<?> entityClass = this.getClass();
        for (Field field : declaredFields = entityClass.getDeclaredFields()) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = field.getAnnotations()) {
                if (!(annotation instanceof Id)) continue;
                return field.getType() == String.class ? IdType.STRING : IdType.INT64;
            }
        }
        return IdType.STRING;
    }
}

