/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.binding;

import com.vesoft.nebula.client.graph.data.ResultSet;
import org.nebula.contrib.ngbatis.ResultHandler;
import org.nebula.contrib.ngbatis.ResultResolver;
import org.nebula.contrib.ngbatis.models.MethodModel;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultResultResolver
implements ResultResolver {
    private Logger log = LoggerFactory.getLogger(DefaultResultResolver.class);

    public Object resolve(MethodModel methodModel, ResultSet result) {
        Class returnType = methodModel.getReturnType();
        Class resultType = methodModel.getResultType();
        if (resultType == null) {
            resultType = returnType;
        }
        if (returnType == Void.TYPE) {
            return null;
        }
        ResultHandler<Object, Object> handler = ResultHandler.getHandler(ReflectUtil.sealingBasicType(returnType), ReflectUtil.sealingBasicType(resultType));
        this.log.debug("\u9488\u5bf9java\u8fd4\u56de\u7c7b\u578b {} \u4e0e xml \u8fd4\u56de\u7c7b\u578b {} \u7684\u7ed3\u679c\u96c6\u5904\u7406\u5668\u4e3a\uff1a{}", new Object[]{returnType.getName(), resultType.getName(), handler});
        if (handler == null) {
            return result;
        }
        return handler.handle((Object)returnType, result, resultType);
    }

    public Object resolve(ResultSet result, Class returnType, Class resultType) {
        if (resultType == null) {
            resultType = returnType;
        }
        if (returnType == Void.TYPE) {
            return null;
        }
        ResultHandler<Object, Object> handler = ResultHandler.getHandler(ReflectUtil.sealingBasicType(returnType), ReflectUtil.sealingBasicType(resultType));
        this.log.debug("\u8fd4\u56de\u7c7b\u578b {},\u7ed3\u679c\u96c6\u5904\u7406\u5668\u4e3a\uff1a{}", (Object)returnType.getName(), handler);
        if (handler == null) {
            return result;
        }
        return handler.handle((Object)returnType, result, resultType);
    }
}

