/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.binding;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nebula.contrib.ngbatis.ArgNameFormatter;
import org.nebula.contrib.ngbatis.utils.KeySymbolMap;
import org.springframework.stereotype.Component;

@Component
public class UnderlineArgNameFormatter
implements ArgNameFormatter {
    private static String textFormat(String text, Map<String, Object> obj) {
        Pattern compile = Pattern.compile("\\{\\s{0,}\\w{0,}.\\w{0,}\\s{0,}\\}");
        Matcher matcher = compile.matcher(text);
        HashMap<String, Integer> elCount = new HashMap<String, Integer>();
        while (matcher.find()) {
            String target = matcher.group();
            String key = target.split("\\.")[0].replace("{", "").trim();
            if (obj.get(key) instanceof Collection) {
                String countKey = target.replaceAll("\\s{0,}", "");
                Integer integer = (Integer)elCount.get(countKey);
                if (integer == null) {
                    integer = 0;
                }
                text = text.replaceFirst(UnderlineArgNameFormatter.replaceRegExpSymbol(target), target.replaceAll("\\.", "_" + integer + "_"));
                elCount.put(countKey, integer + 1);
                continue;
            }
            text = text.replaceFirst(UnderlineArgNameFormatter.replaceRegExpSymbol(target), target.replaceAll("\\.", "_"));
        }
        return text;
    }

    public static String replaceRegExpSymbol(String text) {
        return text.replace("{", "\\{").replace("}", "\\}");
    }

    @Override
    public ArgNameFormatter.CqlAndArgs format(String oldText, Map<String, Object> obj) {
        String newText = UnderlineArgNameFormatter.textFormat(oldText, obj);
        return new ArgNameFormatter.CqlAndArgs(newText, this.argObjRename(obj));
    }

    public Map<String, Object> argObjRename(Map<String, Object> obj) {
        return new KeySymbolMap(obj, "_").getOneDMap();
    }
}

