/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.binding.beetl.functions;

import java.lang.reflect.Field;
import org.nebula.contrib.ngbatis.PkGenerator;
import org.nebula.contrib.ngbatis.binding.beetl.functions.AbstractFunction;
import org.nebula.contrib.ngbatis.proxy.MapperProxy;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class IdFn
extends AbstractFunction<Object, Boolean, Boolean, Void, Void, Void> {
    private static Logger log = LoggerFactory.getLogger(IdFn.class);

    @Override
    public Object call(Object entity, Boolean canNotNull, Boolean autoGenerate) {
        Assert.notNull((Object)entity, (String)"param can not be null");
        Class<?> entityType = entity.getClass();
        if (ReflectUtil.isBasicType(entityType)) {
            return this.fnCall(this.valueFmtFn, entity);
        }
        canNotNull = canNotNull == null;
        autoGenerate = autoGenerate == null;
        Field pkField = ReflectUtil.getPkField(entityType, canNotNull);
        String tagName = (String)this.fnCall(this.tagNameFn, entity);
        return autoGenerate != false ? this.setId(entity, pkField, tagName) : ReflectUtil.getValue(entity, pkField);
    }

    public Object setId(Object record, Field pkField, String tagName) {
        try {
            PkGenerator pkGenerator = MapperProxy.ENV.getPkGenerator();
            Object id = null;
            if (pkField != null && (id = ReflectUtil.getValue(record, pkField)) == null && pkGenerator != null) {
                id = pkGenerator.generate(tagName, pkField.getType());
                ReflectUtil.setValue(record, pkField, id);
            }
            return this.fnCall(this.valueFmtFn, id);
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage());
            return null;
        }
    }
}

