/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="cql.parser")
public class ParseCfgProps {
    private String mapperTplLocation = "NebulaDaoBasic.xml";
    private String[] mapperLocations = new String[]{"mapper/**/*.xml"};
    private String id = "id";
    private String namespace = "namespace";
    private String space = "space";
    private String spaceFromParam = "spaceFromParam";
    private String resultType = "resultType";
    private String parameterType = "parameterType";
    private String mapper = "mapper";
    private String statementStart = "@";
    private String statementEnd = null;
    private String logShow = "xml-load,env-init,query";
    private Set<String> logShowTypes = null;
    private boolean resourceRefresh = false;

    public String getMapperTplLocation() {
        return this.mapperTplLocation;
    }

    public ParseCfgProps setMapperTplLocation(String mapperTplLocation) {
        if (StringUtils.isBlank((CharSequence)mapperTplLocation)) {
            return this;
        }
        this.mapperTplLocation = mapperTplLocation;
        return this;
    }

    public String[] getMapperLocations() {
        return this.mapperLocations;
    }

    public ParseCfgProps setMapperLocations(String[] mapperLocations) {
        if (ObjectUtils.isEmpty((Object)mapperLocations)) {
            return this;
        }
        this.mapperLocations = mapperLocations;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public ParseCfgProps setId(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return this;
        }
        this.id = id;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ParseCfgProps setNamespace(String namespace) {
        if (StringUtils.isBlank((CharSequence)namespace)) {
            return this;
        }
        this.namespace = namespace;
        return this;
    }

    public String getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public String getSpaceFromParam() {
        return this.spaceFromParam;
    }

    public ParseCfgProps setSpaceFromParam(String spaceFromParam) {
        this.spaceFromParam = spaceFromParam;
        return this;
    }

    public String getResultType() {
        return this.resultType;
    }

    public ParseCfgProps setResultType(String resultType) {
        if (StringUtils.isBlank((CharSequence)resultType)) {
            return this;
        }
        this.resultType = resultType;
        return this;
    }

    public String getParameterType() {
        return this.parameterType;
    }

    public ParseCfgProps setParameterType(String parameterType) {
        if (StringUtils.isBlank((CharSequence)parameterType)) {
            return this;
        }
        this.parameterType = parameterType;
        return this;
    }

    public String getMapper() {
        return this.mapper;
    }

    public ParseCfgProps setMapper(String mapper) {
        if (StringUtils.isBlank((CharSequence)mapper)) {
            return this;
        }
        this.mapper = mapper;
        return this;
    }

    public String getStatementStart() {
        return this.statementStart;
    }

    public ParseCfgProps setStatementStart(String statementStart) {
        if (StringUtils.isBlank((CharSequence)statementStart)) {
            return this;
        }
        this.statementStart = statementStart;
        return this;
    }

    public String getStatementEnd() {
        return this.statementEnd;
    }

    public ParseCfgProps setStatementEnd(String statementEnd) {
        if (StringUtils.isBlank((CharSequence)statementEnd)) {
            return this;
        }
        this.statementEnd = statementEnd;
        return this;
    }

    public String getLogShow() {
        return this.logShow;
    }

    public ParseCfgProps setLogShow(String logShow) {
        if (StringUtils.isBlank((CharSequence)logShow)) {
            return this;
        }
        this.logShow = logShow;
        this.logShowTypes = new HashSet<String>(Arrays.asList(logShow.split(",")));
        return this;
    }

    public Set<String> getLogShowTypes() {
        return this.logShowTypes;
    }

    public ParseCfgProps setLogShowTypes(Set<String> logShowTypes) {
        if (ObjectUtils.isEmpty(logShowTypes)) {
            return this;
        }
        this.logShowTypes = logShowTypes;
        return this;
    }

    public boolean isResourceRefresh() {
        return this.resourceRefresh;
    }

    public ParseCfgProps setResourceRefresh(Boolean resourceRefresh) {
        if (resourceRefresh == null) {
            return this;
        }
        this.resourceRefresh = resourceRefresh;
        return this;
    }
}

