/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.handler;

import com.vesoft.nebula.client.graph.data.PathWrapper;
import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import java.io.UnsupportedEncodingException;
import javax.annotation.Resource;
import org.nebula.contrib.ngbatis.handler.AbstractResultHandler;
import org.nebula.contrib.ngbatis.handler.NgVertexResultHandler;
import org.nebula.contrib.ngbatis.models.data.NgPath;
import org.nebula.contrib.ngbatis.utils.ResultSetUtil;
import org.springframework.stereotype.Component;

@Component
public class NgPathResultHandler
extends AbstractResultHandler<NgPath<?>, NgPath<?>> {
    @Resource
    private NgVertexResultHandler ngVertexResultHandler;

    @Override
    public NgPath<?> handle(NgPath<?> newResult, ResultSet result, Class resultType) throws NoSuchFieldException, IllegalAccessException, InstantiationException {
        ResultSet.Record record = result.rowValues(0);
        return this.handle(newResult, record);
    }

    public NgPath<?> handle(NgPath<?> newResult, ResultSet.Record record) {
        PathWrapper pathWrapper = (PathWrapper)ResultSetUtil.getValue((ValueWrapper)record.values().get(0));
        pathWrapper.getSegments().forEach(segment -> {
            try {
                NgPath.Relationship ngRelationship = new NgPath.Relationship();
                long ranking = segment.getRelationShip().ranking();
                Object srcId = ResultSetUtil.getValue(segment.getStartNode().getId());
                Object dstId = ResultSetUtil.getValue(segment.getEndNode().getId());
                String edgeName = segment.getRelationShip().edgeName();
                ngRelationship.setRank(ranking);
                ngRelationship.setSrcID(srcId);
                ngRelationship.setDstID(dstId);
                ngRelationship.setEdgeName(edgeName);
                ngRelationship.setProperties(ResultSetUtil.edgePropsToMap(segment.getRelationShip()));
                this.ngVertexResultHandler.handle(ngRelationship.getDst(), segment.getEndNode());
                this.ngVertexResultHandler.handle(ngRelationship.getSrc(), segment.getStartNode());
                newResult.getRelationships().add(ngRelationship);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        });
        return newResult;
    }
}

