/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.handler;

import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import java.util.ArrayList;
import java.util.List;
import org.nebula.contrib.ngbatis.handler.AbstractResultHandler;
import org.nebula.contrib.ngbatis.handler.NgEdgeResultHandler;
import org.nebula.contrib.ngbatis.handler.NgVertexResultHandler;
import org.nebula.contrib.ngbatis.models.data.NgEdge;
import org.nebula.contrib.ngbatis.models.data.NgSubgraph;
import org.nebula.contrib.ngbatis.models.data.NgVertex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NgSubgraphResultHandler
extends AbstractResultHandler<NgSubgraph<?>, NgSubgraph<?>> {
    @Autowired
    private NgEdgeResultHandler edgeResultHandler;
    @Autowired
    private NgVertexResultHandler vertexResultHandler;

    @Override
    public NgSubgraph<?> handle(NgSubgraph<?> newResult, ResultSet result, Class resultType) throws NoSuchFieldException, IllegalAccessException, InstantiationException {
        ResultSet.Record row = result.rowValues(0);
        return this.handle(newResult, row);
    }

    public NgSubgraph<?> handle(NgSubgraph<?> newResult, ResultSet.Record row) {
        ValueWrapper relationships;
        ValueWrapper nodes = row.get("nodes");
        if (nodes != null) {
            List<ValueWrapper> nodesValueWrapper = this.getCollection(nodes);
            nodesValueWrapper.forEach(nodeValueWrapper -> {
                List vertexes = newResult.getVertexes();
                NgVertex<Object> vertex = new NgVertex();
                vertex = this.vertexResultHandler.handle((NgVertex<?>)vertex, (ValueWrapper)nodeValueWrapper);
                vertexes.add(vertex);
            });
        }
        if ((relationships = row.get("relationships")) != null) {
            List<ValueWrapper> edgesValueWrapper = this.getCollection(relationships);
            edgesValueWrapper.forEach(edgeValueWrapper -> {
                List edges = newResult.getEdges();
                NgEdge<Object> edge = new NgEdge();
                edge = this.edgeResultHandler.handle((NgEdge<?>)edge, (ValueWrapper)edgeValueWrapper);
                edges.add(edge);
            });
        }
        return newResult;
    }

    private List<ValueWrapper> getCollection(ValueWrapper listOrSetWrapper) {
        return listOrSetWrapper.isList() ? listOrSetWrapper.asList() : new ArrayList(listOrSetWrapper.asSet());
    }
}

