/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.handler;

import com.vesoft.nebula.client.graph.data.Node;
import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.nebula.contrib.ngbatis.exception.ResultHandleException;
import org.nebula.contrib.ngbatis.handler.AbstractResultHandler;
import org.nebula.contrib.ngbatis.models.data.NgVertex;
import org.nebula.contrib.ngbatis.utils.ResultSetUtil;
import org.springframework.stereotype.Component;

@Component
public class NgVertexResultHandler
extends AbstractResultHandler<NgVertex<?>, NgVertex<?>> {
    @Override
    public NgVertex<?> handle(NgVertex<?> newResult, ResultSet result, Class resultType) throws NoSuchFieldException, IllegalAccessException, InstantiationException {
        ResultSet.Record row = result.rowValues(0);
        return this.handle(newResult, row);
    }

    public NgVertex<?> handle(NgVertex<?> newResult, ResultSet.Record row) {
        ValueWrapper node = row.get(0);
        this.handle(newResult, node);
        return newResult;
    }

    public NgVertex<?> handle(NgVertex<?> newResult, ValueWrapper nodeValueWrapper) {
        try {
            return this.handle(newResult, nodeValueWrapper.asNode());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public NgVertex<?> handle(NgVertex<?> newResult, Node node) {
        try {
            ValueWrapper id = node.getId();
            newResult.setVid(ResultSetUtil.getValue(id));
            List tags = node.tagNames();
            newResult.setTags(tags);
            newResult.setProperties(ResultSetUtil.nodePropsToMap(node));
            return newResult;
        }
        catch (UnsupportedEncodingException e) {
            throw new ResultHandleException(String.format("%s : %s", e.getClass().toString(), e.getMessage()));
        }
    }
}

