/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.handler;

import com.vesoft.nebula.client.graph.data.Node;
import com.vesoft.nebula.client.graph.data.Relationship;
import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import java.util.List;
import org.nebula.contrib.ngbatis.handler.AbstractResultHandler;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;
import org.nebula.contrib.ngbatis.utils.ResultSetUtil;
import org.springframework.stereotype.Component;

@Component
public class ObjectResultHandler
extends AbstractResultHandler<Object, Object> {
    @Override
    public Object handle(Object newResult, ResultSet result, Class resultType) throws NoSuchFieldException, IllegalAccessException {
        if (result.rowsSize() == 0) {
            return null;
        }
        List columnNames = result.getColumnNames();
        ResultSet.Record record = result.rowValues(0);
        return this.handle(newResult, record, columnNames, resultType);
    }

    public Object handle(Object newResult, ResultSet.Record record, List<String> columnNames, Class<?> resultType) throws NoSuchFieldException, IllegalAccessException {
        for (int i = 0; i < columnNames.size(); ++i) {
            ValueWrapper valueWrapper = (ValueWrapper)record.values().get(i);
            Object v = ResultSetUtil.getValue(valueWrapper, resultType);
            newResult = this.fillResult(v, newResult, columnNames, resultType, i);
        }
        return newResult;
    }

    private Object fillResult(Object v, Object newResult, List<String> columnNames, Class resultType, int i) throws NoSuchFieldException, IllegalAccessException {
        String columnName = columnNames.get(i);
        if (this.valIsResultType(v, resultType)) {
            newResult = v;
        } else if (v instanceof Node) {
            newResult = this.fillResultByNode((Node)v, newResult, columnNames, resultType, columnName);
        } else if (v instanceof Relationship) {
            newResult = this.fillResultByRelationship((Relationship)v, newResult, columnNames, resultType, columnName);
        } else {
            ReflectUtil.setValue(newResult, columnName, v);
        }
        return newResult;
    }

    private boolean valIsResultType(Object v, Class resultType) {
        return v != null && ReflectUtil.isCurrentTypeOrParentType(v.getClass(), resultType);
    }

    private Object fillResultByNode(Node node, Object newResult, List<String> columnNames, Class resultType, String columnName) {
        if (columnNames.size() == 1) {
            newResult = ResultSetUtil.nodeToResultType(node, resultType);
        } else {
            ResultSetUtil.nodeToResultType(newResult, columnName, node);
        }
        return newResult;
    }

    private Object fillResultByRelationship(Relationship relationship, Object newResult, List<String> columnNames, Class resultType, String columnName) {
        if (columnNames.size() == 1) {
            newResult = ResultSetUtil.relationshipToResultType(relationship, resultType);
        } else {
            ResultSetUtil.relationshipToResultType(newResult, columnName, relationship);
        }
        return newResult;
    }
}

