/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.nebula.contrib.ngbatis.annotations.TimeLog;
import org.nebula.contrib.ngbatis.config.ParseCfgProps;
import org.nebula.contrib.ngbatis.exception.ParseException;
import org.nebula.contrib.ngbatis.exception.ResourceLoadException;
import org.nebula.contrib.ngbatis.models.ClassModel;
import org.nebula.contrib.ngbatis.models.MethodModel;
import org.nebula.contrib.ngbatis.models.NgqlModel;
import org.nebula.contrib.ngbatis.session.SpaceRouter;
import org.nebula.contrib.ngbatis.utils.Page;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.data.repository.query.Param;
import org.springframework.util.Assert;

public class MapperResourceLoader
extends PathMatchingResourcePatternResolver {
    private static Logger log = LoggerFactory.getLogger(MapperResourceLoader.class);
    protected ParseCfgProps parseConfig;
    protected ApplicationContext applicationContext;

    private MapperResourceLoader() {
    }

    public MapperResourceLoader(ParseCfgProps parseConfig) {
        this.parseConfig = parseConfig;
    }

    public MapperResourceLoader(ParseCfgProps parseConfig, ApplicationContext applicationContext) {
        this.parseConfig = parseConfig;
        this.applicationContext = applicationContext;
    }

    @TimeLog(name="xml-load", explain="mappers xml load completed : {} ms")
    public Map<String, ClassModel> load() {
        HashMap<String, ClassModel> resultClassModel = new HashMap<String, ClassModel>();
        Object[] mapperLocations = this.parseConfig.getMapperLocations();
        try {
            for (Object mapperLocation : mapperLocations) {
                Resource[] resources;
                for (Resource resource : resources = this.getResources((String)mapperLocation)) {
                    resultClassModel.putAll(this.parseClassModel(resource));
                }
            }
        }
        catch (FileNotFoundException ffe) {
            log.warn("No mapper files were found in path pattern '{}', please add", mapperLocations);
        }
        catch (IOException | NoSuchMethodException e) {
            throw new ResourceLoadException(e);
        }
        return resultClassModel;
    }

    public Map<String, ClassModel> parseClassModel(Resource resource) throws IOException, NoSuchMethodException {
        HashMap<String, ClassModel> result = new HashMap<String, ClassModel>();
        Document doc = Jsoup.parse((InputStream)resource.getInputStream(), (String)"UTF-8", (String)"http://example.com/");
        Elements elementsByTag = doc.getElementsByTag(this.parseConfig.getMapper());
        for (Element element : elementsByTag) {
            ClassModel cm = new ClassModel();
            cm.setResource(resource);
            this.match(cm, (Node)element, "namespace", this.parseConfig.getNamespace());
            this.match(cm, (Node)element, "space", this.parseConfig.getSpace());
            SpaceRouter.setClassSpace(cm, this.applicationContext);
            List nodes = element.childNodes();
            Map<String, MethodModel> methods = this.parseMethodModel(cm, nodes);
            cm.setMethods(methods);
            result.put(cm.getNamespace().getName() + "$Proxy", cm);
        }
        return result;
    }

    private Map<String, MethodModel> parseMethodModel(ClassModel cm, List<Node> nodes) throws NoSuchMethodException {
        Class namespace = cm.getNamespace();
        HashMap<String, MethodModel> methods = new HashMap<String, MethodModel>();
        List<String> methodNames = this.getMethodNames(nodes);
        for (Node methodNode : nodes) {
            if (!(methodNode instanceof Element)) continue;
            if (((Element)methodNode).tagName().equalsIgnoreCase("nGQL")) {
                if (Objects.isNull(cm.getNgqls())) {
                    cm.setNgqls(new HashMap<String, NgqlModel>());
                }
                NgqlModel ngqlModel = this.parseNgqlModel((Element)methodNode);
                cm.getNgqls().put(ngqlModel.getId(), ngqlModel);
                continue;
            }
            MethodModel methodModel = this.parseMethodModel(methodNode);
            SpaceRouter.setMethodSpace(methodModel, this.applicationContext);
            Method method = ReflectUtil.getNameUniqueMethod(namespace, methodModel.getId());
            methodModel.setMethod(method);
            Assert.notNull((Object)method, (String)("\u63a5\u53e3 " + namespace.getName() + " \u4e2d\uff0c\u672a\u58f0\u660e xml \u4e2d\u7684\u51fa\u73b0\u7684\u65b9\u6cd5\uff1a" + methodModel.getId()));
            this.checkReturnType(method, namespace);
            this.pageSupport(method, methodModel, methodNames, methods, namespace);
            methods.put(methodModel.getId(), methodModel);
        }
        return methods;
    }

    protected MethodModel parseMethodModel(Node node) {
        MethodModel model = new MethodModel();
        this.match(model, node, "id", this.parseConfig.getId());
        this.match(model, node, "parameterType", this.parseConfig.getParameterType());
        this.match(model, node, "resultType", this.parseConfig.getResultType());
        this.match(model, node, "space", this.parseConfig.getSpace());
        this.match(model, node, "spaceFromParam", this.parseConfig.getSpaceFromParam());
        List nodes = node.childNodes();
        model.setText(this.nodesToString(nodes));
        return model;
    }

    protected NgqlModel parseNgqlModel(Element ngqlEl) {
        return new NgqlModel(ngqlEl.id(), ngqlEl.text());
    }

    private void checkReturnType(Method method, Class namespace) {
        Class<?> returnType = method.getReturnType();
        if (ReflectUtil.NEED_SEALING_TYPES.contains(returnType)) {
            throw new ResourceLoadException("\u76ee\u524d\u4e0d\u652f\u6301\u8fd4\u56de\u57fa\u672c\u7c7b\u578b\uff0c\u8bf7\u4f7f\u7528\u5bf9\u5e94\u7684\u5305\u88c5\u7c7b\uff0c\u63a5\u53e3\uff1a" + namespace.getName() + "." + method.getName());
        }
    }

    private void pageSupport(Method method, MethodModel methodModel, List<String> methodNames, Map<String, MethodModel> methods, Class<?> namespace) throws NoSuchMethodException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        List<Class<?>> parameterTypeList = Arrays.asList(parameterTypes);
        if (parameterTypeList.contains(Page.class)) {
            int pageParamIndex = parameterTypeList.indexOf(Page.class);
            MethodModel pageMethod = this.createPageMethod(methodModel, methodNames, parameterTypes, pageParamIndex, namespace);
            methods.put(pageMethod.getId(), pageMethod);
            MethodModel countMethod = this.createCountMethod(methodModel, methodNames, parameterTypes, namespace);
            methods.put(countMethod.getId(), countMethod);
        }
    }

    private MethodModel createCountMethod(MethodModel methodModel, List<String> methodNames, Class<?>[] parameterTypes, Class<?> namespace) throws NoSuchMethodException {
        String methodName = methodModel.getId();
        String countMethodName = String.format("%s$Count", methodName);
        Assert.isTrue((!methodNames.contains(countMethodName) ? 1 : 0) != 0, (String)("There is a method name conflicts with " + countMethodName));
        MethodModel countMethodModel = new MethodModel();
        MapperResourceLoader.setParamAnnotations(parameterTypes, namespace, methodName, countMethodModel);
        countMethodModel.setParameterTypes(parameterTypes);
        countMethodModel.setId(countMethodName);
        countMethodModel.setSpaceFromParam(methodModel.isSpaceFromParam());
        countMethodModel.setSpace(methodModel.getSpace());
        String cql = methodModel.getText();
        String with = cql.replaceAll("(RETURN)|(return)", "WITH");
        cql = String.format("%s\t\tRETURN count(*);", with);
        countMethodModel.setText(cql);
        countMethodModel.setReturnType(Long.class);
        return countMethodModel;
    }

    private MethodModel createPageMethod(MethodModel methodModel, List<String> methodNames, Class<?>[] parameterTypes, int pageParamIndex, Class<?> namespace) throws NoSuchMethodException {
        String methodName = methodModel.getId();
        String pageMethodName = String.format("%s$Page", methodName);
        Assert.isTrue((!methodNames.contains(pageMethodName) ? 1 : 0) != 0, (String)("There is a method name conflicts with " + pageMethodName));
        MethodModel pageMethodModel = new MethodModel();
        Annotation[][] parameterAnnotations = MapperResourceLoader.setParamAnnotations(parameterTypes, namespace, methodName, pageMethodModel);
        pageMethodModel.setParameterTypes(parameterTypes);
        pageMethodModel.setId(pageMethodName);
        pageMethodModel.setSpaceFromParam(methodModel.isSpaceFromParam());
        pageMethodModel.setSpace(methodModel.getSpace());
        String cql = methodModel.getText();
        String pageParamName = this.getPageParamName(parameterAnnotations, pageParamIndex);
        if (pageParamName != null) {
            String format = "%s\t\tSKIP $%s.startRow LIMIT $%s.pageSize";
            cql = String.format(format, cql, pageParamName, pageParamName);
        } else {
            String format = "%s\t\tSKIP $startRow LIMIT $pageSize";
            cql = String.format(format, cql);
        }
        pageMethodModel.setText(cql);
        pageMethodModel.setResultType(methodModel.getResultType());
        pageMethodModel.setReturnType(methodModel.getMethod().getReturnType());
        return pageMethodModel;
    }

    private static Annotation[][] setParamAnnotations(Class<?>[] parameterTypes, Class<?> namespace, String methodName, MethodModel methodModel) throws NoSuchMethodException {
        Method declaredMethod = namespace.getDeclaredMethod(methodName, parameterTypes);
        Annotation[][] parameterAnnotations = declaredMethod.getParameterAnnotations();
        methodModel.setParamAnnotations(parameterAnnotations);
        return parameterAnnotations;
    }

    private String getPageParamName(Annotation[][] parameterAnnotations, int pageParamIndex) {
        if (parameterAnnotations.length > pageParamIndex) {
            Annotation[] parameterAnnotation = parameterAnnotations[pageParamIndex];
            for (int i = 0; i < parameterAnnotation.length; ++i) {
                Param param;
                String paramName;
                Annotation ifParam = parameterAnnotation[i];
                if (ifParam.annotationType() != Param.class || !StringUtils.isNotBlank((CharSequence)(paramName = (param = (Param)ifParam).value()))) continue;
                return paramName;
            }
        }
        if (parameterAnnotations.length > 1) {
            return "p" + pageParamIndex;
        }
        return null;
    }

    private List<String> getMethodNames(List<Node> nodes) {
        return nodes.stream().map(node -> {
            if (node instanceof Element) {
                return ((Element)node).id();
            }
            return null;
        }).collect(Collectors.toList());
    }

    protected String nodesToString(List<? extends Node> nodes) {
        StringBuilder builder = new StringBuilder();
        for (Node node : nodes) {
            if (!(node instanceof TextNode)) continue;
            builder.append(((TextNode)node).getWholeText());
            builder.append("\n");
        }
        String mapperText = builder.toString();
        String string = Entities.unescape((String)mapperText);
        return string;
    }

    private void match(Object model, Node node, String javaAttr, String attr) {
        String attrTemp = null;
        try {
            String attrText = node.attr(attr);
            if (StringUtils.isBlank((CharSequence)attrText)) {
                return;
            }
            attrTemp = attrText;
            Field field = model.getClass().getDeclaredField(javaAttr);
            Class<?> type = field.getType();
            Object value = this.castValue(attrText, type);
            ReflectUtil.setValue(model, field, value);
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("\u7c7b\u578b " + attrTemp + " \u672a\u627e\u5230");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Object castValue(String attrText, Class<?> type) throws ClassNotFoundException {
        if (type == Class.class) {
            return Class.forName(attrText);
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.valueOf(attrText);
        }
        return attrText;
    }
}

