/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.session;

import com.vesoft.nebula.client.graph.NebulaPoolConfig;
import com.vesoft.nebula.client.graph.SessionPool;
import com.vesoft.nebula.client.graph.SessionPoolConfig;
import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.exception.BindSpaceFailedException;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.Session;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.nebula.contrib.ngbatis.SessionDispatcher;
import org.nebula.contrib.ngbatis.config.EnvConfig;
import org.nebula.contrib.ngbatis.config.NebulaJdbcProperties;
import org.nebula.contrib.ngbatis.config.NgbatisConfig;
import org.nebula.contrib.ngbatis.exception.QueryException;
import org.nebula.contrib.ngbatis.models.MapperContext;
import org.nebula.contrib.ngbatis.proxy.MapperProxy;
import org.nebula.contrib.ngbatis.session.LocalSession;
import org.nebula.contrib.ngbatis.utils.ResultSetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class IntervalCheckSessionDispatcher
implements Runnable,
SessionDispatcher {
    public static long SESSION_LIFE_LENGTH = 18000000L;
    public static long CHECK_FIXED_RATE = 18000000L;
    private static Logger log = LoggerFactory.getLogger(IntervalCheckSessionDispatcher.class);
    private final NebulaPoolConfig nebulaPoolConfig;
    private final ArrayBlockingQueue<LocalSession> sessionQueue;
    private final ScheduledExecutorService threadPool;
    private final NebulaJdbcProperties nebulaJdbcProperties;

    public IntervalCheckSessionDispatcher(NebulaJdbcProperties properties) {
        this.nebulaJdbcProperties = properties;
        this.nebulaPoolConfig = properties.getPoolConfig();
        this.sessionQueue = new ArrayBlockingQueue(this.nebulaPoolConfig.getMaxConnSize());
        this.threadPool = EnvConfig.reconnect ? Executors.newScheduledThreadPool(1) : null;
        NgbatisConfig ngbatis = properties.getNgbatis();
        if (ngbatis != null) {
            SESSION_LIFE_LENGTH = ngbatis.getSessionLifeLength() == null ? SESSION_LIFE_LENGTH : ngbatis.getSessionLifeLength();
            CHECK_FIXED_RATE = ngbatis.getCheckFixedRate() == null ? CHECK_FIXED_RATE : ngbatis.getCheckFixedRate();
        }
        this.setNebulaSessionPool(MapperContext.newInstance());
        this.wakeUp();
    }

    @Override
    public synchronized void run() {
        for (LocalSession session : this.sessionQueue) {
            log.info("LocalSession in queue which created at {}, useCount: {}", (Object)session.getBirth(), (Object)session.useCount);
            boolean finished = this.timeToRelease(session);
            if (!finished && session.getSession().ping()) continue;
            this.release(session);
        }
        while (this.sessionQueue.size() < this.nebulaPoolConfig.getMinConnSize()) {
            this.offer();
        }
    }

    @Override
    public void offer(LocalSession session) {
        boolean offer = this.sessionQueue.offer(session);
        if (!offer) {
            this.releaseInnerSession(session);
        }
    }

    private void offer() {
        LocalSession localSession = this.newLocalSession();
        this.offer(localSession);
    }

    @Override
    public synchronized LocalSession poll() {
        LocalSession localSession = null;
        if (!EnvConfig.reconnect) {
            localSession = this.newLocalSession();
            ++localSession.useCount;
            return localSession;
        }
        try {
            localSession = this.sessionQueue.poll(this.nebulaPoolConfig.getWaitTime(), TimeUnit.MILLISECONDS);
            localSession = localSession == null ? this.newLocalSession() : localSession;
            ++localSession.useCount;
            return localSession;
        }
        catch (InterruptedException e) {
            return this.newLocalSession();
        }
    }

    private void wakeUp() {
        if (this.threadPool != null) {
            this.threadPool.scheduleAtFixedRate(this, 3L, CHECK_FIXED_RATE, TimeUnit.MILLISECONDS);
        }
    }

    private LocalSession newLocalSession() {
        return new LocalSession(System.currentTimeMillis(), MapperProxy.ENV.openSession());
    }

    private void releaseInnerSession(LocalSession session) {
        session.getSession().release();
    }

    @Override
    public void release(LocalSession session) {
        session.getSession().release();
        log.info("Release a session which created at {}", (Object)session.getBirth());
        this.sessionQueue.remove(session);
    }

    @Override
    public void releaseAll() {
        while (this.sessionQueue.size() > 0) {
            LocalSession poll = this.sessionQueue.poll();
            this.release(poll);
        }
        if (SessionDispatcher.useSessionPool()) {
            MapperContext.newInstance().getNebulaSessionPoolMap().forEach((k, v) -> v.close());
        }
    }

    @Override
    public boolean timeToRelease(LocalSession session) {
        long birth = session.getBirth();
        return System.currentTimeMillis() - birth > SESSION_LIFE_LENGTH;
    }

    @Override
    public void setNebulaSessionPool(MapperContext context) {
        NgbatisConfig ngbatisConfig = this.nebulaJdbcProperties.getNgbatis();
        if (ngbatisConfig.getUseSessionPool() == null || !ngbatisConfig.getUseSessionPool().booleanValue()) {
            return;
        }
        context.getSpaceNameSet().add(this.nebulaJdbcProperties.getSpace());
        Map<String, SessionPool> nebulaSessionPoolMap = context.getNebulaSessionPoolMap();
        for (String spaceName : context.getSpaceNameSet()) {
            SessionPool sessionPool = this.initSessionPool(spaceName);
            if (sessionPool == null) {
                log.error("{} session pool init failed.", (Object)spaceName);
                continue;
            }
            log.info("session pool for `{}` init success.", (Object)spaceName);
            nebulaSessionPoolMap.put(spaceName, sessionPool);
        }
    }

    @Override
    public SessionPool initSessionPool(String spaceName) {
        NgbatisConfig ngbatisConfig = this.nebulaJdbcProperties.getNgbatis();
        NebulaPoolConfig poolConfig = this.nebulaJdbcProperties.getPoolConfig();
        SessionPoolConfig sessionPoolConfig = new SessionPoolConfig(this.nebulaJdbcProperties.getHostAddresses(), spaceName, this.nebulaJdbcProperties.getUsername(), this.nebulaJdbcProperties.getPassword()).setUseHttp2(poolConfig.isUseHttp2()).setEnableSsl(poolConfig.isEnableSsl()).setSslParam(poolConfig.getSslParam()).setCustomHeaders(poolConfig.getCustomHeaders()).setWaitTime(poolConfig.getWaitTime()).setTimeout(poolConfig.getTimeout());
        if (poolConfig.getMinConnSize() <= 0) {
            sessionPoolConfig.setMinSessionSize(1);
        } else {
            sessionPoolConfig.setMinSessionSize(poolConfig.getMinConnSize());
        }
        sessionPoolConfig.setMaxSessionSize(poolConfig.getMaxConnSize());
        sessionPoolConfig.setTimeout(poolConfig.getTimeout());
        sessionPoolConfig.setWaitTime(poolConfig.getWaitTime());
        if (null != ngbatisConfig.getSessionLifeLength()) {
            int cleanTime = (int)(ngbatisConfig.getSessionLifeLength() / 1000L);
            sessionPoolConfig.setCleanTime(cleanTime);
        }
        if (null != ngbatisConfig.getCheckFixedRate()) {
            int healthCheckTime = (int)(ngbatisConfig.getCheckFixedRate() / 1000L);
            sessionPoolConfig.setHealthCheckTime(healthCheckTime);
        }
        return new SessionPool(sessionPoolConfig);
    }

    @Override
    public void handleSession(LocalSession localSession, ResultSet result) {
        if (localSession != null) {
            boolean sessionError = ResultSetUtil.isSessionError(result);
            if (sessionError || this.timeToRelease(localSession)) {
                this.release(localSession);
            } else {
                this.offer(localSession);
            }
        }
    }

    @Override
    public ResultSet executeWithParameter(String gql, Map<String, Object> params, String space, Map<String, Object> extraReturn) {
        Session session = null;
        LocalSession localSession = null;
        ResultSet result = null;
        boolean useSessionPool = SessionDispatcher.useSessionPool();
        try {
            if (useSessionPool) {
                SessionPool sessionPool = MapperProxy.ENV.getSessionPool(space);
                if (sessionPool == null) {
                    throw new QueryException(space + " sessionPool is null");
                }
                extraReturn.put("localSessionSpace", space);
                return sessionPool.execute(gql, params);
            }
            localSession = this.poll();
            String[] qlAndSpace = IntervalCheckSessionDispatcher.qlWithSpace(localSession, gql, space);
            gql = qlAndSpace[1];
            String autoSwitch = qlAndSpace[0] == null ? "" : qlAndSpace[0];
            session = localSession.getSession();
            result = session.executeWithParameter(gql, params);
            localSession.setCurrentSpace(IntervalCheckSessionDispatcher.getSpace(result));
            this.handleSession(localSession, result);
            if (log.isDebugEnabled()) {
                extraReturn.put("localSessionSpace", space);
                String currentSpace = localSession.getCurrentSpace();
                if (ObjectUtils.nullSafeEquals((Object)currentSpace, (Object)autoSwitch)) {
                    extraReturn.put("autoSwitch", autoSwitch);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new QueryException("execute failed: " + e.getMessage(), e);
        }
    }

    private static String[] qlWithSpace(LocalSession localSession, String gql, String currentSpace) throws IOErrorException, BindSpaceFailedException {
        String[] qlAndSpace = new String[2];
        gql = gql.trim();
        String sessionSpace = localSession.getCurrentSpace();
        boolean sameSpace = Objects.equals(sessionSpace, currentSpace);
        if (!sameSpace && currentSpace != null) {
            qlAndSpace[0] = currentSpace;
            Session session = localSession.getSession();
            ResultSet execute = session.execute(String.format("USE `%s`", currentSpace));
            if (!execute.isSucceeded()) {
                throw new BindSpaceFailedException(String.format(" %s \"%s\"", execute.getErrorMessage(), currentSpace));
            }
        }
        qlAndSpace[1] = String.format("\n\t\t%s", gql);
        return qlAndSpace;
    }

    private static String getSpace(ResultSet result) {
        String spaceName = result.getSpaceName();
        return StringUtils.isBlank((CharSequence)spaceName) ? null : spaceName;
    }
}

