/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.session;

import java.util.Map;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.nebula.contrib.ngbatis.SessionDispatcher;
import org.nebula.contrib.ngbatis.annotations.Space;
import org.nebula.contrib.ngbatis.exception.ResourceLoadException;
import org.nebula.contrib.ngbatis.models.ClassModel;
import org.nebula.contrib.ngbatis.models.MethodModel;
import org.nebula.contrib.ngbatis.proxy.MapperProxy;
import org.nebula.contrib.ngbatis.proxy.NebulaDaoBasic;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;
import org.springframework.context.ApplicationContext;

public class SpaceRouter {
    public static String spaceFromEntity(Class<?> entityType) {
        Space spaceAnnotation;
        String space;
        boolean hasSpace;
        String defaultSpace;
        String string = defaultSpace = MapperProxy.ENV == null ? null : MapperProxy.ENV.getSpace();
        if (entityType == null) {
            return defaultSpace;
        }
        boolean hasTable = entityType.isAnnotationPresent(Table.class);
        if (hasTable) {
            Table tableAnnotation = entityType.getAnnotation(Table.class);
            String space2 = tableAnnotation.schema();
            System.out.println("table space: " + space2);
            if (StringUtils.isNotBlank((CharSequence)space2)) {
                return space2;
            }
        }
        if ((hasSpace = entityType.isAnnotationPresent(Space.class)) && StringUtils.isNotBlank((CharSequence)(space = (spaceAnnotation = entityType.getAnnotation(Space.class)).name()))) {
            System.out.println("space: " + space);
            return space;
        }
        return defaultSpace;
    }

    public static String spaceFromEntity(Class<?> entityType, ApplicationContext context) {
        String space = SpaceRouter.spaceFromEntity(entityType);
        return SpaceRouter.tryResolvePlaceholder(space, context);
    }

    public static void setClassSpace(ClassModel cm, ApplicationContext context) {
        if (cm != null) {
            String space = cm.getSpace();
            if (StringUtils.isBlank((CharSequence)space)) {
                Class daoClass = cm.getNamespace();
                Class<?> entityType = ReflectUtil.typeArg(daoClass, NebulaDaoBasic.class, 0);
                space = SpaceRouter.spaceFromEntity(entityType, context);
            }
            cm.setSpace(space);
            SessionDispatcher.addSpaceToSessionPool(cm.getSpace());
        }
    }

    public static void setMethodSpace(MethodModel methodModel, ApplicationContext applicationContext) {
        String space;
        if (!methodModel.isSpaceFromParam() && StringUtils.isNotBlank((CharSequence)(space = methodModel.getSpace()))) {
            space = SpaceRouter.tryResolvePlaceholder(space, applicationContext);
            methodModel.setSpace(space);
            SessionDispatcher.addSpaceToSessionPool(space);
        }
    }

    public static String getSpace(ClassModel cm, MethodModel mm, Map<String, Object> paramsForTemplate) {
        String space;
        boolean spaceFromParam = mm.isSpaceFromParam();
        String string = space = mm.getSpace() != null ? mm.getSpace() : cm.getSpace();
        if ("null".equals(space)) {
            space = MapperProxy.ENV.getSpace();
        }
        if (spaceFromParam && space != null) {
            String paramSpace = MapperProxy.ENV.getTextResolver().resolve(space, paramsForTemplate);
            return SpaceRouter.tryResolvePlaceholder(paramSpace);
        }
        return StringUtils.isBlank((CharSequence)space) ? MapperProxy.ENV.getSpace() : space;
    }

    public static String getSpace(Map<String, Object> m1) {
        Object edgeType = m1.get("edgeType");
        Object tag = m1.get("tag");
        String entityTypeName = edgeType != null ? edgeType.toString() : (tag != null ? tag.toString() : null);
        String defaultSpace = MapperProxy.ENV.getSpace();
        if (entityTypeName == null) {
            return defaultSpace;
        }
        Map<String, Class<?>> entityTypeMapping = MapperProxy.ENV.getMapperContext().getTagTypeMapping();
        Class<?> entityType = entityTypeMapping.get(entityTypeName);
        String space = SpaceRouter.spaceFromConfig(entityType);
        if (StringUtils.isNotBlank((CharSequence)space)) {
            return space;
        }
        return MapperProxy.ENV.getSpace();
    }

    public static String spaceFromConfig(Class<?> entityType) {
        return SpaceRouter.spaceFromConfig(entityType, MapperProxy.ENV.getContext());
    }

    public static String spaceFromConfig(Class<?> entityType, ApplicationContext context) {
        String space = null;
        ClassModel cm = MapperProxy.ENV.getMapperContext().computeEntityClassModelMap().get(entityType);
        if (cm != null) {
            space = cm.getSpace();
        }
        if (StringUtils.isBlank(space)) {
            space = SpaceRouter.spaceFromEntity(entityType, context);
        }
        return space;
    }

    public static String tryResolvePlaceholder(String value) {
        return SpaceRouter.tryResolvePlaceholder(value, MapperProxy.ENV.getContext());
    }

    public static String tryResolvePlaceholder(String configKey, ApplicationContext context) {
        if (StringUtils.isBlank((CharSequence)configKey)) {
            return null;
        }
        String resolveResult = configKey;
        if (null != context) {
            try {
                resolveResult = context.getEnvironment().resolveRequiredPlaceholders(configKey);
            }
            catch (IllegalArgumentException e) {
                throw new ResourceLoadException("name ( " + configKey + " ) missing configurable value");
            }
        }
        return resolveResult;
    }
}

