/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.utils;

import java.util.ArrayList;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public class ConfigUtil {
    public static <T> T getConfig(ConfigurableEnvironment environment, String prefix, Class<T> clazz) {
        PropertySource configurationProperties = environment.getPropertySources().get("configurationProperties");
        if (configurationProperties == null) {
            return null;
        }
        Object sources = configurationProperties.getSource();
        ArrayList<ConfigurationPropertySource> sourceList = new ArrayList<ConfigurationPropertySource>();
        if (sources instanceof Iterable) {
            for (Object source : (Iterable)sources) {
                if (!(source instanceof ConfigurationPropertySource)) continue;
                sourceList.add((ConfigurationPropertySource)source);
            }
            Binder binder = new Binder(sourceList);
            Bindable bindable = Bindable.of((ResolvableType)ResolvableType.forClass(clazz));
            BindResult result = binder.bind(prefix, bindable);
            if (result.isBound()) {
                return (T)result.get();
            }
        }
        return null;
    }
}

