/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.StringUtils;

public class KeySymbolMap
extends HashMap<String, Object> {
    private final Map<String, Object> map;
    private String split;

    public KeySymbolMap(Map<String, Object> map, String split) {
        if (map == null) {
            throw new IllegalArgumentException("map is null.");
        }
        this.map = map;
        this.split = split;
        this.recursionConstructor();
    }

    public Map<String, Object> getOneDMap() {
        return this.getOneDMap(this.split);
    }

    public Map<String, Object> getOneDMap(String split) {
        return this.getOneDMap("", split);
    }

    private Map<String, Object> getOneDMap(String prefix, String split) {
        HashMap<String, Object> oneDMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            String newKey;
            String key = entry.getKey();
            Object value = entry.getValue();
            String string = newKey = StringUtils.isBlank((CharSequence)prefix) ? key : prefix + split + key;
            if (value instanceof KeySymbolMap) {
                ((KeySymbolMap)value).putOneDMap(oneDMap, newKey, split);
                continue;
            }
            if (value instanceof Collection) {
                int i = 0;
                for (KeySymbolMap mapInColl : (Collection)value) {
                    String newKeyInColl = newKey + split + i;
                    mapInColl.putOneDMap(oneDMap, newKeyInColl, split);
                    ++i;
                }
                continue;
            }
            oneDMap.put(newKey, value);
        }
        return oneDMap;
    }

    private void putOneDMap(Map<String, Object> result, String prefix, String split) {
        Map<String, Object> oneDMapInner = this.getOneDMap(prefix, split);
        result.putAll(oneDMapInner);
    }

    public void recursionConstructor() {
        for (Map.Entry<String, Object> me : this.map.entrySet()) {
            Object value = me.getValue();
            if (value instanceof Map && !(value instanceof KeySymbolMap)) {
                me.setValue(new KeySymbolMap((Map)value, this.split));
                continue;
            }
            if (!(value instanceof List)) continue;
            int size = ((List)value).size();
            for (int i = 0; i < size; ++i) {
                Object o = ((List)value).get(i);
                if (!(o instanceof Map)) continue;
                KeySymbolMap element = new KeySymbolMap((Map)o, this.split);
                ((List)value).set(i, element);
            }
        }
    }

    @Override
    public Object get(Object keyDot) {
        if (keyDot == null) {
            return null;
        }
        String[] split = keyDot.toString().split(this.split);
        ConcurrentLinkedQueue<String> queue = new ConcurrentLinkedQueue<String>(Arrays.asList(split));
        Object o = this.get(queue, null);
        return o;
    }

    public Object get(Queue<String> queue, String collectionInner) {
        if (queue.size() != 0) {
            String currentKey = collectionInner == null ? queue.poll() : collectionInner;
            boolean isLeaf = queue.size() == 0;
            Object data = this.map.get(currentKey);
            if (isLeaf) {
                return data;
            }
            if (data instanceof KeySymbolMap) {
                return ((KeySymbolMap)data).get(queue, null);
            }
            if (data instanceof Collection) {
                Iterator iterator = ((Collection)data).iterator();
                String collectionInnerKey = queue.poll();
                ArrayList<Object> value = new ArrayList<Object>();
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (!(next instanceof KeySymbolMap)) continue;
                    Object o = ((KeySymbolMap)next).get(queue, collectionInnerKey);
                    value.add(o);
                }
                return value;
            }
            return data;
        }
        return this.map.get(collectionInner);
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(key, value);
    }

    public KeySymbolMap fluentPut(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.map.putAll(m);
    }

    public KeySymbolMap fluentPutAll(Map<? extends String, ? extends Object> m) {
        this.map.putAll(m);
        return this;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public KeySymbolMap fluentClear() {
        this.map.clear();
        return this;
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public KeySymbolMap fluentRemove(String key) {
        this.map.remove(key);
        return this;
    }

    public KeySymbolMap fluentRemove(Object key) {
        this.map.remove(key);
        return this;
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }
}

