/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.nebula.contrib.ngbatis.annotations.base.EdgeType;
import org.nebula.contrib.ngbatis.annotations.base.Tag;
import org.nebula.contrib.ngbatis.exception.ParseException;
import org.nebula.contrib.ngbatis.models.MethodModel;
import org.nebula.contrib.ngbatis.utils.StringUtil;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class ReflectUtil {
    public static final Set<Class<?>> NEED_SEALING_TYPES = new HashSet<Class<?>>(){
        {
            this.add(Short.TYPE);
            this.add(Integer.TYPE);
            this.add(Long.TYPE);
            this.add(Double.TYPE);
            this.add(Float.TYPE);
            this.add(Byte.TYPE);
            this.add(Character.TYPE);
            this.add(Boolean.TYPE);
        }
    };
    public static final List<Class<?>> CLASSES;
    public static final List<Class<?>> NUMBER_TYPES;

    public static void setValue(Object o, String prop, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field[] allColumnFields = ReflectUtil.getAllColumnFields(o.getClass(), true);
        Field declaredField = null;
        for (Field columnField : allColumnFields) {
            if (!ReflectUtil.getNameByColumn(columnField).equals(prop)) continue;
            declaredField = columnField;
            break;
        }
        if (declaredField == null) {
            throw new NoSuchFieldException(prop);
        }
        if (declaredField.getType() == Timestamp.class && value instanceof Long) {
            ReflectUtil.setValue(o, declaredField, (Object)new Timestamp((Long)value * 1000L));
        } else {
            ReflectUtil.setValue(o, declaredField, value);
        }
    }

    public static void setValue(Object o, Field field, Object value) throws IllegalAccessException {
        boolean accessible;
        if (NUMBER_TYPES.contains(field.getType())) {
            value = ReflectUtil.castNumber((Number)value, field.getType());
        }
        if (accessible = field.isAccessible()) {
            field.set(o, value);
        } else {
            field.setAccessible(true);
            field.set(o, value);
            field.setAccessible(false);
        }
    }

    public static String getNameByColumn(Field field) {
        Column columnAnno = field.getAnnotation(Column.class);
        if (columnAnno != null && columnAnno.name().length() > 0) {
            return columnAnno.name();
        }
        return field.getName();
    }

    public static Number castNumber(Number n, Class resultType) {
        if (n == null) {
            return null;
        }
        return resultType == Integer.class || resultType == Integer.TYPE ? (Number)n.intValue() : (Number)(resultType == Long.class || resultType == Long.TYPE ? (Number)n.longValue() : (Number)(resultType == Float.class || resultType == Float.TYPE ? (Number)Float.valueOf(n.floatValue()) : (Number)(resultType == Double.class || resultType == Double.TYPE ? (Number)n.doubleValue() : (Number)(resultType == Byte.class || resultType == Byte.TYPE ? (Number)n.byteValue() : (Number)(resultType == Short.class || resultType == Short.TYPE ? (Number)n.shortValue() : (Number)(resultType == BigDecimal.class ? new BigDecimal(n.toString()) : n))))));
    }

    public static Object getValue(Object o, Field field) {
        try {
            boolean accessible = field.isAccessible();
            if (accessible) {
                return field.get(o);
            }
            field.setAccessible(true);
            Object value = field.get(o);
            field.setAccessible(false);
            return value;
        }
        catch (IllegalAccessException e) {
            throw new ParseException(e.getMessage());
        }
    }

    public static String getMethodSignature(MethodModel methodModel) {
        Class<?>[] parameterTypes;
        Class<?> returnType;
        StringBuilder builder = new StringBuilder("(");
        Method method = methodModel.getMethod();
        if (method == null) {
            returnType = methodModel.getReturnType();
            parameterTypes = methodModel.getParameterTypes();
        } else {
            returnType = method.getReturnType();
            parameterTypes = method.getParameterTypes();
        }
        for (Class<?> parameterType : parameterTypes) {
            builder.append(ReflectUtil.insnType(parameterType));
        }
        String canonicalName = returnType.getCanonicalName();
        builder.append(")");
        if (returnType == Void.TYPE) {
            builder.append("V");
        } else if (returnType == Integer.TYPE) {
            builder.append("I");
        } else {
            builder.append("L");
            builder.append(canonicalName.replace(".", "/"));
            builder.append(";");
        }
        String string = builder.toString();
        return string;
    }

    public static int containsType(Method method, Class<?> parameterType) {
        List<Class<?>> classes = Arrays.asList(method.getParameterTypes());
        return classes.indexOf(parameterType);
    }

    public static Class<?> sealingBasicType(Class<?> basicType) {
        return basicType == Short.TYPE ? Short.class : (basicType == Integer.TYPE ? Integer.class : (basicType == Long.TYPE ? Long.class : (basicType == Double.TYPE ? Double.class : (basicType == Float.TYPE ? Float.class : (basicType == Byte.TYPE ? Byte.class : (basicType == Character.TYPE ? Character.class : (basicType == Boolean.TYPE ? Boolean.class : basicType)))))));
    }

    public static String insnType(Class<?> type) {
        StringBuilder builder = new StringBuilder();
        if (type == Integer.TYPE) {
            builder.append("I");
        } else if (type == Long.TYPE) {
            builder.append("J");
        } else if (type == Void.TYPE) {
            builder.append("V");
        } else {
            builder.append("L");
            String canonicalName = type.getCanonicalName().replace(".", "/");
            builder.append(canonicalName);
            builder.append(";");
        }
        return builder.toString();
    }

    public static Method getNameUniqueMethod(Class<?> daoInterface, String methodName) {
        Method[] daoMethods;
        for (Method method : daoMethods = daoInterface.getMethods()) {
            if (!ObjectUtils.nullSafeEquals((Object)method.getName(), (Object)methodName)) continue;
            return method;
        }
        return null;
    }

    public static boolean isBasicType(Class clazz) {
        return CLASSES.contains(clazz);
    }

    public static Class<?> fieldType(Object o, String fieldName) {
        try {
            Field field = o.getClass().getDeclaredField(fieldName);
            return field.getType();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isCurrentTypeOrParentType(Class<?> paramType, Class<?> parentType) {
        if (paramType == null || parentType == null) {
            return false;
        }
        if (paramType == parentType) {
            return true;
        }
        return parentType.isAssignableFrom(paramType);
    }

    public static Class<?> findLeafClassFromList(List<Class<?>> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Class<?> resultType = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            Class<?> type = list.get(i);
            if (!resultType.isAssignableFrom(type)) continue;
            resultType = type;
        }
        return resultType;
    }

    public static Class<?> findNoForkLeafClass(Collection<Class<?>> tagTypes, Class<?> resultType) {
        Class<?> nodeType = null;
        Map<Class<?>, Set<Class<?>>> classSetMap = ReflectUtil.extendTree(tagTypes);
        Set<Class<?>> subclasses = classSetMap.get(resultType);
        if (subclasses == null) {
            return null;
        }
        if (subclasses.isEmpty()) {
            return resultType;
        }
        if (subclasses.size() > 1) {
            return resultType;
        }
        while (subclasses.size() == 1) {
            nodeType = subclasses.iterator().next();
            subclasses = classSetMap.get(nodeType);
        }
        return nodeType;
    }

    public static Map<Class<?>, Set<Class<?>>> extendTree(Collection<Class<?>> tagTypes) {
        HashMap tree = new HashMap();
        ReflectUtil.extendTree(tagTypes, tree);
        return tree;
    }

    public static void extendTree(Collection<Class<?>> tagTypes, Map<Class<?>, Set<Class<?>>> tree) {
        HashSet superTypes = new HashSet();
        for (Class<?> tagType : tagTypes) {
            tree.computeIfAbsent(tagType, k -> new HashSet());
            Class<?> superclass = tagType.getSuperclass();
            if (superclass == null) continue;
            Set children = tree.computeIfAbsent(superclass, k -> new HashSet());
            children.add(tagType);
            superTypes.add(superclass);
        }
        if (!superTypes.isEmpty()) {
            ReflectUtil.extendTree(superTypes, tree);
        }
    }

    public static Set<Class<?>> getParentTypes(Class<?> paramType) {
        if (paramType == null) {
            return new HashSet();
        }
        List<Class<?>> interfaces = Arrays.asList(paramType.getInterfaces());
        HashSet parents = new HashSet(interfaces);
        for (Class<?> anInterface : interfaces) {
            parents.addAll(ReflectUtil.getParentTypes(anInterface));
        }
        Class<?> superclass = paramType.getSuperclass();
        parents.add(superclass);
        parents.addAll(ReflectUtil.getParentTypes(superclass));
        return parents;
    }

    public static Field[] getAllColumnFields(Class<?> clazz) {
        return ReflectUtil.getAllColumnFields(clazz, false);
    }

    public static Field[] getAllColumnFields(Class<?> clazz, boolean forValueSetting) {
        LinkedHashSet fields = new LinkedHashSet();
        do {
            Field[] declaredFields = clazz.getDeclaredFields();
            Set cols = Arrays.stream(declaredFields).filter(el -> !el.isAnnotationPresent(Transient.class) || forValueSetting).collect(Collectors.toSet());
            fields.addAll(cols);
        } while ((clazz = clazz.getSuperclass()) != null);
        return fields.toArray(new Field[0]);
    }

    public static Set<String> getAllTagName(Class<?> clazz, boolean isSubclass) {
        LinkedHashSet<String> tagNames = new LinkedHashSet<String>();
        if (clazz.isAnnotationPresent(Table.class) || isSubclass) {
            String tagName = ReflectUtil.schemaByEntityType(clazz);
            tagNames.add(tagName);
            tagNames.addAll(ReflectUtil.getAllTagName(clazz.getSuperclass(), false));
        }
        return tagNames;
    }

    public static Field getPkField(Class<?> type) {
        return ReflectUtil.getPkField(type, true);
    }

    public static Field getPkField(Class<?> type, boolean canNotNull) {
        Field[] declaredFields = ReflectUtil.getAllColumnFields(type);
        return ReflectUtil.getPkField(declaredFields, type, canNotNull);
    }

    public static Field getPkField(Field[] fields, Class<?> type) {
        return ReflectUtil.getPkField(fields, type, true);
    }

    public static Field getPkField(Field[] fields, Class<?> type, boolean canNotNull) {
        return ReflectUtil.getAnnoField(fields, type, canNotNull, Id.class);
    }

    public static Field getAnnoField(Class<?> type, Class<? extends Annotation> anno) {
        Field[] allColumnFields = ReflectUtil.getAllColumnFields(type);
        return ReflectUtil.getAnnoField(allColumnFields, type, false, anno);
    }

    public static Field getAnnoField(Field[] fields, Class<?> type, boolean canNotNull, Class<? extends Annotation> anno) {
        Field markedField = null;
        Field typeMarkedField = null;
        for (Field field : fields) {
            if (!field.isAnnotationPresent(anno)) continue;
            markedField = field;
            if (!field.getDeclaringClass().equals(type)) continue;
            typeMarkedField = field;
        }
        if (typeMarkedField != null) {
            markedField = typeMarkedField;
        }
        if (canNotNull && markedField == null) {
            throw new ParseException(String.format("%s \u5fc5\u987b\u6709\u4e00\u4e2a\u5c5e\u6027\u7528 @%s \u6ce8\u89e3\u3002\uff08%s\uff09", type, anno.getSimpleName(), anno.getName()));
        }
        return markedField;
    }

    public static Class<?> typeArg(Object o, Class<?> parent, int i) {
        Assert.isTrue((o != null ? 1 : 0) != 0, (String)"instance can not be null");
        Class<?> insClass = o.getClass();
        if (parent.isInterface()) {
            return ReflectUtil.typeArg(insClass, parent, i);
        }
        return null;
    }

    public static Class<?> typeArg(Class<?> clazz, Class<?> parent, int i) {
        Type[] interfaces;
        for (Type anInterface : interfaces = clazz.getGenericInterfaces()) {
            boolean found;
            boolean isType = anInterface instanceof ParameterizedType;
            if (!isType) continue;
            ParameterizedType paramTypeInterface = (ParameterizedType)anInterface;
            boolean bl = found = paramTypeInterface.getRawType() == parent;
            if (!found) continue;
            Type[] actualTypeArguments = paramTypeInterface.getActualTypeArguments();
            boolean noOut = actualTypeArguments.length > i;
            return noOut ? (Class)actualTypeArguments[i] : null;
        }
        return null;
    }

    public static Class<?> typeToClass(Type type) throws ClassNotFoundException {
        String typeName = type.getTypeName();
        if (type instanceof ParameterizedType) {
            typeName = ((ParameterizedType)type).getRawType().getTypeName();
        }
        return Class.forName(typeName);
    }

    public static String schemaByEntityType(Class<?> entityType) {
        Table tableAnno = entityType.getAnnotation(Table.class);
        Tag tagAnno = entityType.getAnnotation(Tag.class);
        EdgeType edgeTypeAnno = entityType.getAnnotation(EdgeType.class);
        if (tableAnno != null) {
            return tableAnno.name();
        }
        if (tagAnno != null) {
            return tagAnno.name();
        }
        if (edgeTypeAnno != null) {
            return edgeTypeAnno.name();
        }
        return StringUtil.camelToUnderline(entityType.getSimpleName());
    }

    public static boolean isGraphId(Field field) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = field.getAnnotations()) {
            if (!(annotation instanceof Id)) continue;
            return true;
        }
        return false;
    }

    static {
        NUMBER_TYPES = Arrays.asList(Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, BigDecimal.class);
        CLASSES = Arrays.asList(String.class, Character.class, Character.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Boolean.class, Boolean.TYPE);
    }
}

