/*
 * Decompiled with CFR 0.152.
 */
package org.nebula.contrib.ngbatis.utils;

import com.vesoft.nebula.DateTime;
import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.Time;
import com.vesoft.nebula.client.graph.data.DateTimeWrapper;
import com.vesoft.nebula.client.graph.data.DateWrapper;
import com.vesoft.nebula.client.graph.data.DurationWrapper;
import com.vesoft.nebula.client.graph.data.Node;
import com.vesoft.nebula.client.graph.data.Relationship;
import com.vesoft.nebula.client.graph.data.ResultSet;
import com.vesoft.nebula.client.graph.data.TimeWrapper;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.sql.Date;
import java.time.Duration;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.nebula.contrib.ngbatis.annotations.DstId;
import org.nebula.contrib.ngbatis.annotations.SrcId;
import org.nebula.contrib.ngbatis.exception.ResultHandleException;
import org.nebula.contrib.ngbatis.models.MapperContext;
import org.nebula.contrib.ngbatis.proxy.MapperProxy;
import org.nebula.contrib.ngbatis.utils.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetUtil {
    private static Logger log = LoggerFactory.getLogger(ResultSetUtil.class);
    public static boolean if_unknown_node_to_map = false;
    public static boolean if_unknown_relation_to_map = false;
    public static String v_id_key = "vId";
    public static String props_name_key = "properties";
    public static String ranking_id_key = "rank";
    public static String src_id_key = "srcID";
    public static String dst_id_key = "dstID";
    public static String edge_name_key = "edgeName";
    public static String tags_key = "tags";
    public static String type_key = "type";
    public static String type_vertex_value = "vertex";
    public static String type_edge_value = "edge";

    public static <T> T getValue(ValueWrapper value, Class<T> resultType) {
        try {
            Number o;
            Object object = value.isLong() ? Long.valueOf(value.asLong()) : (value.isBoolean() ? Boolean.valueOf(value.asBoolean()) : (value.isDouble() ? Double.valueOf(value.asDouble()) : (value.isString() ? value.asString() : (value.isTime() ? ResultSetUtil.transformTime(value.asTime()) : (value.isDate() ? ResultSetUtil.transformDate(value.asDate()) : (value.isDateTime() ? ResultSetUtil.transformDateTime(value.asDateTime()) : (value.isVertex() ? ResultSetUtil.transformNode(value.asNode(), resultType) : (value.isEdge() ? ResultSetUtil.transformRelationship(value) : (value.isPath() ? value.asPath() : (value.isList() ? ResultSetUtil.transformList(value.asList()) : (value.isSet() ? ResultSetUtil.transformSet(value.asSet()) : (value.isMap() ? ResultSetUtil.transformMap(value.asMap()) : (o = value.isDuration() ? ResultSetUtil.transformDuration(value.asDuration()) : null)))))))))))));
            if (o instanceof Number) {
                o = ReflectUtil.castNumber(o, resultType);
            }
            return (T)o;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getValue(ValueWrapper valueWrapper) {
        T value = ResultSetUtil.getValue(valueWrapper, null);
        return value;
    }

    private static Object transformDateTime(DateTimeWrapper dateTime) {
        DateTime localDateTime = dateTime.getLocalDateTime();
        int month = localDateTime.getMonth() - 1;
        GregorianCalendar calendar = new GregorianCalendar(localDateTime.getYear(), month, localDateTime.getDay(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSec());
        calendar.set(14, Math.floorDiv(localDateTime.getMicrosec(), 1000));
        return calendar.getTime();
    }

    private static Object transformDate(DateWrapper date) {
        return new Date(date.getYear() - 1900, date.getMonth() - 1, date.getDay());
    }

    private static Object transformTime(TimeWrapper time) {
        Time localTime = time.getLocalTime();
        return new java.sql.Time(localTime.getHour(), localTime.getMinute(), localTime.getSec());
    }

    private static Object transformDuration(DurationWrapper du) {
        return Duration.ofNanos(du.getSeconds() * 1000000000L);
    }

    private static Object transformNode(Node node, Class<?> resultType) {
        Class<?> nodeType;
        List tagNames = node.tagNames();
        List<Class<?>> tagTypes = ResultSetUtil.findTagTypes(tagNames);
        Class<?> clazz = nodeType = resultType == null ? ReflectUtil.findLeafClassFromList(tagTypes) : ReflectUtil.findNoForkLeafClass(tagTypes, resultType);
        if (nodeType != null) {
            return ResultSetUtil.nodeToResultType(node, nodeType);
        }
        return if_unknown_node_to_map ? ResultSetUtil.nodeToMap(node) : node;
    }

    private static List<Class<?>> findTagTypes(List<String> tagNames) {
        MapperContext mapperContext = MapperProxy.ENV.getMapperContext();
        Map<String, Class<?>> tagTypeMapping = mapperContext.getTagTypeMapping();
        ArrayList tagTypes = new ArrayList();
        for (String tagName : tagNames) {
            Class<?> tagType = tagTypeMapping.get(tagName);
            if (tagType == null) continue;
            tagTypes.add(tagType);
        }
        return tagTypes;
    }

    private static Object transformMap(HashMap<String, ValueWrapper> map) {
        HashMap javaResult = new HashMap();
        for (Map.Entry<String, ValueWrapper> entry : map.entrySet()) {
            String k = entry.getKey();
            ValueWrapper v = entry.getValue();
            javaResult.put(k, ResultSetUtil.getValue(v));
        }
        return javaResult;
    }

    private static Object transformRelationship(ValueWrapper value) {
        Relationship relationship = value.asRelationship();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (if_unknown_relation_to_map) {
            try {
                String edgeName = relationship.edgeName();
                result.put(type_key, type_edge_value);
                result.put(edge_name_key, edgeName);
                result.put(ranking_id_key, relationship.ranking());
                ValueWrapper srcId = relationship.srcId();
                result.put(src_id_key, ResultSetUtil.getValue(srcId));
                result.put(props_name_key, ResultSetUtil.edgePropsToMap(relationship));
                ValueWrapper dstId = relationship.dstId();
                result.put(dst_id_key, ResultSetUtil.getValue(dstId));
            }
            catch (UnsupportedEncodingException e) {
                throw new ResultHandleException(String.format("%s : %s", e.getClass().toString(), e.getMessage()));
            }
            return result;
        }
        return relationship;
    }

    public static Map<String, Object> edgePropsToMap(Relationship relationship) throws UnsupportedEncodingException {
        HashMap dbProps = relationship.properties();
        LinkedHashMap<String, Object> resultProps = new LinkedHashMap<String, Object>();
        dbProps.forEach((k, v) -> resultProps.put((String)k, ResultSetUtil.getValue(v)));
        return resultProps;
    }

    private static Object nodeToMap(Node node) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        try {
            result.put(type_key, type_vertex_value);
            result.put(v_id_key, ResultSetUtil.getValue(node.getId()));
            List tagNames = node.tagNames();
            result.put(tags_key, tagNames);
            result.put(props_name_key, ResultSetUtil.nodePropsToMap(node));
        }
        catch (UnsupportedEncodingException e) {
            throw new ResultHandleException(String.format("%s : %s", e.getClass().toString(), e.getMessage()));
        }
        return result;
    }

    public static Map<String, Object> nodePropsToMap(Node node) throws UnsupportedEncodingException {
        LinkedHashMap<String, Object> vertexProps = new LinkedHashMap<String, Object>();
        List tagNames = node.tagNames();
        for (String tagName : tagNames) {
            HashMap dbProps = node.properties(tagName);
            LinkedHashMap labelProps = new LinkedHashMap();
            dbProps.forEach((k, v) -> labelProps.put(k, ResultSetUtil.getValue(v)));
            vertexProps.put(tagName, labelProps);
        }
        return vertexProps;
    }

    private static Object transformList(ArrayList<ValueWrapper> list) {
        return list.stream().map(ResultSetUtil::getValue).collect(Collectors.toList());
    }

    private static Set<Object> transformSet(Set<ValueWrapper> set) {
        return set.stream().map(ResultSetUtil::getValue).collect(Collectors.toSet());
    }

    public static <T> T nodeToResultType(Node v, Class<T> resultType) {
        T t = null;
        try {
            t = resultType.newInstance();
            for (Class<T> classOfTag = resultType; classOfTag != null; classOfTag = classOfTag.getSuperclass()) {
                String tagName = ReflectUtil.schemaByEntityType(classOfTag);
                ResultSetUtil.setAttrs(t, v, tagName);
            }
            ResultSetUtil.setId(t, resultType, v);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ResultHandleException(String.format("%s : %s", e.getClass().toString(), e.getMessage()));
        }
        return t;
    }

    public static void nodeToResultType(Object o, String fieldName, Node node) {
        Class<?> fieldType = ReflectUtil.fieldType(o, fieldName);
        if (fieldType != null) {
            Object fieldValue = ResultSetUtil.nodeToResultType(node, fieldType);
            try {
                ReflectUtil.setValue(o, fieldName, fieldValue);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> T relationshipToResultType(Relationship r, Class<T> resultType) {
        T t = null;
        try {
            t = resultType.newInstance();
            HashMap properties = r.properties();
            for (Map.Entry entry : properties.entrySet()) {
                ReflectUtil.setValue(t, (String)entry.getKey(), ResultSetUtil.getValue((ValueWrapper)entry.getValue()));
            }
            ResultSetUtil.setEdgeExtraAttrs(t, resultType, r);
        }
        catch (UnsupportedEncodingException | IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return t;
    }

    public static void relationshipToResultType(Object o, String fieldName, Relationship relationship) {
        Class<?> fieldType = ReflectUtil.fieldType(o, fieldName);
        if (fieldType != null) {
            Object fieldValue = ResultSetUtil.relationshipToResultType(relationship, fieldType);
            try {
                ReflectUtil.setValue(o, fieldName, fieldValue);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setId(Object obj, Class<?> resultType, Node v) throws IllegalAccessException {
        Field pkField = ReflectUtil.getPkField(resultType, false);
        if (pkField != null) {
            ValueWrapper idWrapper = v.getId();
            Object id = ResultSetUtil.getValue(idWrapper);
            ReflectUtil.setValue(obj, pkField, id);
        }
        if (resultType.getSuperclass() != null) {
            ResultSetUtil.setId(obj, resultType.getSuperclass(), v);
        }
    }

    @Deprecated
    public static void setRanking(Object obj, Class<?> resultType, Relationship e) throws IllegalAccessException {
        Field pkField = ReflectUtil.getPkField(resultType, false);
        if (pkField != null) {
            long ranking = e.ranking();
            ReflectUtil.setValue(obj, pkField, (Object)ranking);
        }
        if (resultType.getSuperclass() != null) {
            ResultSetUtil.setRanking(obj, resultType.getSuperclass(), e);
        }
    }

    public static void setEdgeExtraAttrs(Object t, Class<?> resultType, Relationship e) throws IllegalAccessException {
        Field dstIdField;
        Field srcIdField;
        Field pkField = ReflectUtil.getPkField(resultType, false);
        if (pkField != null) {
            long ranking = e.ranking();
            ReflectUtil.setValue(t, pkField, (Object)ranking);
        }
        if ((srcIdField = ReflectUtil.getAnnoField(resultType, SrcId.class)) != null) {
            Object srcId = ResultSetUtil.getValue(e.srcId());
            ReflectUtil.setValue(t, srcIdField, srcId);
        }
        if ((dstIdField = ReflectUtil.getAnnoField(resultType, DstId.class)) != null) {
            Object dstId = ResultSetUtil.getValue(e.dstId());
            ReflectUtil.setValue(t, dstIdField, dstId);
        }
        if (resultType.getSuperclass() != null) {
            ResultSetUtil.setEdgeExtraAttrs(t, resultType.getSuperclass(), e);
        }
    }

    public static void setAttrs(Object t, Node v, String tagName) {
        try {
            if (!v.tagNames().contains(tagName)) {
                return;
            }
            List values = v.values(tagName);
            List keys = v.keys(tagName);
            for (int i = 0; i < keys.size(); ++i) {
                String prop = (String)keys.get(i);
                ReflectUtil.setValue(t, prop, ResultSetUtil.getValue((ValueWrapper)values.get(i)));
            }
        }
        catch (UnsupportedEncodingException | IllegalAccessException | NoSuchFieldException e) {
            throw new ResultHandleException(String.format("%s : %s", e.getClass().toString(), e.getMessage()));
        }
    }

    public static boolean isMatchedErrorCode(ResultSet resultSet, ErrorCode ... errorCodes) {
        if (resultSet == null || errorCodes == null) {
            return false;
        }
        for (ErrorCode code : errorCodes) {
            if (resultSet.getErrorCode() != code.getValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean isSessionError(ResultSet resultSet) {
        if (resultSet == null) {
            return true;
        }
        return ResultSetUtil.isMatchedErrorCode(resultSet, ErrorCode.E_SESSION_INVALID, ErrorCode.E_SESSION_NOT_FOUND, ErrorCode.E_SESSION_TIMEOUT);
    }

    public static boolean isSemanticError(ResultSet resultSet) {
        return ResultSetUtil.isMatchedErrorCode(resultSet, ErrorCode.E_SEMANTIC_ERROR);
    }
}

