/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class DatabaseTuningDocIT
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;

    @Test
    public void shouldLoadAKnownGoodPropertyFile() throws IOException {
        this.server = CommunityServerBuilder.server().usingDatabaseDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).withDefaultDatabaseTuning().build();
        this.server.start();
        Map params = this.server.getConfig().getParams();
        for (Map.Entry<String, String> entry : CommunityServerBuilder.good_tuning_file_properties.entrySet()) {
            Assert.assertEquals((Object)entry.getValue(), params.get(entry.getKey()));
        }
    }

    @Test
    public void shouldLogWarningAndContinueIfTuningFilePropertyDoesNotResolve() throws IOException {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        this.server = CommunityServerBuilder.server((LogProvider)logProvider).usingDatabaseDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).withNonResolvableTuningFile().build();
        this.server.start();
        logProvider.assertContainsMessageContaining("Config file [%s] does not exist.");
    }

    @After
    public void cleanup() {
        if (this.server != null) {
            this.server.stop();
        }
    }
}

