/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.parboiled.common.FileUtils;

public class ServerSettingsTest {
    @Rule
    public TemporaryFolder dir = new TemporaryFolder();
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldConvertWebserverTLSToDBMSTLS() throws Throwable {
        AssertableLogProvider logging = new AssertableLogProvider();
        Config config = new Config(MapUtil.stringMap((String[])new String[]{ServerSettings.webserver_https_cert_path.name(), "cert", ServerSettings.webserver_https_key_path.name(), "key"}), new Class[]{ServerSettings.class});
        config.setLogger(logging.getLog("config"));
        Assert.assertEquals((Object)"cert", (Object)((File)config.get(ServerSettings.tls_certificate_file)).getPath());
        Assert.assertEquals((Object)"key", (Object)((File)config.get(ServerSettings.tls_key_file)).getPath());
        logging.assertContainsMessageContaining("The TLS certificate configuration you are using, 'org.neo4j.server.webserver.https.cert.location' is deprecated. Please use 'dbms.security.tls_certificate_file' instead.");
        logging.assertContainsMessageContaining("The TLS key configuration you are using, 'org.neo4j.server.webserver.https.key.location' is deprecated, please use 'dbms.security.tls_key_file' instead.");
    }

    @Test
    public void shouldAllowWritableLogFileTarget() throws Throwable {
        File configFile = this.createHttpLogConfig(this.dir.newFile("logfile"));
        Config config = new Config(MapUtil.stringMap((String[])new String[]{ServerSettings.http_logging_enabled.name(), "true", ServerSettings.http_log_config_file.name(), configFile.getAbsolutePath()}), new Class[]{ServerSettings.class});
        File file = (File)config.get(ServerSettings.http_log_config_file);
        MatcherAssert.assertThat((Object)file.getAbsoluteFile(), (Matcher)IsEqual.equalTo((Object)configFile.getAbsoluteFile()));
    }

    @Test
    public void shouldFailToValidateHttpLogFileWithInvalidLogFileName() throws Throwable {
        File logFile = new File(ServerSettingsTest.createUnwritableDirectory(), "logfile");
        File configFile = this.createHttpLogConfig(logFile);
        this.exception.expect(InvalidSettingException.class);
        Config config = new Config(MapUtil.stringMap((String[])new String[]{ServerSettings.http_logging_enabled.name(), "true", ServerSettings.http_log_config_file.name(), configFile.getAbsolutePath()}), new Class[]{ServerSettings.class});
    }

    private File createHttpLogConfig(File logFile) throws IOException {
        File configFile = this.dir.newFile("http-logging.xml");
        FileUtils.writeAllText((String)("<configuration>\n  <appender name=\"FILE\" class=\"ch.qos.logback.core.rolling.RollingFileAppender\">\n    <file>" + logFile.getAbsolutePath() + "</file>\n" + "    <rollingPolicy class=\"ch.qos.logback.core.rolling.TimeBasedRollingPolicy\">\n" + "      <fileNamePattern>/var/log/neo4j/http.%d{yyyy-MM-dd_HH}.log</fileNamePattern>\n" + "      <maxHistory>7</maxHistory>\n" + "    </rollingPolicy>\n" + "\n" + "    <encoder>\n" + "      <!-- Note the deliberate misspelling of \"referer\" in accordance with RFC1616 -->\n" + "      <pattern>%h %l %user [%t{dd/MMM/yyyy:HH:mm:ss Z}] \"%r\" %s %b \"%i{Referer}\" \"%i{User-Agent}\" %D</pattern>\n" + "    </encoder>\n" + "  </appender>\n" + "\n" + "  <appender-ref ref=\"FILE\"/>\n" + "</configuration>\n" + "\n"), (File)configFile, (Charset)StandardCharsets.UTF_8);
        return configFile;
    }

    public static File createUnwritableDirectory() {
        File file = SystemUtils.IS_OS_WINDOWS ? new File("\\\\" + UUID.randomUUID().toString() + "\\") : (SystemUtils.IS_OS_MAC_OSX ? new File("/Network/Servers/localhost/" + UUID.randomUUID().toString()) : new File("/proc/" + UUID.randomUUID().toString() + "/random"));
        return file;
    }
}

