/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;

public class ConfigureBaseUriDocIT
extends AbstractRestFunctionalTestBase {
    private static FunctionalTestHelper functionalTestHelper;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(ConfigureBaseUriDocIT.server());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldForwardHttpAndHost() throws Exception {
        URI rootUri = functionalTestHelper.baseUri();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(rootUri);
            httpget.setHeader("Accept", "application/json");
            httpget.setHeader("X-Forwarded-Host", "foobar.com");
            httpget.setHeader("X-Forwarded-Proto", "http");
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            String length = response.getHeaders("CONTENT-LENGTH")[0].getValue();
            byte[] data = new byte[Integer.valueOf(length).intValue()];
            response.getEntity().getContent().read(data);
            String responseEntityBody = new String(data);
            Assert.assertTrue((boolean)responseEntityBody.contains("http://foobar.com"));
            Assert.assertFalse((boolean)responseEntityBody.contains("localhost"));
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldForwardHttpsAndHost() throws Exception {
        URI rootUri = functionalTestHelper.baseUri();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(rootUri);
            httpget.setHeader("Accept", "application/json");
            httpget.setHeader("X-Forwarded-Host", "foobar.com");
            httpget.setHeader("X-Forwarded-Proto", "https");
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            String length = response.getHeaders("CONTENT-LENGTH")[0].getValue();
            byte[] data = new byte[Integer.valueOf(length).intValue()];
            response.getEntity().getContent().read(data);
            String responseEntityBody = new String(data);
            Assert.assertTrue((boolean)responseEntityBody.contains("https://foobar.com"));
            Assert.assertFalse((boolean)responseEntityBody.contains("localhost"));
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldForwardHttpAndHostOnDifferentPort() throws Exception {
        URI rootUri = functionalTestHelper.baseUri();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(rootUri);
            httpget.setHeader("Accept", "application/json");
            httpget.setHeader("X-Forwarded-Host", "foobar.com:9999");
            httpget.setHeader("X-Forwarded-Proto", "http");
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            String length = response.getHeaders("CONTENT-LENGTH")[0].getValue();
            byte[] data = new byte[Integer.valueOf(length).intValue()];
            response.getEntity().getContent().read(data);
            String responseEntityBody = new String(data);
            Assert.assertTrue((boolean)responseEntityBody.contains("http://foobar.com:9999"));
            Assert.assertFalse((boolean)responseEntityBody.contains("localhost"));
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldForwardHttpAndFirstHost() throws Exception {
        URI rootUri = functionalTestHelper.baseUri();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(rootUri);
            httpget.setHeader("Accept", "application/json");
            httpget.setHeader("X-Forwarded-Host", "foobar.com, bazbar.com");
            httpget.setHeader("X-Forwarded-Proto", "http");
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            String length = response.getHeaders("CONTENT-LENGTH")[0].getValue();
            byte[] data = new byte[Integer.valueOf(length).intValue()];
            response.getEntity().getContent().read(data);
            String responseEntityBody = new String(data);
            Assert.assertTrue((boolean)responseEntityBody.contains("http://foobar.com"));
            Assert.assertFalse((boolean)responseEntityBody.contains("localhost"));
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldForwardHttpsAndHostOnDifferentPort() throws Exception {
        URI rootUri = functionalTestHelper.baseUri();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(rootUri);
            httpget.setHeader("Accept", "application/json");
            httpget.setHeader("X-Forwarded-Host", "foobar.com:9999");
            httpget.setHeader("X-Forwarded-Proto", "https");
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            String length = response.getHeaders("CONTENT-LENGTH")[0].getValue();
            byte[] data = new byte[Integer.valueOf(length).intValue()];
            response.getEntity().getContent().read(data);
            String responseEntityBody = new String(data);
            Assert.assertTrue((boolean)responseEntityBody.contains("https://foobar.com:9999"));
            Assert.assertFalse((boolean)responseEntityBody.contains("localhost"));
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUseRequestUriWhenNoXForwardHeadersPresent() throws Exception {
        URI rootUri = functionalTestHelper.baseUri();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(rootUri);
            httpget.setHeader("Accept", "application/json");
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            String length = response.getHeaders("CONTENT-LENGTH")[0].getValue();
            byte[] data = new byte[Integer.valueOf(length).intValue()];
            response.getEntity().getContent().read(data);
            String responseEntityBody = new String(data);
            Assert.assertFalse((boolean)responseEntityBody.contains("https://foobar.com"));
            Assert.assertFalse((boolean)responseEntityBody.contains(":0"));
            Assert.assertTrue((boolean)responseEntityBody.contains("localhost"));
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }
}

