/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.SyntaxException;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QuerySession;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.rest.transactional.ExecutionResultSerializer;
import org.neo4j.server.rest.transactional.ResultDataContent;
import org.neo4j.server.rest.transactional.Statement;
import org.neo4j.server.rest.transactional.StatementDeserializer;
import org.neo4j.server.rest.transactional.StubStatementDeserializer;
import org.neo4j.server.rest.transactional.TransactionHandle;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;
import org.neo4j.server.rest.transactional.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.rest.transactional.error.Neo4jError;
import org.neo4j.server.rest.web.QuerySessionProvider;
import org.neo4j.server.rest.web.TransactionUriScheme;

public class TransactionHandleTest {
    private static final TransactionUriScheme uriScheme = new TransactionUriScheme(){

        public URI txUri(long id) {
            return URI.create("transaction/" + id);
        }

        public URI txCommitUri(long id) {
            return URI.create("transaction/" + id + "/commit");
        }
    };

    @Test
    public void shouldExecuteStatements() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        QueryExecutionEngine executionEngine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        Result executionResult = (Result)Mockito.mock(Result.class);
        QuerySession querySession = QueryEngineProvider.embeddedSession();
        QuerySessionProvider querySessionProvider = (QuerySessionProvider)Mockito.mock(QuerySessionProvider.class);
        Mockito.when((Object)querySessionProvider.create((HttpServletRequest)Mockito.any(HttpServletRequest.class))).thenReturn((Object)querySession);
        Mockito.when((Object)executionEngine.executeQuery("query", MapUtil.map((Object[])new Object[0]), querySession)).thenReturn((Object)executionResult);
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, (LogProvider)NullLogProvider.getInstance(), querySessionProvider);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null)), output, (HttpServletRequest)Mockito.mock(HttpServletRequest.class));
        ((QueryExecutionEngine)Mockito.verify((Object)executionEngine)).executeQuery("query", MapUtil.map((Object[])new Object[0]), querySession);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionCommitUri(uriScheme.txCommitUri(1337L));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(executionResult, false, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).notifications((Iterable)Matchers.anyCollectionOf(Notification.class));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionStatus(Mockito.anyLong());
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldSuspendTransactionAndReleaseForOtherRequestsAfterExecutingStatements() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = kernel.newTransaction();
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        QueryExecutionEngine executionEngine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        QuerySession querySession = (QuerySession)Mockito.mock(QuerySession.class);
        QuerySessionProvider querySessionProvider = (QuerySessionProvider)Mockito.mock(QuerySessionProvider.class);
        Mockito.when((Object)querySessionProvider.create((HttpServletRequest)Mockito.any(HttpServletRequest.class))).thenReturn((Object)querySession);
        Result executionResult = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)executionEngine.executeQuery("query", MapUtil.map((Object[])new Object[0]), querySession)).thenReturn((Object)executionResult);
        Mockito.when((Object)registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, (LogProvider)NullLogProvider.getInstance(), querySessionProvider);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null)), output, (HttpServletRequest)Mockito.mock(HttpServletRequest.class));
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{transactionContext, registry});
        ((TransitionalTxManagementKernelTransaction)transactionOrder.verify((Object)transactionContext)).suspendSinceTransactionsAreStillThreadBound();
        ((TransactionRegistry)transactionOrder.verify((Object)registry)).release(1337L, handle);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionCommitUri(uriScheme.txCommitUri(1337L));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(executionResult, false, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).notifications((Iterable)Matchers.anyCollectionOf(Notification.class));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionStatus(Mockito.anyLong());
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldResumeTransactionWhenExecutingStatementsOnSecondRequest() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = kernel.newTransaction();
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        QuerySession querySession = QueryEngineProvider.embeddedSession();
        QuerySessionProvider querySessionProvider = (QuerySessionProvider)Mockito.mock(QuerySessionProvider.class);
        QueryExecutionEngine executionEngine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        Mockito.when((Object)querySessionProvider.create((HttpServletRequest)Mockito.any(HttpServletRequest.class))).thenReturn((Object)querySession);
        Mockito.when((Object)registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, (LogProvider)NullLogProvider.getInstance(), querySessionProvider);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null)), output, (HttpServletRequest)Mockito.mock(HttpServletRequest.class));
        Mockito.reset((Object[])new Object[]{transactionContext, registry, executionEngine, output});
        Result executionResult = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)executionEngine.executeQuery("query", MapUtil.map((Object[])new Object[0]), querySession)).thenReturn((Object)executionResult);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null)), output, (HttpServletRequest)Mockito.mock(HttpServletRequest.class));
        InOrder order = Mockito.inOrder((Object[])new Object[]{transactionContext, registry, executionEngine});
        ((TransitionalTxManagementKernelTransaction)order.verify((Object)transactionContext)).resumeSinceTransactionsAreStillThreadBound();
        ((QueryExecutionEngine)order.verify((Object)executionEngine)).executeQuery("query", MapUtil.map((Object[])new Object[0]), querySession);
        ((TransitionalTxManagementKernelTransaction)order.verify((Object)transactionContext)).suspendSinceTransactionsAreStillThreadBound();
        ((TransactionRegistry)order.verify((Object)registry)).release(1337L, handle);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionCommitUri(uriScheme.txCommitUri(1337L));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(executionResult, false, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).notifications((Iterable)Matchers.anyCollectionOf(Notification.class));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionStatus(Mockito.anyLong());
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldCommitSinglePeriodicCommitStatement() throws Exception {
        String queryText = "USING PERIODIC COMMIT CREATE()";
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        QueryExecutionEngine executionEngine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        Result executionResult = (Result)Mockito.mock(Result.class);
        QuerySession querySession = QueryEngineProvider.embeddedSession();
        QuerySessionProvider querySessionProvider = (QuerySessionProvider)Mockito.mock(QuerySessionProvider.class);
        Mockito.when((Object)querySessionProvider.create((HttpServletRequest)Mockito.any(HttpServletRequest.class))).thenReturn((Object)querySession);
        Mockito.when((Object)executionEngine.isPeriodicCommit(queryText)).thenReturn((Object)true);
        Mockito.when((Object)executionEngine.executeQuery((String)Mockito.eq((Object)queryText), (Map)Mockito.eq((Object)MapUtil.map((Object[])new Object[0])), (QuerySession)Mockito.eq((Object)querySession))).thenReturn((Object)executionResult);
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, (LogProvider)NullLogProvider.getInstance(), querySessionProvider);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        Statement statement = new Statement(queryText, MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null);
        handle.commit((StatementDeserializer)StubStatementDeserializer.statements(statement), output, true, (HttpServletRequest)Mockito.mock(HttpServletRequest.class));
        ((QueryExecutionEngine)Mockito.verify((Object)executionEngine)).isPeriodicCommit(queryText);
        ((QueryExecutionEngine)Mockito.verify((Object)executionEngine)).executeQuery(queryText, MapUtil.map((Object[])new Object[0]), querySession);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(executionResult, false, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).notifications((Iterable)Matchers.anyCollectionOf(Notification.class));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldCommitTransactionAndTellRegistryToForgetItsHandle() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = kernel.newTransaction();
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        QueryExecutionEngine engine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        QuerySession querySession = (QuerySession)Mockito.mock(QuerySession.class);
        QuerySessionProvider querySessionProvider = (QuerySessionProvider)Mockito.mock(QuerySessionProvider.class);
        Mockito.when((Object)querySessionProvider.create((HttpServletRequest)Mockito.any(HttpServletRequest.class))).thenReturn((Object)querySession);
        Result result = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)engine.executeQuery("query", MapUtil.map((Object[])new Object[0]), querySession)).thenReturn((Object)result);
        Mockito.when((Object)registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, engine, registry, uriScheme, (LogProvider)NullLogProvider.getInstance(), querySessionProvider);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null);
        handle.commit((StatementDeserializer)StubStatementDeserializer.statements(statement), output, false, (HttpServletRequest)Mockito.mock(HttpServletRequest.class));
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{transactionContext, registry});
        ((TransitionalTxManagementKernelTransaction)transactionOrder.verify((Object)transactionContext)).commit();
        ((TransactionRegistry)transactionOrder.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(result, false, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).notifications((Iterable)Matchers.anyCollectionOf(Notification.class));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldRollbackTransactionAndTellRegistryToForgetItsHandle() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = kernel.newTransaction();
        QuerySessionProvider querySessionProvider = (QuerySessionProvider)Mockito.mock(QuerySessionProvider.class);
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class), registry, uriScheme, (LogProvider)NullLogProvider.getInstance(), querySessionProvider);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.rollback(output);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{transactionContext, registry});
        ((TransitionalTxManagementKernelTransaction)transactionOrder.verify((Object)transactionContext)).rollback();
        ((TransactionRegistry)transactionOrder.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldCreateTransactionContextOnlyWhenFirstNeeded() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        QueryExecutionEngine engine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        Result executionResult = (Result)Mockito.mock(Result.class);
        QuerySession querySession = (QuerySession)Mockito.mock(QuerySession.class);
        QuerySessionProvider querySessionProvider = (QuerySessionProvider)Mockito.mock(QuerySessionProvider.class);
        Mockito.when((Object)querySessionProvider.create((HttpServletRequest)Mockito.any(HttpServletRequest.class))).thenReturn((Object)querySession);
        Mockito.when((Object)engine.executeQuery("query", MapUtil.map((Object[])new Object[0]), querySession)).thenReturn((Object)executionResult);
        Mockito.when((Object)registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, engine, registry, uriScheme, (LogProvider)NullLogProvider.getInstance(), querySessionProvider);
        Mockito.verifyZeroInteractions((Object[])new Object[]{kernel});
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null)), output, (HttpServletRequest)Mockito.mock(HttpServletRequest.class));
        ((TransitionalPeriodTransactionMessContainer)Mockito.verify((Object)kernel)).newTransaction();
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionCommitUri(uriScheme.txCommitUri(1337L));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(executionResult, false, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).notifications((Iterable)Matchers.anyCollectionOf(Notification.class));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionStatus(Mockito.anyLong());
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasNoErrors()));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldRollbackTransactionIfExecutionErrorOccurs() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = kernel.newTransaction();
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        QueryExecutionEngine executionEngine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        QuerySession querySession = (QuerySession)Mockito.mock(QuerySession.class);
        QuerySessionProvider querySessionProvider = (QuerySessionProvider)Mockito.mock(QuerySessionProvider.class);
        Mockito.when((Object)querySessionProvider.create((HttpServletRequest)Mockito.any(HttpServletRequest.class))).thenReturn((Object)querySession);
        Mockito.when((Object)executionEngine.executeQuery("query", MapUtil.map((Object[])new Object[0]), querySession)).thenThrow(new Throwable[]{new NullPointerException()});
        Mockito.when((Object)registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, (LogProvider)NullLogProvider.getInstance(), querySessionProvider);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null)), output, (HttpServletRequest)Mockito.mock(HttpServletRequest.class));
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)transactionContext)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).transactionCommitUri(uriScheme.txCommitUri(1337L));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasErrors(new Status[]{Status.Statement.ExecutionFailure})));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldLogMessageIfCommitErrorOccurs() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction transactionContext = kernel.newTransaction();
        ((TransitionalTxManagementKernelTransaction)Mockito.doThrow((Throwable)new NullPointerException()).when((Object)transactionContext)).commit();
        LogProvider logProvider = (LogProvider)Mockito.mock(LogProvider.class);
        Log log = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)logProvider.getLog(TransactionHandle.class)).thenReturn((Object)log);
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        QueryExecutionEngine engine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        Result executionResult = (Result)Mockito.mock(Result.class);
        QuerySession querySession = (QuerySession)Mockito.mock(QuerySession.class);
        QuerySessionProvider querySessionProvider = (QuerySessionProvider)Mockito.mock(QuerySessionProvider.class);
        Mockito.when((Object)querySessionProvider.create((HttpServletRequest)Mockito.any(HttpServletRequest.class))).thenReturn((Object)querySession);
        Mockito.when((Object)engine.executeQuery("query", MapUtil.map((Object[])new Object[0]), querySession)).thenReturn((Object)executionResult);
        Mockito.when((Object)registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, engine, registry, uriScheme, logProvider, querySessionProvider);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null);
        handle.commit((StatementDeserializer)StubStatementDeserializer.statements(statement), output, false, (HttpServletRequest)Mockito.mock(HttpServletRequest.class));
        ((Log)Mockito.verify((Object)log)).error((String)Mockito.eq((Object)"Failed to commit transaction."), (Throwable)Mockito.any(NullPointerException.class));
        ((TransactionRegistry)Mockito.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).statementResult(executionResult, false, (ResultDataContent[])null);
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).notifications((Iterable)Matchers.anyCollectionOf(Notification.class));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasErrors(new Status[]{Status.Transaction.CouldNotCommit})));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldLogMessageIfCypherSyntaxErrorOccurs() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        QueryExecutionEngine executionEngine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        QuerySession querySession = (QuerySession)Mockito.mock(QuerySession.class);
        QuerySessionProvider querySessionProvider = (QuerySessionProvider)Mockito.mock(QuerySessionProvider.class);
        Mockito.when((Object)querySessionProvider.create((HttpServletRequest)Mockito.any(HttpServletRequest.class))).thenReturn((Object)querySession);
        Mockito.when((Object)executionEngine.executeQuery("matsch (n) return n", MapUtil.map((Object[])new Object[0]), querySession)).thenThrow(new Throwable[]{new QueryExecutionKernelException((Throwable)new SyntaxException("did you mean MATCH?"))});
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, (LogProvider)NullLogProvider.getInstance(), querySessionProvider);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        Statement statement = new Statement("matsch (n) return n", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null);
        handle.commit((StatementDeserializer)StubStatementDeserializer.statements(statement), output, false, (HttpServletRequest)Mockito.mock(HttpServletRequest.class));
        ((TransactionRegistry)Mockito.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasErrors(new Status[]{Status.Statement.InvalidSyntax})));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldHandleExecutionEngineThrowingUndeclaredCheckedExceptions() throws Exception {
        QueryExecutionEngine executionEngine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        QuerySession querySession = (QuerySession)Mockito.mock(QuerySession.class);
        QuerySessionProvider querySessionProvider = (QuerySessionProvider)Mockito.mock(QuerySessionProvider.class);
        Mockito.when((Object)querySessionProvider.create((HttpServletRequest)Mockito.any(HttpServletRequest.class))).thenReturn((Object)querySession);
        Mockito.when((Object)executionEngine.executeQuery("match (n) return n", MapUtil.map((Object[])new Object[0]), querySession)).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                throw new Exception("BOO");
            }
        });
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = new TransactionHandle(this.mockKernel(), executionEngine, registry, uriScheme, (LogProvider)NullLogProvider.getInstance(), querySessionProvider);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        Statement statement = new Statement("match (n) return n", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null);
        handle.commit((StatementDeserializer)StubStatementDeserializer.statements(statement), output, false, (HttpServletRequest)Mockito.mock(HttpServletRequest.class));
        ((TransactionRegistry)Mockito.verify((Object)registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{output});
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasErrors(new Status[]{Status.Statement.ExecutionFailure})));
        ((ExecutionResultSerializer)outputOrder.verify((Object)output)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{output});
    }

    @Test
    public void shouldInterruptTransaction() throws Exception {
        TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
        TransitionalTxManagementKernelTransaction tx = (TransitionalTxManagementKernelTransaction)Mockito.mock(TransitionalTxManagementKernelTransaction.class);
        Mockito.when((Object)kernel.newTransaction()).thenReturn((Object)tx);
        TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
        Mockito.when((Object)registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        QueryExecutionEngine executionEngine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        QuerySessionProvider querySessionProvider = (QuerySessionProvider)Mockito.mock(QuerySessionProvider.class);
        TransactionHandle handle = new TransactionHandle(kernel, executionEngine, registry, uriScheme, (LogProvider)NullLogProvider.getInstance(), querySessionProvider);
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement[0]), output, (HttpServletRequest)Mockito.mock(HttpServletRequest.class));
        handle.terminate();
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)1))).terminate();
    }

    @Test
    public void deadlockExceptionHasCorrectStatus() throws Exception {
        QueryExecutionEngine executionEngine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        Mockito.when((Object)executionEngine.executeQuery(Matchers.anyString(), Matchers.anyMap(), (QuerySession)Mockito.any(QuerySession.class))).thenThrow(new Throwable[]{new DeadlockDetectedException("deadlock")});
        TransactionHandle handle = new TransactionHandle(this.mockKernel(), executionEngine, (TransactionRegistry)Mockito.mock(TransactionRegistry.class), uriScheme, (LogProvider)NullLogProvider.getInstance(), (QuerySessionProvider)Mockito.mock(QuerySessionProvider.class));
        ExecutionResultSerializer output = (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class);
        handle.execute((StatementDeserializer)StubStatementDeserializer.statements(new Statement("query", MapUtil.map((Object[])new Object[0]), false, (ResultDataContent[])null)), output, (HttpServletRequest)Mockito.mock(HttpServletRequest.class));
        ((ExecutionResultSerializer)Mockito.verify((Object)output)).errors((Iterable)Mockito.argThat(TransactionHandleTest.hasErrors(new Status[]{Status.Transaction.DeadlockDetected})));
    }

    private TransitionalPeriodTransactionMessContainer mockKernel() {
        TransitionalTxManagementKernelTransaction context = (TransitionalTxManagementKernelTransaction)Mockito.mock(TransitionalTxManagementKernelTransaction.class);
        TransitionalPeriodTransactionMessContainer kernel = (TransitionalPeriodTransactionMessContainer)Mockito.mock(TransitionalPeriodTransactionMessContainer.class);
        Mockito.when((Object)kernel.newTransaction()).thenReturn((Object)context);
        return kernel;
    }

    private static Matcher<Iterable<Neo4jError>> hasNoErrors() {
        return TransactionHandleTest.hasErrors(new Status[0]);
    }

    private static Matcher<Iterable<Neo4jError>> hasErrors(Status ... codes) {
        final HashSet<Status> expectedErrorsCodes = new HashSet<Status>(Arrays.asList(codes));
        return new TypeSafeMatcher<Iterable<Neo4jError>>(){

            protected boolean matchesSafely(Iterable<Neo4jError> item) {
                HashSet<Status> actualErrorCodes = new HashSet<Status>();
                for (Neo4jError neo4jError : item) {
                    actualErrorCodes.add(neo4jError.status());
                }
                return expectedErrorsCodes.equals(actualErrorCodes);
            }

            public void describeTo(Description description) {
                description.appendText("Errors with set of codes").appendValue((Object)expectedErrorsCodes);
            }
        };
    }
}

